#include <CombieAdc.h>
using Combie::Adc;

/**
 * 
 * Die ADC Vorteiler durchtesten
 * 
 * A0 fest auf Vcc gelegt
 * A1 fest auf GND gelegt
 * A2 an einen Spannungsteiler 2 X 1K, also auf 1/2 Vcc gelegt
 * 
 * Ausgabe:
 * Waehle den seriellen Plotter im Werkzeuge Menue der IDE
*/

Adc adc;

Adc::AnalogClockDivisor AdcTeiler[] =
{
  Adc::DIV_2,
  Adc::DIV_4,
  Adc::DIV_8,
  Adc::DIV_16,
  Adc::DIV_32,
  Adc::DIV_64,
  Adc::DIV_128,
};



void  setup() 
{
   Serial.begin(9600);

   adc  .enable()
        .setResolution(Adc::RES_10BIT)
        .setReference(Adc::REF_VCC);

}

void loop() 
{
  static int count = 0;
  static int index = 0;

  if(count > 20)
  {
    count = 0;
    index = ++index % sizeof(AdcTeiler); // wrapp around
  }
  adc.setClockDivisor(AdcTeiler[index]);
  Serial.print(index * 10); // Stufen zeigen
  Serial.print(" ");
  Serial.print(adc(Adc::MUX_ADC0));
  Serial.print(" ");
  Serial.print(adc(Adc::MUX_ADC1));
  Serial.print(" ");
  Serial.print(adc(Adc::MUX_ADC2));
  Serial.println();
  count++;
 }
