#include <CombieAdc.h>
using Combie::Adc;


#ifndef ADC_MODELL_WITH_THERMO 
  #error Dieser AVR hat keinen eingebauten Temperatursensor
#endif

/**
 * 
 * Lesen des eingebauten Temperatursensors 
 * Ausgabe der Temperatur
 * 
 * Kalibrierung
 * wir brauchen, einen UNO, ein Referenzthermometer, einen Kühlschrank und einen Backofen
 * 
 * Messwertaufnahme Kalibrierpunkt 1
 * Uno in Plastiktüte in den Kühlschrank
 * Referenz Termometer beilegen
 * Dann zügig den ADC Wert auslesen
 * 
 * Messwertaufnahme Kalibrierpunkt 2
 * Uno in den Backofen, kleinste Stufe
 * Referenz Termometer beilegen
 * Dann zügig den ADC Wert auslesen
 * 
 * Die beiden Referenzpunkte in den Code eintragen
 * 
 * 
 * Tipp:
 * http://www.atmel.com/Images/Atmel-8108-Calibration-of-the-AVR%27s-Internal-Temperature-Reference_ApplicationNote_AVR122.pdf
 * https://de.wikipedia.org/wiki/Punktsteigungsform
 * 
*/

Adc adc;

struct Kalibrierung
{
   // Werte für die 2 Punkt Kalibrierung 
  int   a1; // ADC Wert bei niedriger Temperatur
  float t1; // gemessene niedrige Temperatur
  float m ; // Steigung
  
  Kalibrierung(int a1, float t1,int a2, float t2): a1(a1),t1(t1) 
  {
    m = (t2-t1)/(a2-a1); // Steigung berechnen
  }
  
  float operator()(int analogValue) // adc2temperatur
  {
    return m*(analogValue-a1)+t1;
  }
};

// hier bitte die beiden Messpunkte für die Kalibrierung eintragen
// im Beispiel sind das:
// Punkt 1: 342 bei 9.5 Grad
// Punkt 2: 397 bei 53.2 Grad
Kalibrierung kalibriere(342,9.5,397,53.2);


void setup() 
{
   Serial.begin(9600);

   adc  .enable()
        .setReference(Adc::REF_11)
        .setClockDivisor(Adc::DIV_128)
        .setSource(Adc::MUX_THERMO);
}

void loop() 
{
  int   adcWert    = adc();
  float temperatur = kalibriere(adcWert);
  
  Serial.print("Gelesener ADC Wert ");      Serial.println(adcWert);
  Serial.print("kalibrierte Temperatur ");  Serial.println(temperatur,1);
  Serial.println("---");
  delay(1000);
}
