#include <CombieAdc.h>

#include <util/atomic.h>

#ifndef ADC_MODELL_WITH_THERMO 
  #error Dieser AVR hat keinen eingebauten Temperatursensor
#endif

/**
 * 
 * Den eingebauten Temperatursensor im Interruptbetrieb lesen
 * 
 * Beachte:
 * Die CallBack Funktion läuft im Interrupt Kontext.
 * Also müssen alle genutzten Variablen als volatile 
 * deklariert werden, und aus dem Hauptprogramm muss darauf
 * Atomar zugegriffen werden
 * 
 * Setup:
 * ADC Einstellungen 
 * Interrupt ettablieren
 *  
 * In loop: 
 * Messwert lesen
 * Ausgabe
 * 
 * Tipp:
 * http://www.atmel.com/Images/Atmel-8108-Calibration-of-the-AVR%27s-Internal-Temperature-Reference_ApplicationNote_AVR122.pdf
 * 
*/

using Combie::Adc;
Adc adc;


volatile unsigned long irqCount;
volatile int tempWert;



void adcCallBack(int value)
{
  irqCount++;
  tempWert = value;
}




void setup() 
{
   Serial.begin(9600);

   adc  .enable()
        .setReference(Adc::REF_11)
        .setClockDivisor(Adc::DIV_128)
        .setSource(Adc::MUX_THERMO)
        .setCallBack(adcCallBack)
        .enableAutoTrigger()
        .setTrigger(Adc::TRIG_FREERUNNING)
        .enableIrq()
        .startConversion();
}

void loop() 
{
  unsigned long count;
  int wert;
  
  ATOMIC_BLOCK(ATOMIC_RESTORESTATE)
  {
    count = irqCount;
    wert  = tempWert;
    irqCount = 0;
  }
 
  Serial.print("Gelesener Temperatur Wert ");
  Serial.println(wert);
  Serial.print("Anzahl Interrupts pro Sekunde ");
  Serial.println(count);
  Serial.println("---");
  delay(1000);
}
