# Combie Timer Library for Arduino

Eine [Arduino](http://arduino.cc) Library um bliche Zeitabhandlungen in Arduino Programmen abzuhandeln. Diese Lib basiert auf dem, im [BinkWithoutDelay](https://www.arduino.cc/en/Tutorial/BlinkWithoutDelay) vorgestelltem Konzept. 


## Die Sache mit dem Delay
Die Combie Timer Klassen blockieren nicht den Programmfluss. Aus dem Grund gibt es auch keinen direkten Ersatz fr delay(). Und sowieso, gegen Delays gibt es wenig zu sagen, wenn sie denn den Programmfluss nicht stren. 

### Woher kommt das Bedrfnis nach einem Delay?
Es ist eine Frage, der Sicht auf die Dinge. Beinahe zwangslufig kommt ein jeder Arduino User auf die Idee, Programmflussdiagramme zu malen, und sei es nur im Kopf. Hier scheint fr viele Menschen das Programmflussdiagramm, das natrlichste von der Welt zu sein. Es drfte u.A. daran liegen, dass ein solches, dem fertigen Programm dann am hnlichsten sieht, bzw. sehen sollte. Betrachtet man den logischen Fluss eines Programmes, dann erscheinen, an manchen Stellen, Wartezeiten unabdingbar. Oft sind sie es auch.

Dieser missliche Umstand zwingt den Programmierer, sein Flussdiagramm an der Stelle aufzubrechen. Schleifen so zu verzerren, dass in der Wartezeit noch andere Dinge erledigt werden knnen. Das lenkt von der eigentliche Aufgabe ab.

Keine Frage: Programmflussdiagramme sind wichtig!
Sie sind eine groe Hilfe, ein wunderbares Werkzeug, wenn man sich und anderen, den logischen Fluss eines Programms verdeutlichen mchte. Aber sie haben ihren Knackpunkt in der Nebenlufugkeit. Jeder nebenlufige Prozess, Task, oder wie immer man es auch nennen mchte, bekommt sein eigenes Programmflussdiagramm. Und kurz vor der Implementierung hat man dann eine Handvoll Programmflussdiagramme, welche miteinander zeitlich verwoben werden wollen.
Dabei werden sie manchmal bis zur Unkenntlichkeit zerrissen, um diese verflixte Nebenlufigkeit da rein zu prgeln.

**Fazit**
1. Wartezeiten sind unabdingbar, aber Delays stehen einem oftmals im Wege rum.
2. Programmflussdiagramme sind klasse, verbergen aber manchmal, den Blick auf das, was man wirklich erreichen mchte.



### Die Datenfluss orientierte Sicht auf die Dinge



--------------



[Basic writing and formatting syntax](https://help.github.com/articles/basic-writing-and-formatting-syntax/)