#include <CombieTimer.h>
#include <CmdMessenger.h>
// siehe: http://playground.arduino.cc/Code/CmdMessenger


/*
 * Blink without delay()
 * in der sicherlich tausendsten Variante.
 *
 * Einstellbar ueber die seriele Konsole
 * 
 * Kommandos:
 * die 1 stellt die Puls- und Pausenzeit ein, erwartet 2 Parameter
 * die 2 schaltet Blinken ein oder aus, erwartet 1 Parameter
 * ein ; schliesst das Kommando ab.
 * 
 * Beispiel: 
 * 
 * 1,10,1000; 
 * kurzes Aufblitzen, dann 1 Sekunde aus
 * 
 * 1,500,500; 
 * gleichmaessiges blinken, 1Hz
 * 
 * 
 * 2,1;
 * Blinken ein
 * 
 * 2,0;
 * Blinken aus
 * 
 * Tipp:
 * Um den Blinker blinken zu sehen, muss man ihn mit "2,1;" einschalten
 * 
 */




enum Kommando : byte {
                       SetZeit  = 1,
                       SetOnOff = 2,      
                     };

Combie::Timer::PpmGenerator blinker(1000,1000);
CmdMessenger cmdMessenger(Serial);
bool blinkAnforderung = false; // Blinkanforderung default aus


void cmdMmessengerZeitCallBack()
{
  blinker.setOnInterval(cmdMessenger.readInt32Arg());
  blinker.setOffInterval(cmdMessenger.readInt32Arg());
}

void cmdMmessengerBlinkAnforderungCallBack()
{
  blinkAnforderung = cmdMessenger.readBoolArg();
}

void setup() 
{
  Serial.begin(9600);
  pinMode(LED_BUILTIN,OUTPUT);
  cmdMessenger.attach(SetZeit, cmdMmessengerZeitCallBack);
  cmdMessenger.attach(SetOnOff,cmdMmessengerBlinkAnforderungCallBack);
}

void loop() 
{
  digitalWrite(LED_BUILTIN,blinker && blinkAnforderung);
  cmdMessenger.feedinSerialData();
}
