/**
 *    Ablaufdiagramm - Zeitdiagramm
 *    
 *        S1    _----------_____  Schalterstellung
 *        OUT1  _-------------__  Verzoegertes abschalten
 *        OUT2  ____-------_____  Verzoegertes einschalten
 *        Der Schalter S1 arbeitet invers und ist entwpellt
 *        Alle Zeiten in ms
 *
*/

#include <CombieTimer.h>
using namespace Combie::Timer;

const byte S1   = 2; // Schalter Pin
const byte OUT1 = 3; // Ausgang
const byte OUT2 = 4; // Ausgang

EntprellTimer    entprell(20); // Schalter entprellen
RisingEdgeTimer  ton(500);     // steigende Flanke wird verzoegert
FallingEdgeTimer toff(500);    // abfallende Flanke wird verzoegert
 
void setup(void) 
{
  pinMode(S1,INPUT_PULLUP);
  pinMode(OUT1,OUTPUT);
  pinMode(OUT2,OUTPUT);
}

void loop(void) 
{
  bool schalter = entprell(!digitalRead(S1)); // invers wg. pullup
  digitalWrite(OUT1, toff(schalter));
  digitalWrite(OUT2, ton(schalter));
}
