/**
 * 8 Taster, gegen GND geschaltet
 * also invers funktionierend
 * 
 * 8 Relais auf einer der China üblichen Relaiskarte
 * ebenfalls invers schaltend
 * 
 * Die Entprellzeit von 20ms ist in CombieTimer als default 
 * vorgegeben. 
 * 
 * Funktion:
 * Jeder Tastendruck toggelt den Schaltzustand des zugehörigen Relais.
 */

#include <CombiePin.h>
#include <CombieTimer.h>
#include <CombieTools.h>



class Task // Interface
{
  public:
  virtual void init() = 0;
  virtual void run()  = 0;
};

template<byte inPin,byte outPin>
class Taster2Relais: public Task
{
  private:
  Combie::Pin::TasterGND<inPin>    taster;
  Combie::Pin::RelaisINV<outPin>   relais;
  Combie::Timer::EntprellTimer     entpreller;
  Combie::Tools::FlankenErkennung  flankenerkennung;

  public:
  virtual void init()
  {
    taster.initPullup();
    relais.init();
  }

  virtual void run()
  {
    if(flankenerkennung = entpreller = taster) relais.toggle();
  }
};


Task * tasks[] = { 
                   new Taster2Relais<2,10>(), 
                   new Taster2Relais<3,11>(), 
                   new Taster2Relais<4,12>(), 
                   new Taster2Relais<5,13>(), 
                   new Taster2Relais<6,A0>(), 
                   new Taster2Relais<7,A1>(), 
                   new Taster2Relais<8,A2>(), 
                   new Taster2Relais<9,A3>(), 
                 };

               
void setup() 
{
  for(Task * i:tasks) i->init();
}

void loop() 
{ 
  for(Task * i:tasks) i->run();
}
