#include <CombiePin.h>
#include <CombieTimer.h>
#include <CombieTools.h>

using Combie::Tools::FlankenErkennung;
using Combie::Timer::EntprellTimer;


using EingabeTaster = Combie::Pin::TasterGND<2>; // Taster zwischen Pin und GND(invertierend)
using Counter       = Combie::Tools::Counter<uint16_t>;

EingabeTaster     taster; 
EntprellTimer     entprellen(20);
FlankenErkennung  flankenerkennung;
Counter           counter;



auto callBack = [](Counter &counter)   // Lambda Funktion
                {
                  Serial.println(counter);
                };

void setup() 
{
  Serial.begin(9600);
  taster.initPullup();
  counter.onCount(callBack);
}

void loop() 
{
  counter = flankenerkennung = entprellen = taster;
}