/**
 * 
 * LED Schaltfolge
 * 
 * Ein Taster, zwei LEDs
 * 
 * Startzustand beide aus.
 * Erster Tastendruck, led1 geht an
 * Zweiter Tastendruck, led2 geht an
 * Dritter Tastendruck, beide LEDs gehen aus, Automat geht in den Startzustand
 * 
 * 
 * 
 */

#include <CombiePin.h>
#include <CombieTimer.h>
#include <CombieTools.h>

using Combie::Tools::FlankenErkennung;
using Combie::Tools::Counter;
using Combie::Timer::EntprellTimer;
using Combie::Pin::OutputPin; 
using Combie::Pin::TasterGND; 



TasterGND<2>      taster; // Taster gegen GND geschaltet
OutputPin<13>     led1;
OutputPin<12>     led2;
EntprellTimer     entprellen(20);
FlankenErkennung  flankenerkennung;
Counter<byte>     counter;

void ledAutomat();

void setup() 
{
    taster.initPullup();
    led1.init();
    led2.init();
}

void loop() 
{ 
  ledAutomat();
}


void ledAutomat() // ein endlicher Automat
{
  if(flankenerkennung = entprellen = taster)
  {
    // Automat weiter schalten und Ausgang setzen
    switch(++counter) // "count" haelt den Zustand des Automaten
    {
      case 1: led1.toggle();  // Erster Tastendruck, led1 geht an
              break;
              
      case 2: led2.toggle();  // Zweiter Tastendruck, led2 geht an
              break;
              
      case 3:                  // Dritter Tastendruck, beide LEDs gehen aus
      default: led1.toggle();
               led2.toggle();
               counter.reStart();  // Startzustand wieder herstellen
    }
  }
}