/**
 * 
 * LED Schaltfolge
 * 
 * Ein Taster, zwei LEDs
 * 
 * Startzustand beide aus.
 * Erster Tastendruck, led1 geht an
 * Zweiter Tastendruck, led2 geht an
 * Dritter Tastendruck, beide LEDs gehen aus, Automat geht in den Startzustand
 * 
 * 
 * 
 */

#include <CombiePin.h>
#include <CombieTimer.h>
#include <CombieTools.h>

using namespace Combie::Tools;
using namespace Combie::Timer;
using namespace Combie::Pin; 

using CounterType = Counter<byte>;

TasterGND<2>      taster; // Taster gegen GND geschaltet
OutputPin<13>     led1;
OutputPin<12>     led2;
EntprellTimer     entprellen(20);
FlankenErkennung  flankenerkennung;
CounterType       counter;


void ledAction(CounterType &counter) 
{
    switch(counter) // "counter" haelt den Zustand des Automaten
    {
      case 1: led1.setHigh();  // Erster Tastendruck, led1 geht an
              break;
              
      case 2: led2.setHigh();  // Zweiter Tastendruck, led2 geht an
              break;
              
      case 3:                  // Dritter Tastendruck, beide LEDs gehen aus
      default: led1.setLow();
               led2.setLow();
               counter.reStart();  // Startzustand wieder herstellen
    }
}

void setup() 
{
    taster.initPullup();
    led1.init();
    led2.init();
    counter.onCount(ledAction);
}

void loop() 
{ 
  counter = flankenerkennung = entprellen = taster;
}

