#include <CombieTimer.h>
#include <CombieTools.h>

using Combie::Timer::PpmGenerator;
using Combie::Tools::FlankenErkennung;

const byte CLOCK = 13; 
const byte DATA  = 11; 
const byte LATCH = 12; 

const byte patterns[] = {
                            B00000001,
                            B00000010,
                            B00000100, 
                            B00001000,
                            B00010000,
                            B00100000, 
                            B01000000,
                            B10000000, 
                            B00000000, 
                            B01110000, 
                            B00011100, 
                            B10000011, 
                            B11100000, 
                            B00110000,
                        };

                        

FlankenErkennung positiveFlanke;
FlankenErkennung negativeFlanke;
PpmGenerator ppmgenerator(50,1950); // Puls Pausen Generator


void schiebeRaus(const byte value)
{
  digitalWrite(LATCH, LOW);
  shiftOut(DATA, CLOCK, MSBFIRST, value);
  digitalWrite(LATCH, HIGH); 
}


void setup() 
{
  pinMode(LATCH, OUTPUT);
  pinMode(CLOCK, OUTPUT);
  pinMode(DATA,  OUTPUT);
}

void loop() 
{
  bool  ppmsignal = ppmgenerator;
  
  if(positiveFlanke = ppmsignal)
  {
     int zufall = random(0, sizeof(patterns));
     schiebeRaus(patterns[zufall]);
  }
  
  if(negativeFlanke = !ppmsignal)
  {
     schiebeRaus(0);  
  }
}
