#include <CooperativeTask.h>

const unsigned long leuchtDauer = 2000; // Ampeltakt
bool piepflag = false;                  // Merker

class Piepser : public Task
{
  protected:
   int i = 0; 

  public:
    Piepser():i(0){}

    void run() // 5 mal piepsen, wenn Flag gesetzt
    {
       
      TaskBlock
      {
        taskWaitFor(piepflag);
        for(i = 0; i < 5; i++) // diese Schleife blockiert nicht
        {
           Serial.println(F("Piep"));
           taskSwitch();
        }
        piepflag = false; // fertig mit piepsen
      }
    }
};

class Ampel: public Task // Ampelschaltung
{
  protected:
    unsigned long i = 0; // zählt die Ampelaufrufe

  public:
    virtual void run()
    {
      i++;
  
      TaskBlock
      { 
          // rotPhase
          Serial.print(i);
          Serial.println(F(" Rot an - Gelb aus - Gruen aus"));
          taskPause(leuchtDauer);
          
          
          // gelbPhase Type: Mit Rot
          Serial.print(i);
          Serial.println(F(" Rot an - Gelb an - Gruen aus"));
          taskPause(leuchtDauer);
        
          
          // grünPhase
          Serial.print(i);
          Serial.println(F(" Rot aus - Gelb aus - Gruen an"));
          piepflag = true; // 5 mal piepsen
          taskPause(leuchtDauer);
         
          
          // gelbPhase Type: ohne Rot
          Serial.print(i);
          Serial.println(F(" Rot aus - Gelb an - Gruen aus"));
          taskPause(leuchtDauer);
     }
   } 
};

Ampel ampel;
Piepser piepser;

void setup() 
{
  Serial.begin(9600);
  Scheduler::instance().init();
}

void loop() 
{
  Scheduler::instance().run();  
}
