#pragma once

#include <CooperativeTask.h>


class BlinkTask: public Task
{
  protected:
    const byte pin;
    const unsigned long interval;
  
  public:
    BlinkTask(const byte pin,const unsigned long interval):
       pin(pin),
       interval(interval)
    {
    }
    
    virtual void init() 
    {
      Serial.print("BlinkTask begin, pin: "); Serial.println(pin);
      pinMode(pin,OUTPUT);
    }
    
    virtual void run() 
    {
      TaskBlock
      {
        digitalWrite(pin,HIGH);
        taskPause(interval);
        digitalWrite(pin,LOW);
        taskPause(interval);
      }
    }
    

    virtual ~BlinkTask()
    {
      digitalWrite(pin,LOW);
      pinMode(pin,INPUT);
    }

};
