#pragma once

#include <CooperativeTask.h>
#include <Streaming.h>


class SchedulerLoopCountTask: public Task
{
  protected:
    const unsigned long interval;
    unsigned long count;
    
  
  public:
    SchedulerLoopCountTask(const unsigned long interval):
       interval(interval),
       count(0){}
     
    virtual void run() 
    {
      count++;
      TaskBlock
      {
        taskPause(interval);
        Serial << F("Scheduler loops: ") << count << F(" per ") << interval << F("ms") << endl;
        count = 0;
      }
    }

} schedulerLoopCountTask(1000);
