#pragma once
#include "ListNode.h"

/**
 *  Kopf einer einfach verketteten Liste
 *  Neue Elementer werden an den Anfang gehangen
 *  
 * Hier mal eine Erklaeung zu dem Prinzip
 * https://www.virtual-maxim.de/dynamische-datenstrukturen--einfach-verkettete-liste/
 *
 *
 */




template<typename ClientClass>
class List 
{
  
  protected:
    ClientClass *first;

  
  public: 
    List<ClientClass>():first(nullptr){}
  
    void add(ClientClass *client)
    {
      ClientClass *temp = first;
      first = client;
      client->next = temp;
    }
  
    ClientClass *getFirst()
    {
      return first; 
    }
    
    ClientClass *getNext(ClientClass *node)
    {
      if(node) node = node->next;
      return node;
    }
  
    void remove(ClientClass *node)
    {
      ClientClass *temp = first;
      if(!first) return;
      
      if(first == node)
      {
        first = node->next;
        return;
      }else
      {
        while(temp)
        {
          if(temp->next == node)
          {
            temp->next = temp->next->next;
            return;
          }
          temp = node->next;
        }
      }
    }
};
