#pragma once

#include "List.h"
#include "Task.h"
#include "Singleton.h" 



class Scheduler : public Singleton<Scheduler>
{
  friend class Task;
  friend class Singleton;
  
  private:
    List<Task> list;
    Scheduler(){};
   
    void remove(Task *task)
    {
      list.remove(task);
    }

 public:
    void add(Task *task)
    {
      list.add(task);
    }
    
    void init()
    {
       for(Task *i = list.getFirst();i;i = list.getNext(i))
       {
          i->init();
       }
    }
     
    void run()
    {
      for(Task *i = list.getFirst();i;i = list.getNext(i))
      {
        i->run();
      }  
    }

};
