#pragma once

/**
 *
 * Erste Vorstellung:
 * https://forum.arduino.cc/index.php?topic=578831.msg3955998#msg3955998
 * 
 * Implementiert:
 * https://de.wikipedia.org/wiki/Singleton_(Entwurfsmuster)
 * 
 */

template<typename ClientClass>
class Singleton
{
     
  private:
    static ClientClass *self;
    
  protected:
    Singleton(){}

  public:
    static ClientClass &instance()
    {
       if (!self) self = new ClientClass;
       return *self;
    }
     
    virtual ~Singleton()
    {
       delete self;
       self = nullptr;
    }
  };
 
template<typename ClientClass> ClientClass* Singleton<ClientClass>::self = nullptr;
