#pragma once

/**
 * entnommen aus
 * https://forum.arduino.cc/index.php?topic=415229.0
 * 
 * Umgestellt vun switch/case zu computed goto
 * https://eli.thegreenplace.net/2012/07/12/computed-goto-for-efficient-dispatch-tables
 * 
 *
 */
 


#define LC_CONCAT2(s1,s2) s1##s2
#define LC_CONCAT(s1,s2) LC_CONCAT2(s1,s2)

#define TaskBlock if(!lable)  \
lable = &&taskLableStart;     \
goto *lable ;                 \
taskLableStart:               \
while(1)


// Task Kontroll Worte, diese werden Taskwechsel einleiten
#define taskSwitch()                               \
do {                                               \
      lable = &&LC_CONCAT(taskLable, __LINE__);    \
      return;                                      \
      LC_CONCAT(taskLable, __LINE__):;             \
    } while(0)
    
#define taskPause(Task_interval)                                      \
timeStamp = millis();                                                 \
while((millis() - timeStamp) < (Task_interval)) taskSwitch()

#define taskWaitFor(Task_condition) while(!(Task_condition)) taskSwitch();

     

// Benennen und anspringen von Schrittketten Verzweigungen
#define taskStepName(Task_stepname) LC_CONCAT(Task_step_,Task_stepname):
#define taskJumpTo(Task_stepname)  taskSwitch(); goto LC_CONCAT(Task_step_,Task_stepname) 
