#pragma once

#include <Arduino.h>

extern bool DoINTERVAL; // Merker für das Interval Macro



// Start of Interval Macro
#define INTERVAL_1(interval)                   \
{                                              \
  static unsigned long lastHit = 0;            \
  DoINTERVAL = millis() - lastHit >= (interval); \
  if(DoINTERVAL) lastHit = millis();           \
}                                              \
if(DoINTERVAL)
// End of Interval Macro 


// Start of Interval Macro
#define INTERVAL_2(interval,firstInterval)     \
{                                              \
  static unsigned long lastHit = 0;            \
  static bool firstRun = true;                 \
  DoINTERVAL = millis() - lastHit >= (firstRun?(firstInterval):(interval)); \
  if(DoINTERVAL)                   \
  {                                \
     lastHit = millis();           \
     firstRun = false;             \
  }                                \
}                                  \
if(DoINTERVAL)
// End of Interval Macro 

//#define INTERVAL_X(x,A,B,FUNC, ...)  FUNC 
#define INTERVAL_X(x,A,B,INNER_INTERVAL, ...)  INNER_INTERVAL 

#define INTERVAL(...)    INTERVAL_X(,##__VA_ARGS__,\
                         INTERVAL_2(__VA_ARGS__),\
                         INTERVAL_1(__VA_ARGS__),\
                         INTERVAL_0(__VA_ARGS__)\
                                         ) 


