/* ----------------------------------------------------------
                      melody_player.c

     Melodienspieler mit Nutzung eines 8-Bit Timers im
     Overflow Modus.

     Spielt:

     - Leise rieselt der Schnee
     - Schneewalzer

     MCU     : ATtiny2313, ATtiny13, ATtiny25 - 85
               ATtiny24 - 84
               ATmega8, ATmega48 - 328p

     F_CPU   : 4,8 MHz; 8 MHz; 9,6 MHz; 16 MHz

     02.12.2019
   ---------------------------------------------------------- */

/*
                    Anschluss Lautsprecher

                     +Ub
                      ^
                      |
                     ,-,
                     | | 16 - 390  ( je nach gewuenschter Lautstaerke )
                     '-'
                      |
                      |
                     ,-,/|
                     | | |
                     '-'\|
                      |
            2,2k      |
            ___     |/
   o-------|___|----|  BC549
Input               |>
von Portpin           |
                      |
                      |
                      |
                     ---

*/

#include <util/delay.h>
#include <avr/io.h>
#include "toene_melodie.h"

const uint8_t schneew[] PROGMEM =       { "c4 d4 e2 g4 e2 g4 e1 d4"                 \
                                          "e4 f2 g4 f2 g4 f1 g4 a4"                 \
                                          "h2+f4-h2+f4-h1 a4 h4+c2"                 \
                                          "e4 c2-a4 g1 e4 g4+c1-h1"                 \
                                         "+d1 c1-a2+c4-a2+c4-a1" };

const uint8_t leise_rieselt[] PROGMEM = { "a4 a8 g8 a8 g8 f2 p8"                    \
                                          "f4 d8 f8 e8 d8 c2 p8"                    \
                                          "g8 F8 g8 A8 a8 g8 f2 p8"                 \
                                          "g8 d9 d8 e8 d8 e8 f2" };


/* ---------------------------------------------------------------------------
                                    M A I N
   --------------------------------------------------------------------------- */
int main(void)
{
  speaker_init();
  timer0_init();

  playtempo= 10;
  playstring(&leise_rieselt[0]);

  _delay_ms(1000);

  playtempo= 5;
  playstring(&schneew[0]);

  while(1);
}
