/* ----------------------------------------------------------
                    toene_melodie.h

     Header fuer Softwaremodul
     Einfacher Rechteckgenerator fuer Noten der C-DUR
     Tonleiter mit Notenstring-Parser


     MCU     : ATmega8, ATmegaxx8, ATtinyx4, ATtinyx5
               ATtiny13, ATtiny2313
     F_CPU   : 4,8MHz, 8MHz, 9,6MHz, 16MHz

     02.12.2019  R. Seelig
   ---------------------------------------------------------- */

#ifndef in_toene_melodie
  #define in_toene_melodie

  #include <util/delay.h>
  #include <avr/io.h>
  #include <avr/interrupt.h>
  #include <avr/pgmspace.h>



  // -------------- Lautsprecheranschluss ---------------------
  #define speaker_port     B
  #define speaker_portnum  4


  // ----------------- globale Variable -----------------------
  extern volatile uint8_t sound;          // kann generell Frequenzerzeugung ein- oder ausschalten
                                          // 0 = Ton aus; 1 = Ton an

  extern uint16_t playtempo;              // Grundgeschwindigkeit, mit der ein Notenstring
                                          // abgespielt wird

  // --------------------- Prototypen -------------------------

  void timer0_init(void);
  void playnote(char note);
  void playstring(const unsigned char* const s);


  /* ----------------------------------------------------------
       ab hier "nur" Makrodefinitionen zum Anpassen an unter-
       schiedliche MCU, sowie zum Initialisieren des
       Lautsprecheranschlusspins (gemaess den Angaben in
       speaker_port und speaker_portnum)
     ---------------------------------------------------------- */

    // Anpassen der Registernamen an den ATmega8
  #if defined __AVR_ATmega8__

    #define TIMSK0    TIMSK
    #define TCCR0B    TCCR0

  #endif


    // Anpassen der Registernamen an den ATtiny2313
  #if defined __AVR_ATtiny2313__ || __AVR_ATtiny45__ || __AVR_ATtiny25__ || __AVR_ATtiny85__

    #define TIMSK0    TIMSK

  #endif


  // ----------------------------------------------------------------
  // Praeprozessormacros um 2 Stringtexte zur weiteren Verwendung
  // innerhalb des Praeprozessors zu verknuepfen
  //
  // Bsp.:
  //        #define ionr      A
  //        #define ioport    CONCAT(PORT, ionr)
  //
  //        ioport wird nun als "PORTA" behandelt

  #define CONC2EXP(a,b)     a ## b
  #define CONCAT(a,b)       CONC2EXP(a, b)
  // ----------------------------------------------------------------


  /* ----------------------------------------------------------------
        Makros zum Initialisieren sowie setzen und reseten des
        Lautsprecheranschlusspins
     ---------------------------------------------------------------- */
  #define SPKPORT           CONCAT(PORT, speaker_port)
  #define SPKDDR            CONCAT(DDR, speaker_port)

  #define speaker_mask      (1 << speaker_portnum)

  #define speaker_init()    SPKDDR |= speaker_mask
  #define setspk()          SPKPORT |= speaker_mask
  #define clrspk()          SPKPORT &= ~(speaker_mask)

#endif
