/*****************************************************************************
 Basisprojekt fr die SPS-Ctrl (MEGA32 oder MEGA644)
 
 !!!!!!!!!!! CPU & QUARZ sind im Makefile einzustellen !!!!!!!!!!!!
 Datei: timer.h beachten, dort werden die Reloadwert eingestellt.

 Es sind Dateien fr alle wichtigen Komponenten der SPS-Ctrl in diesem Projekt
 vorhanden:
 - I2C - EEPROM & Echtzeituhr
 - RC5-Empfnger
 - Display & Tastatur
 - Analogeingnge
 
 Mit diesem Projekt als Basis sollte der Start fr sein eigenes Projekt 
 vereinfacht werden. Viel Erfolg.
 
 
 -----------------------------------------------------------------------------
 08/2006 - Ingo Busker
 http://www.mikrcontroller.com       http://www.microsps.com
*****************************************************************************/

#include "main.h"
unsigned int AnalogWerte[3];

// ---------------------------------------------------------------------------------------
void ADC_Init(void)
{
  ADMUX = 0;
  ADCSRA = 0x86;
}

// ---------------------------------------------------------------------------------------
unsigned int ReadADC(unsigned char adc_input)
{
 ADMUX = adc_input;
 ADCSRA |= 0x40;
 //Delay_ms(10);
 while ((ADCSRA & 0x10) == 0);
 ADCSRA |= 0x10;
 return ADCW;   // read ad and calc. temp.
}

void GetAnalogWerte(void)
{
#ifdef AVR_CTRL_PLATINE
 AnalogWerte[0] = ReadADC(0);
 AnalogWerte[1] = ReadADC(1);
 AnalogWerte[2] = ReadADC(2);
#else
 AnalogWerte[0] = ReadADC(3);
 AnalogWerte[1] = ReadADC(2);
 AnalogWerte[2] = ReadADC(1);
#endif

// AnalogWerte[4] = ReadADC(4);
}
 