/*#######################################################################################
AVR Small Webserver 

Copyright (C) 2004 Ulrich Radig

#######################################################################################*/

#include "main.h"
#include "ethernet.h"
#include "socket.h"

//Prototype
int get (unsigned char);
#if defined (__AVR_ATmega32__)	
	SIGNAL (SIG_INTERRUPT0);
#endif	
#if defined (__AVR_ATmega103__)
	SIGNAL (SIG_INTERRUPT4);
#endif	
#if defined (__AVR_ATmega128__)
	SIGNAL (SIG_INTERRUPT4);
#endif

#if defined (__AVR_ATmega32__)	
	SIGNAL (SIG_INTERRUPT0)
#endif	

#if defined (__AVR_ATmega103__)
	SIGNAL (SIG_INTERRUPT4)
#endif
	
#if defined (__AVR_ATmega128__)
	SIGNAL (SIG_INTERRUPT4)
#endif
{
	//printf ("interrupt\n");
	//Globale Interrupts Ausschalten
	cli ();
	
	char ByteH = 0;
	char ByteL = 1;		

	//if the receive buffer has been overrun
	if ( (ReadRTL(ISR)&(1<<OVW)) != 0)
		{
		printf ("Overrun!\n");
		}
		
	//gehe zu Routine GET wenn ein Packet empfangen wurde
	if ( (ReadRTL(ISR) & (1<<PRX)) != 0)
		{
		//NIC FIFO noch nicht leer
		//gehe zu Routine GET und lese ein weiteres Packet
		while (ByteL != ByteH) //(!= bedeutet ungleich)
			{
			ByteL = ReadRTL(BNRY); //auslesen NIC Register bnry
			//printf("%d ", ByteL);
			get (ByteL);
			//auslesen des Empfangsbuffer BNRY = CURR 
			
			WriteRTL ( CR ,(1<<STA|1<<RD2|1<<PS0));

			ByteH = ReadRTL(CURR); //auslesen NIC Register curr
			//printf("%d ", ByteH);
			
			WriteRTL ( CR ,(1<<STA|1<<RD2));                          
			} 
		}
		
	//Zurcksetzen der Interrupt Bits des NIC
	WriteRTL (ISR, (1<<PRX|1<<PTX|1<<RXE|1<<TXE|1<<OVW|1<<CNT|1<<RDC|1<<RST));
	
	//startet die Network Card
	Networkcard_Start();
	
	//Globale wieder Interrupts Einschalten
	sei ();
}

//############################################################################
//Hier werden daten empfangen und geprft was empfangen wurde 
int get (unsigned char bnry)
//############################################################################
{
	//lnge des Ethernetpacketes
	unsigned int packetlen;

	//Array fr zu empfangene Daten und zu sendene Daten
	unsigned char packet[MTU_SIZE];
	
	//Pointer auf Ethernet_Header
	struct Ethernet_Header *ethernet;
	ethernet = (struct Ethernet_Header *)&packet[ETHER_OFFSET];
	//Pointer auf IP_Header
	struct IP_Header *ip;
	ip = (struct IP_Header *)&packet[IP_OFFSET];
	//Pointer auf TCP_Header
	struct TCP_Header *tcp;
	tcp = (struct TCP_Header *)&packet[TCP_OFFSET];

	//Lese daten aus NIC FIFO ins Array packet() sowie packetheader()
	Read_Ethernet_Frame (packet,&packetlen, bnry);	
	//printf(" %04X\n",ethernet->EnetPacketType);
	
	//wurde ein ARP packet empfangen?
	//2 Byte fr Nutzlastbereich (0806 fr ARP)
	if(Ethernet_ARP_Datagramm)
		{
		//Erzeugt ein ARP Reply Packet
		//printf("arp() \n");
		ARP_Reply(packet,&packetlen);
		}
	
	//wurde ein ICMP, UDP oder TCP packet empfangen?
	//2 Byte fr Nutzlastbereich (0800 fr IP) 
	//Ist das IP Packet fr meine IP Addresse bestimmt
	else
	{	
		if(Ethernet_IP_Datagramm && MyIP){
		//Ist protokoll Byte = 1 dann ist es ein ICMP Packet
		if(IP_ICMP_Packet)
			{
			//Erzeugt ein ICMP Reply Packet (PING Echo)
			//printf("p");
			ICMP_Reply(packet,packetlen);
			}
		
		//Ist protokoll Byte = 17 dann ist es ein UDP Packet
		else if(IP_UDP_Packet)
			{
			printf("udp() \n");
			}
		//Ist protokoll Byte = 6 dann ist es ein TCP Packet
		else if(IP_TCP_Packet)
			{
			//printf("tcp() \n");
			if (tcp->TCP_DestPort == SOCKET_HTTP)
				{
				httpd (packet,&packetlen);
				}
				
			#if USE_FTPD
			if (tcp->TCP_DestPort == SOCKET_FTPD)
				{
				ftpd (packet,&packetlen);
				}
			#endif //USE_FTPD
			
			#if USE_TELNET
			if (tcp->TCP_DestPort == SOCKET_TELNET)
				{
				telnet (packet,&packetlen);
				}
			#endif //USE_TELNET
			}
		}
	}
return (0);
}


