
// ************************************************************************
// Infrared-Routines                                            VERSION 1.1
// uses ext.Int0 (PORTD.2) and Timer0 (Osz. 8MHz)
                                              
// IR_Code      :(int) Highbyte = adress, lowbyte = command  
//                                          
// New_IR_Code : new IR-Code received (has to be cleared by polling!)
// ************************************************************************

#include "main.h"

char           New_IR_Code; // Globale Variable. Dieses Bit wird nach Empfang eines Zeichens gesetzt
unsigned int   IR_Code;             // Globale Variable. Enthaelt das empfangene Zeichen
unsigned char  Decodierung_Lauft;   // ist gesetzt, waehrend Decodierung
volatile unsigned int   LoescheIrCodeTimer = 10;

#if defined (__AVR_ATmega32__)
#define INT0_ENABLE     GIMSK |= 0x40           
#define INT0_DISABLE    GIMSK &= ~0x40           
#define TIM0_START      TIMSK |= 0x01                        
#define TIM0_STOPP      TIMSK &= ~0x01                        
#define INT0_POS_FLANKE   MCUCR |= 0x01
#define INT0_NEG_FLANKE   MCUCR &= ~0x01
#define CLR_INT0_FLAG     GIFR &= ~0x40
#define INIT_INT0_FLANKE  MCUCR &= ~0x03; MCUCR |= 0x02;
#define TIMER0_PRESCALER  TCCR0
#else
#define INT0_ENABLE     EIMSK |= 0x01           
#define INT0_DISABLE    EIMSK &= ~0x01           
#define TIM0_START      TIMSK0 |= 0x01                        
#define TIM0_STOPP      TIMSK0 &= ~0x01                        
#define INT0_POS_FLANKE   EICRA |= 0x01
#define INT0_NEG_FLANKE   EICRA &= ~0x01
#define CLR_INT0_FLAG     EIFR &= ~0x01
#define INIT_INT0_FLANKE  EICRA &= ~0x03; EICRA |= 0x02;
#define TIMER0_PRESCALER  TCCR0B

#endif
// ************************************************************************
// Init IR
// ************************************************************************
void InitIR(void)
{
  INT0_ENABLE;           // ext. Int0 enable   
  CLR_INT0_FLAG;            // war |= 0x40
  INIT_INT0_FLANKE;
  TIMER0_PRESCALER = 0x04;           // Timer0: Clk div 256
  
  Decodierung_Lauft = 0;
  New_IR_Code = 0; 
  IR_Code = 0;    
  


}
// **************************************************************************
// * aufgerufen durch: externer Interrupt
// **************************************************************************
// * Die Funktion wird durch einen externen Interrupt aufgerufen.
// * Sie dient nur zum Starten der Abtastsequenz und zum Triggern auf die
// * Signalflanken in der Mitte der Daten.
// **************************************************************************
SIGNAL (SIG_INTERRUPT0)
{
    // Zeitbasis fuer Timer einstellen
    // Entspricht 1,5 mal einer Bitlaenge

     TCNT0 = -82;              
     TIM0_START;                         // Timer 0 starten, 
     if(Decodierung_Lauft) INT0_DISABLE; // die erneute Int.-Auslsung soll
		                                   // nur die Timer-Routine erlauben

}

// **************************************************************************
// * aufgerufen durch: Timerueberlauf Timer 0
// **************************************************************************
// * Die Funktion wird durch einen Timer0-Interrupt aufgerufen.
// * Der Timer wird vom ext. Int0 gestartet.
// * Das Infrarotsignal wird hier abgetastet und die Wertigkeiten der
// * Bits entsprechend aufaddiert. Das empfangende Zeichen wird in der
// * globalen Variablen IR_Code gespeichert. Nach Empfang wird das Bit
// * Neues_Zeichen gesetzt.
// **************************************************************************
SIGNAL (SIG_OVERFLOW0)
{

static unsigned int  Shift,IR_Code_tmp;
static unsigned char IR_Zaehler=0,IRSperrCounter=0;
// Reinitialize Timer's 0 value
TCNT0 = -82;
                                            
 if (IRSperrCounter) 
 { IRSperrCounter--;
   if (!IRSperrCounter) 
   { TIM0_STOPP;   // Timer0 sperre wird durch ExtInt0 gestartet
     CLR_INT0_FLAG;   // IntFlag Loeschen
     INT0_ENABLE;   // externen Interrupt wieder freigenben
   }  
 }
 else
 {
  if(IR_Zaehler > 1)
	{
	  Decodierung_Lauft = 1;
	    {
         CLR_INT0_FLAG;            // Interrupt Flag loeschen
	     if(IR_PP) INT0_NEG_FLANKE; // naechste fallende  Flanke soll Int0 ausloesen
	     else      INT0_POS_FLANKE;    // naechste steigende Flanke soll Int0 ausloesen
	     INT0_ENABLE;            // externen Int frei
   
	    }
	}
 
  if(!IR_Zaehler)              // es beginnt eine neue Abtastung
  {                           // es handelt sich um das 1. Sync-Bit
    IR_Code_tmp=0;             // Merker lschen
     Shift=0x8000; //;8192;                // Maske auf MSB 
  }
  else
  if(IR_PP==1)                // das empfangende Bit ist logisch High
  {  if(IR_Zaehler>2)         // (IR_Zaehler ist gleich 1 beim 2. Sync-Bit)
      {                       // 2 --> Toggle-Bit (wird bersprungen)
        IR_Code_tmp |= Shift; // entsprechendse Bit setzen 
      }
  }
  
  if ((IR_Zaehler < 2) && !(IR_PP==1)) IR_Zaehler = 0;   // startbits berprfen
 
 
  Shift >>=1;                   // Shiftregister um 1 nach rechts schieben
                               // (fr das nchste empf. Bit  
  if (Shift == 128) Shift = 32; // Adresse ins HighByte, Kommando ins LowByte                            
 
  if(IR_Zaehler++==15)        // Das IR-Wort wurde vollstaendig abgetastet
    {
     
       CLR_INT0_FLAG;      // IntFlag Loeschen
       INT0_NEG_FLANKE;      // fallende Flanke
       IR_Zaehler = 0;
       Decodierung_Lauft=0;  
  /*     if ((HIGH(IR_Code_tmp)==ALLOWED1)|| (HIGH(IR_Code_tmp)==ALLOWED2)||
            (HIGH(IR_Code_tmp)==ALLOWED3)||(HIGH(IR_Code_tmp)==ALLOWED4)||
           (HIGH(IR_Code_tmp)==ALLOWED5) )
         if ((HIGH(IR_Code_tmp)< 10))*/
    if ((HIGH(IR_Code_tmp)< 10 ) && (LOW(IR_Code_tmp)!=0x3F) )
        { // nur erlaubt Adressen werden akzepetiert
         IR_Code=IR_Code_tmp;  // IR-Wort in die globale Variable schreiben
         New_IR_Code=1;        // Es ist ein neues Zeichen eingetragen worden
         IRSperrCounter = 4; // weitere Kommandos fr 200 * 1,3ms unterdrcken 
		 INT0_ENABLE;     // externen Interrupt wieder freigenben
         LoescheIrCodeTimer = 500;
       } 
      
     IRSperrCounter = 4; // weitere Kommandos fr 200 * 1,3ms unterdrcken 
	 INT0_ENABLE;     // externen Interrupt wieder freigenben
     
     }
 }   

}                      

