#define IR_PP  ((PIND & (1<<2))>>2)           // der Infrarotempfaenger ist am Port D, Bit 2 angeschlossen
                                // irfrared receiver on PORT D.2
#define LOW(int)              (unsigned char)(*((char*)&(int)+0)) // returns lowbyte
#define HIGH(int)             (unsigned char)(*((char*)&(int)+1)) // return highbyte


extern char           New_IR_Code; // Globale Variable. Dieses Bit wird nach Empfang eines Zeichens gesetzt
                                    // a new IR command was received  
extern unsigned int  IR_Code;    // Globale Variable. Enthaelt das empfangene Zeichen
                                   // holds the received IR command

extern volatile unsigned int   LoescheIrCodeTimer;
void InitIR(void);

// ----- System-Adress (RC5) ------
#define TV           0
#define TV2          1
#define VCR          5
#define VCR2         6
#define SAT          8

//-------  allowed system adresses ----------------
// only commands from one of the following adresses
// will be received
#define ALLOWED1     TV
#define ALLOWED2     SAT
#define ALLOWED3     VCR
#define ALLOWED4     VCR
#define ALLOWED5     VCR

// ----- Commands      (RC5) ------
#define RC_VOL_UP       16 
#define RC_VOL_DOWN     17 
#define RC_BRIGHT_UP    18
#define RC_BRIGHT_DOWN  19
#define RC_COLOR_UP     20
#define RC_COLOR_DOWN   21
#define RC_BASS_UP      22
#define RC_BASS_DOWN    23
#define RC_TREBLE_UP    24
#define RC_TREBLE_DOWN  25
#define RC_SYSTEM_SEL   63
#define RC_POWER        12
#define RC_MUTE         13 
#define RC_CHANNEL_UP   32
#define RC_CHANNEL_DOWN 33
#define RC_VIDEOTEXT    60
#define RC_PLAY         53
#define RC_STOP         54
#define RC_RECORD       55
#define RC_REWIND       50
#define RC_WIND         52
#define RC_PAUSE        48
#define RC_EXT1         56
