// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// + LCD-Funktionen fr den M16C62
// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#include "main.h"
unsigned char DisplayBuff[80];
unsigned char DispPtr = 0;
unsigned char DisplayType = HD44780;

void _short_delay(void)
{
int t = 2000;
while (t--);
}

void _long_delay(void)
{
long t = 7000;
while (t--);
}


void _lcd_write_command(unsigned char data)
{
  LCD_PORT_AUSGANG;  
  LCD_PORT_w = (data & 0xf0) | DISPLAY_EN;
  LCD_PORT_w = (data & 0xf0) | DISPLAY_EN;
  LCD_PORT_w = (data & 0xf0) | DISPLAY_EN;
  LCD_PORT_w = (data & 0xf0);
  LCD_PORT_w = (data & 0xf0);
  LCD_PORT_w = (data & 0xf0);
  LCD_PORT_w = (data << 4) | DISPLAY_EN;
  LCD_PORT_w = (data << 4) | DISPLAY_EN;
  LCD_PORT_w = (data << 4) | DISPLAY_EN;
  LCD_PORT_w = (data << 4);
  LCD_PORT_EINGANG;
}

void _lcd_write_4bit(unsigned char data)
{
  LCD_PORT_AUSGANG;
  LCD_PORT_w = (data << 4) | DISPLAY_EN;
  LCD_PORT_w = (data << 4) | DISPLAY_EN;
  LCD_PORT_w = (data << 4) | DISPLAY_EN;
  LCD_PORT_w = (data << 4);
  LCD_PORT_w = (data << 4);
  LCD_PORT_EINGANG;
}

void lcd_write_byte(unsigned char data)
{
  LCD_PORT_AUSGANG;
  LCD_PORT_w = (data & 0xf0) | DISPLAY_EN | DISPLAY_RS;
  LCD_PORT_w = (data & 0xf0) | DISPLAY_EN | DISPLAY_RS;
  LCD_PORT_w = (data & 0xf0) | DISPLAY_RS;
  LCD_PORT_w = (data & 0xf0) | DISPLAY_RS;
  LCD_PORT_w = (data << 4)   | DISPLAY_EN | DISPLAY_RS;
  LCD_PORT_w = (data << 4)   | DISPLAY_EN | DISPLAY_RS;
  LCD_PORT_w = (data << 4)   | DISPLAY_RS;
  LCD_PORT_EINGANG;
}


int my_pput(int zeichen)
{
 lcd_write_byte((char) zeichen);
 return(1);
}

// initialize the LCD controller
void LCD_Init(void)
{
for(unsigned char i = 0; i != 80; i++) DisplayBuff[i] = ' ';
LCD_PORT_AUSGANG;
//DisplayType = VIER_ZEILEN | HD44780;

_long_delay();
_long_delay();
_lcd_write_4bit(0x03);	   // noch 8 Bit
_long_delay();
_lcd_write_4bit(0x03);	   // noch 8 Bit
_long_delay();
_lcd_write_4bit(0x03);	   // noch 8 Bit
_long_delay();
_lcd_write_4bit(0x02);	   // jetzt 4 Bit
_long_delay();

if ((DisplayType & VIER_ZEILEN) == VIER_ZEILEN)
{
_lcd_write_command(0x28+4);     // 4 Bit Zweizeilig ext. Funk als nchstes
_long_delay();
_lcd_write_command(0x09);     // 4 - zeilig
_long_delay();
}
_lcd_write_command(0x28);     // 4 Bit Zweizeilig
//-
// ----- EA GLASS DISPLAY
_long_delay();
if ((DisplayType & ST7036) == ST7036) _lcd_write_command(0x29);     // <-- WICHTIG
_long_delay();
_lcd_write_command(0x1C);     
_long_delay();
_lcd_write_command(0x74);     
_long_delay();
_lcd_write_command(0x52);     // 
_long_delay();
_lcd_write_command(0x69);     // Contrast 

// ----------------------------
//-
_long_delay();
_lcd_write_command(0x08);     // Display aus
_long_delay();
_lcd_write_command(0x01);     // Clear
_long_delay();
_lcd_write_command(0x06);     //Entry mode
_long_delay();
_lcd_write_command(0x08 + 4); // Display an
_long_delay();
}


void LCD_Gotoxy(unsigned char x , unsigned char y)
 {
  _short_delay();
  DispPtr = y * 20 + x;
  if((DisplayType & KS0073) == KS0073)
  switch(y)
  { case 0 : _lcd_write_command(x + 0x0  + 0x80); break;
    case 1 : _lcd_write_command(x + 0x20 + 0x80); break;
    case 2 : _lcd_write_command(x + 0x40 + 0x80); break;
    case 3 : _lcd_write_command(x + 0x60 + 0x80); break;
  }
  else
  switch(y)
  { case 0 : _lcd_write_command(x + 0x80); break;
    case 1 : _lcd_write_command(x + 0xC0); break;
    case 2 : _lcd_write_command(x + (0x80 + 20)); break;
    case 3 : _lcd_write_command(x + (0xC0 + 20)); break;
  }
  
}


void LCD_Write(unsigned char *this_text)
{
 unsigned char i = 0;
  
 while(this_text[i] != 0) 
  {
   lcd_write_byte(this_text[i++]);
   _long_delay();
  }
  
}


char LCD_Putchar(char zeichen)
{
_short_delay();
 DisplayBuff[DispPtr++] = zeichen;
 lcd_write_byte((char) zeichen);
 return(1);
}

 unsigned long DezStellen[] = {0,1,10,100,1000,10000,100000L, 1000000L, 10000000L, 100000000L,1000000000L, 0xFFFF};
 
void LCD_DezAusgabe(unsigned long wert , char stellen , unsigned char punkt)
 {
  unsigned char ziffer;
  char nullen = 0;
  
  if(stellen < 0)                        
   {
    stellen = -stellen;
    if( (long)wert < 0) {wert = -wert;LCD_Putchar('-');  }
    else LCD_Putchar('+');                   
   }

  if((punkt > stellen) || (stellen > 9))
 {
    LCD_Putchar('*');                          
    return(0);                            
   }

   if( (long)wert < 0) {wert = -wert;LCD_Putchar('-');  }
    
 
 
 if( wert >= DezStellen[stellen + 1])  
   {
    
	for (unsigned char i=stellen; i > 0; i--) if ((punkt>0) && (i == punkt)) { LCD_Putchar('.');LCD_Putchar('#'); } else LCD_Putchar('#');  
    return(0);                            
   }

  for(unsigned char i = stellen ; i > 0 ; i--)
   {
    if(i == punkt)               
     {
      LCD_Putchar('.');             
      nullen = 1;                 
     } 
    ziffer = (wert / DezStellen[i]) + 0x30;
    if((ziffer == '0') && !nullen && (i != 1)) 
     if (i== punkt+1) LCD_Putchar('0');                      
      else LCD_Putchar(' ');
    else
     {
      nullen = 1;                         
      LCD_Putchar(ziffer);
      wert %= DezStellen[i];                
     }
   }   
    
 }


