#ifndef _MAIN_H
 #define _MAIN_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <avr/io.h>
#include <avr/pgmspace.h>
#include <avr/interrupt.h>
#include <avr/signal.h>
#include <avr/eeprom.h>
#include <avr/boot.h>
#include <avr/wdt.h>

#include "old_macros.h"
#include "analog.h"
#include "uart.h"
#include "lcd.h"
#include "printf_P.h"
#include "timer0.h"
#include "keyboard.h"
#include "menu.h"
#include "ir.h"

extern unsigned char Sekunde,Minute;
extern unsigned char CntDatensaetzeProSekunde;
extern unsigned char SlaveAdresse;
extern unsigned int  IntervallDebug, IntervallDisplay;
extern unsigned char PollDisplay;  
extern unsigned char DisplayZeilen;
//Hier die Quarz Frequenz einstellen
//#define SYSCLK	8000000L	//Quarz Frequenz in Hz
#define SYSCLK	16000000L	//Quarz Frequenz in Hz

	
#if defined (__AVR_ATmega32__)	
//	#define Networkcard_INT_Enable()	enable_external_int (1<<INT0);
#endif	


#endif //_MAIN_H

struct str_DebugOut
{
 unsigned char Digital[13]; // 0      = Taster, Hauptkarte
                            // 1 + 2  = Debugkanle
                          	// 3      = Digin,  Hauptkarte
                          	// 4      = Relais, Hauptkarte
							// 5 + 6  = Extern IO1 (12Bit ein 4 Bit aus)
							// 7 + 8  = Extern IO2 (12Bit ein 4 Bit aus)
							// 9 + 10 = Extern IO3 (12Bit ein 4 Bit aus)
							// 11 + 12= Extern IO4 (12Bit ein 4 Bit aus)
 unsigned int AnzahlZyklen;
 unsigned int  Zeit;
 unsigned char Sekunden;
 unsigned int Analog[4];    // Debugwerte
};

struct str_Debug2
{
 unsigned char Digital[2];
 unsigned int  Analog[4];
}; 

struct str_DebugIn
{
 unsigned char Digital[2];
 unsigned char RemoteTasten;
 unsigned int Analog[4];
}; 

struct str_VersionInfo
{
  unsigned char Hauptversion;
  unsigned char Nebenversion;
  unsigned char PCKompatibel;
  unsigned char Commercial;    // 0 = Noncommercial
  unsigned char HWKonfig;	   // Controller 0x01 = Mega32   0x02 = Mega644    0x80 = Asynchron
  unsigned char Frequenz;	   // in MHz
  unsigned char ExternIO[4];   // [0] = Bitcodiert 12/4 Module
};   

extern struct str_DebugIn     DebugIn;
extern struct str_DebugOut    DebugOut;
extern struct str_VersionInfo VersionInfo;
extern struct str_Debug2      DebugKurz;




