#ifndef _PRINTF_P_H_
#define _PRINTF_P_H_

#include <avr/pgmspace.h>

extern void _printf_P (char, char const *fmt0, ...);
extern char PrintZiel;

#define LCD_printf(format, args...)   _printf_P(OUT_LCD,PSTR(format) , ## args)
#define LCD_printfxy(x,y,format, args...)  { LCD_Gotoxy(x,y);_printf_P(OUT_LCD,PSTR(format) , ## args);}

#define printf_P(format, args...)   _printf_P(OUT_V24,format , ## args)
#define printf(format, args...)     _printf_P(OUT_V24,PSTR(format) , ## args)

#endif
