/*****************************************************************************
 Basisprojekt fr die SPS-Ctrl (MEGA32 oder MEGA644)
 
 !!!!!!!!!!! CPU & QUARZ sind im Makefile einzustellen !!!!!!!!!!!!
 Datei: timer.h beachten, dort werden die Reloadwert eingestellt.

 Es sind Dateien fr alle wichtigen Komponenten der SPS-Ctrl in diesem Projekt
 vorhanden:
 - I2C - EEPROM & Echtzeituhr
 - RC5-Empfnger
 - Display & Tastatur
 - Analogeingnge
 
 Mit diesem Projekt als Basis sollte der Start fr sein eigenes Projekt 
 vereinfacht werden. Viel Erfolg.
 
 
 -----------------------------------------------------------------------------
 08/2006 - Ingo Busker
 http://www.mikrcontroller.com       http://www.microsps.com
*****************************************************************************/
#include "main.h"
volatile unsigned int CountMilliseconds = 0;
 
enum {
  STOP             = 0,
  CK               = 1,
  CK8              = 2,
  CK64             = 3,
  CK256            = 4,
  CK1024           = 5,
  T0_FALLING_EDGE  = 6,
  T0_RISING_EDGE   = 7
};


SIGNAL (SIG_OVERFLOW1)
{
 static unsigned char cnt_10ms = 0;
 TCNT1 -= TIMER_RELOAD_VALUE;
 CountMilliseconds++;
 if(DisplayBusy) DisplayBusy--;
 if(WaitTXD) WaitTXD--;
 if(LoescheIrCodeTimer) 
  { 
   if(--LoescheIrCodeTimer == 0) IR_Code = 0;
  } 
  
}


void Timer1_Init(void)
{

 TCCR1B = TIMER_TEILER;
 TCNT1 = -TIMER_RELOAD_VALUE;  // reload
 //OCR1  = 0x00;
// Timer(s)/Counter(s) Interrupt(s) initialization
 
#if defined (__AVR_ATmega32__) 
  TIMSK |= 0x04;
#endif

#if defined (__AVR_ATmega644__) 
 TIMSK1 |= _BV(TOIE1);
#endif
 
}


unsigned int SetDelay (unsigned int t)
{
  return(CountMilliseconds + t - 1);                                             
}

char CheckDelay (unsigned int t)
{
  return(((t - CountMilliseconds) & 0x8000) >> 8);
}

void Delay_ms(unsigned int w)
{
 unsigned int akt;
 akt = SetDelay(w);
 while (!CheckDelay(akt));
}
