/*****************************************************************************
 Basisprojekt fr die SPS-Ctrl (MEGA32 oder MEGA644)
 
 !!!!!!!!!!! CPU & QUARZ sind im Makefile einzustellen !!!!!!!!!!!!
 Datei: timer.h beachten, dort werden die Reloadwert eingestellt.

 Es sind Dateien fr alle wichtigen Komponenten der SPS-Ctrl in diesem Projekt
 vorhanden:
 - I2C - EEPROM & Echtzeituhr
 - RC5-Empfnger
 - Display & Tastatur
 - Analogeingnge
 
 Mit diesem Projekt als Basis sollte der Start fr sein eigenes Projekt 
 vereinfacht werden. Viel Erfolg.
 
 
 -----------------------------------------------------------------------------
 08/2006 - Ingo Busker
 http://www.mikrcontroller.com       http://www.microsps.com
*****************************************************************************/

#if defined (__AVR_ATmega32__)
#define TIMER_TEILER        CK64
#define TIMER_RELOAD_VALUE    250
#endif

#if defined (__AVR_ATmega644__)
#define TIMER_TEILER        CK64					// bei 16MHz
#define TIMER_RELOAD_VALUE  125                     // bei 16MHz
//#define TIMER_TEILER        CK256                 // bei 20MHz
//#define TIMER_RELOAD_VALUE  -78 					// bei 20MHz
#endif

extern volatile unsigned int CountMilliseconds;


void Timer1_Init(void);
void Delay_ms(unsigned int);
unsigned int SetDelay (unsigned int t);
char CheckDelay (unsigned int t);

