#include "main.h"
#include "uart.h"

#define MAX_SENDE_BUFF     100
#define MAX_EMPFANGS_BUFF  100

unsigned volatile char SioTmp = 0;
unsigned volatile char SendeBuffer[MAX_SENDE_BUFF];
unsigned volatile char RxdBuffer[MAX_EMPFANGS_BUFF];
unsigned volatile char NeuerDatensatzEmpfangen = 0;
unsigned volatile char UebertragungAbgeschlossen = 1;
unsigned volatile int CntCrcError = 0;
unsigned volatile char AnzahlEmpfangsBytes = 0;
unsigned volatile char PC_DebugTimeout = 0;
unsigned char TX_DigTransferKanalL = 0;
unsigned char TX_DigTransferKanalH = 0;
unsigned char TX_DigTransferKanalDaten = 0;
volatile unsigned char DisplayBusy = 0;
unsigned char AntwortEingetroffen = 0;
unsigned char ErwarteAntwort = 'x';
unsigned char AnzahlTeilnehmer = 2;
volatile unsigned char WaitTXD = 0; // minimale Zeit zwischen zwei Sende-Daten
unsigned char TeilnehmerHatDaten[30];
unsigned char KanalRelaisLifetime = 0; // Lifetime
unsigned char KanalRelaisWert = 0; 
unsigned char DebuggerRelaisLifetime = 0; // Lifetime
unsigned char DebuggerRelaisWert = 0; 

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//++ Sende-Part der Datenbertragung
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
SIGNAL(INT_VEC_TX)
{
 static unsigned int ptr = 0;
 unsigned char tmp_tx;
 if(!UebertragungAbgeschlossen)  
  {
   ptr++;                    // die [0] wurde schon gesendet
   tmp_tx = SendeBuffer[ptr];  
   if((tmp_tx == '\r') || (ptr == MAX_SENDE_BUFF))
    {
     ptr = 0;
     UebertragungAbgeschlossen = 1;
    }
   UDR = tmp_tx; 
  } 
  else ptr = 0;
}

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//++ Empfangs-Part der Datenbertragung, incl. CRC-Auswertung
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
SIGNAL(INT_VEC_RX)
{
 static unsigned int crc;
 static unsigned char crc1,crc2,buf_ptr;
 static unsigned char UartState = 0;
 unsigned char CrcOkay = 0;

 SioTmp = UDR; 
 if(buf_ptr >= MAX_EMPFANGS_BUFF)    UartState = 0;
 if(SioTmp == '\r' && UartState == 2) 
  {
   UartState = 0;
   crc -= RxdBuffer[buf_ptr-2];
   crc -= RxdBuffer[buf_ptr-1];
   crc %= 4096;
   crc1 = '=' + crc / 64;
   crc2 = '=' + crc % 64;
   CrcOkay = 0;
   if((crc1 == RxdBuffer[buf_ptr-2]) && (crc2 == RxdBuffer[buf_ptr-1])) CrcOkay = 1; else { CrcOkay = 0; CntCrcError++;};
   if(!NeuerDatensatzEmpfangen && CrcOkay) // Datensatz schon verarbeitet
    {
	 CntDatensaetzeProSekunde++;
 	 PC_DebugTimeout = 10;
     NeuerDatensatzEmpfangen = 1; 
	 AnzahlEmpfangsBytes = buf_ptr;
     RxdBuffer[buf_ptr] = '\r';
if(RxdBuffer[2] == 'R') wdt_enable(WDTO_250MS); // Reset-Commando
	}				  
  }
  else
  switch(UartState)
  {
   case 0:
          if(SioTmp == '#' && !NeuerDatensatzEmpfangen) UartState = 1;  // Startzeichen und Daten schon verarbeitet
		  buf_ptr = 0;
		  RxdBuffer[buf_ptr++] = SioTmp;
		  crc = SioTmp;
          break;
   case 1: // Adresse auswerten
		  UartState++;
		  RxdBuffer[buf_ptr++] = SioTmp;
		  crc += SioTmp;
		  break;
   case 2: //  Eingangsdaten sammeln
		  RxdBuffer[buf_ptr] = SioTmp;
		  if(buf_ptr < MAX_EMPFANGS_BUFF) buf_ptr++; 
		  else UartState = 0;
		  crc += SioTmp;
		  break;
   default: 
          UartState = 0; 
          break;
  }
};

// --------------------------------------------------------------------------
void AddCRC(unsigned int wieviele)
{
 unsigned int tmpCRC = 0,i; 
 for(i = 0; i < wieviele;i++)
  {
   tmpCRC += SendeBuffer[i];
  }
   tmpCRC %= 4096;
   SendeBuffer[i++] = '=' + tmpCRC / 64;
   SendeBuffer[i++] = '=' + tmpCRC % 64;
   SendeBuffer[i++] = '\r';
   while(WaitTXD);
   WaitTXD = MIN_TX_DELAY;
  UebertragungAbgeschlossen = 0;
  UDR = SendeBuffer[0];
// PrintSendeBuffer();
}


// --------------------------------------------------------------------------
void SendOutData(unsigned char cmd,unsigned char modul, unsigned char *snd, unsigned char len)
{
 unsigned int pt = 0,i;
 unsigned char a,b,c,d;
 unsigned char ptr = 0;
 unsigned char x,y,z;
 while(!UebertragungAbgeschlossen);
 SendeBuffer[pt++] = '#';           // Startzeichen
 SendeBuffer[pt++] = modul+'a'; // Adresse (a=0; b=1,...)
 SendeBuffer[pt++] = cmd;		  // Commando

 while(len)
  {
   if(len) { a = snd[ptr++]; len--;} else a = 0;
   if(len) { b = snd[ptr++]; len--;} else b = 0;
   if(len) { c = snd[ptr++]; len--;} else c = 0;
   SendeBuffer[pt++] = '=' + (a >> 2);
   SendeBuffer[pt++] = '=' + (((a & 0x03) << 4) | ((b & 0xf0) >> 4));
   SendeBuffer[pt++] = '=' + (((b & 0x0f) << 2) | ((c & 0xc0) >> 6));
   SendeBuffer[pt++] = '=' + ( c & 0x3f);
  }
 AddCRC(pt);
}

// --------------------------------------------------------------------------
void Decode64(unsigned char *ptrOut, unsigned char len, unsigned char ptrIn,unsigned char max)  // Wohin mit den Daten; Wie lang; Wo im RxdBuffer
{
 unsigned char a,b,c,d;
 unsigned char ptr = 0;
 unsigned char x,y,z;
 while(len)
  {
   a = RxdBuffer[ptrIn++] - '=';
   b = RxdBuffer[ptrIn++] - '=';
   c = RxdBuffer[ptrIn++] - '=';
   d = RxdBuffer[ptrIn++] - '=';
   if(ptrIn > max - 2) break;     // nicht mehr Daten verarbeiten, als empfangen wurden

   x = (a << 2) | (b >> 4);
   y = ((b & 0x0f) << 4) | (c >> 2);
   z = ((c & 0x03) << 6) | d;

   if(len--) ptrOut[ptr++] = x; else break;
   if(len--) ptrOut[ptr++] = y; else break;
   if(len--) ptrOut[ptr++] = z;	else break;
  }

}

// --------------------------------------------------------------------------
void BearbeiteRxDaten(void)
{
 unsigned int tmp_int_arr1[1];
 unsigned int tmp_int_arr2[2];
 unsigned int tmp_int_arr3[3];
 unsigned int tmp_int_arr20[21];
 unsigned char tmp_char_arr3[3];
// unsigned int tmp_int_arr4[4];

 if(!NeuerDatensatzEmpfangen) return;
 NeuerDatensatzEmpfangen = 0;
 if(ErwarteAntwort == RxdBuffer[2]) AntwortEingetroffen = 1;
 switch(RxdBuffer[2])
  {
   case '0':// LCD-Zeile0
            Decode64((unsigned char *) &tmp_int_arr20,sizeof(tmp_int_arr20),3,AnzahlEmpfangsBytes);
            tmp_int_arr20[20] = 0;
			DisplayBusy = 1; 
            LCD_printfxy(0,0,"%s",tmp_int_arr20);
            break;  
   case '1':// LCD-Zeile1
            Decode64((unsigned char *) &tmp_int_arr20,sizeof(tmp_int_arr20),3,AnzahlEmpfangsBytes);
            tmp_int_arr20[20] = 0;
            LCD_printfxy(0,1,"%s",tmp_int_arr20);
            break;  
   case '2':// LCD-Zeile2
            Decode64((unsigned char *) &tmp_int_arr20,sizeof(tmp_int_arr20),3,AnzahlEmpfangsBytes);
            tmp_int_arr20[20] = 0;
            LCD_printfxy(0,2,"%s",tmp_int_arr20);
            break;  
   case '3':// LCD-Zeile3
            Decode64((unsigned char *) &tmp_int_arr20,sizeof(tmp_int_arr20),3,AnzahlEmpfangsBytes);
            tmp_int_arr20[20] = 0;
            LCD_printfxy(0,3,"%s",tmp_int_arr20);
            break;  
   case 'D': // Debug Eingangsdaten		  
            Decode64((unsigned char *) &DebugOut,sizeof(DebugOut),3,AnzahlEmpfangsBytes);
			DebuggerRelaisWert = DebugOut.Digital[1];
			DebuggerRelaisLifetime = 6;
			break;
   case 'E': // Debug Eingangsdaten		  
            Decode64((unsigned char *) &DebugKurz,sizeof(DebugKurz),3,AnzahlEmpfangsBytes);
			DebuggerRelaisWert = DebugKurz.Digital[0];
			DebuggerRelaisLifetime = 6;
			break;
   case 'L': // Debug Eingangsdaten		  
            TeilnehmerHatDaten[RxdBuffer[1]-'a'] = 0;
            Decode64(tmp_char_arr3,sizeof(tmp_char_arr3),3,AnzahlEmpfangsBytes);
            while(!UebertragungAbgeschlossen);  // evtl warten
            TX_DigTransferKanalL =  tmp_char_arr3[0];
            TX_DigTransferKanalH =  tmp_char_arr3[1];
            TX_DigTransferKanalDaten = tmp_char_arr3[2];
            
			if(((int)TX_DigTransferKanalL + (int)TX_DigTransferKanalH * 256) == 10000) 
			 {
			  KanalRelaisWert = TX_DigTransferKanalDaten;
              KanalRelaisLifetime = 6;
			 }
             else
             SendOutData('l',0,tmp_char_arr3,sizeof(tmp_char_arr3));
			break;
   case 'M': // Debug Eingangsdaten		  
            TeilnehmerHatDaten[RxdBuffer[1]-'a'] = 0;
            Decode64(tmp_int_arr3,sizeof(tmp_int_arr3),3,AnzahlEmpfangsBytes);
            while(!UebertragungAbgeschlossen);  // evtl warten
            SendOutData('m',0,tmp_int_arr3,sizeof(tmp_int_arr3));
			break;
            
/*
 unsigned char Digital[13]; // 0      = Taster, Hauptkarte
                            // 1 + 2  = Debugkanle
                          	// 3      = Digin,  Hauptkarte
                          	// 4      = Relais, Hauptkarte
							// 5 + 6  = Extern IO1 (12Bit ein 4 Bit aus)
							// 7 + 8  = Extern IO2 (12Bit ein 4 Bit aus)
							// 9 + 10 = Extern IO3 (12Bit ein 4 Bit aus)
							// 11 + 12= Extern IO4 (12Bit ein 4 Bit aus)
*/

/*   case 'd': // Debug Eingangsdaten		  
            Decode64((unsigned char *) &DebugIn,sizeof(DebugIn),3,AnzahlEmpfangsBytes);
         	for(unsigned char i=0; i<4;i++)
			 {
              EE_CheckAndWrite(&EE_Buffer[EE_DEBUGWERTE + i*2],     DebugIn.Analog[i]);	
			  EE_CheckAndWrite(&EE_Buffer[EE_DEBUGWERTE + i*2 + 1], DebugIn.Analog[i] >> 8);	
			 }
            break;
   case 'g': // "Get"-Anforderung fr Debug-Daten // Bei Get werden die vom PC einstellbaren Werte vom PC zurckgelesen
            DebugGetAnforderung = 1;
            break;
   case 'v': // Version-Anforderung	und Ausbaustufe
            GetVersionAnforderung = 1;
            break;
   case 'u': // Uhr stellen
            Decode64((unsigned char *) &tmp_int_arr2[0],sizeof(tmp_int_arr2),3,AnzahlEmpfangsBytes);
			ZEITWERT = tmp_int_arr2[0];
			SEK = tmp_int_arr2[1];
            make_time_variables(ZEITWERT); 
            RTC_SetTime(STD, MIN, SEK);
            RTC_SetWDay(TAG);
            break;
   case 'i': // Intervalle fr die Datenbertragung
            Decode64((unsigned char *) &tmp_int_arr2[0],sizeof(tmp_int_arr2),3,AnzahlEmpfangsBytes);
			Debug_Timer_Intervall =   tmp_int_arr2[0];
			Debug_Display_Intervall = tmp_int_arr2[1];
			SendeDummyDaten = 1;
			break;
   case 's': // single Step	1 = Stop   2 = noch einen Zyklus   3 = noch 2 Zyklen
            Decode64((unsigned char *) &tmp_int_arr1[0],sizeof(tmp_int_arr2),3,AnzahlEmpfangsBytes);
			SingleStep = tmp_int_arr1[0];
			break;
*/ 
 }
}

//############################################################################
//Routine fr die Serielle Ausgabe
int uart_putchar (char c)
//############################################################################
{
	if (c == '\n')
		uart_putchar('\r');
	//Warten solange bis Zeichen gesendet wurde
	loop_until_bit_is_set(USR, UDRE);
	//Ausgabe des Zeichens
	UDR = c;
	
	return (0);
}

// --------------------------------------------------------------------------
void WriteProgramData(unsigned int pos, unsigned char wert)
{
  //if (ProgramLocation == IN_RAM) Buffer[pos] = wert;
  // else eeprom_write_byte(&EE_Buffer[pos], wert);
  // Buffer[pos] = wert;
}

//############################################################################
//INstallation der Seriellen Schnittstelle
void UART_Init (void)
//############################################################################
{
	//Enable TXEN im Register UCR TX-Data Enable & RX Enable

	UCR=(1 << TXEN) | (1 << RXEN);
    // UART Double Speed (U2X)
	USR   |= (1<<U2X);           
	// RX-Interrupt Freigabe
	UCSRB |= (1<<RXCIE);           
	// TX-Interrupt Freigabe
	UCSRB |= (1<<TXCIE);           

	//Teiler wird gesetzt 
	UBRR=(SYSCLK / (BAUD_RATE * 8L) - 1);
	//UBRR = 33;
	//ffnet einen Kanal fr printf (STDOUT)
	fdevopen (uart_putchar, NULL);
	//sbi(PORTD,4);
}

/*
struct str_DebugIn
{
 unsigned char Digital[2];
 unsigned char RemoteTasten;
 unsigned int Analog[4];
}; 
*/
void SendeDebugDaten(unsigned char keys)
{
 while(!UebertragungAbgeschlossen);  // evtl warten
 DebugIn.RemoteTasten = keys;
 DebugIn.Analog[0] = AnalogWerte[0];
 DebugIn.Analog[1] = AnalogWerte[1];
 DebugIn.Analog[2] = AnalogWerte[2];
 DebugIn.Analog[3] = IR_Code;
 SendOutData('d',SlaveAdresse,(unsigned char *) &DebugIn,sizeof(DebugIn));
}

void SendIntervalle(unsigned int debug, unsigned int disp)
{
 unsigned int tmp_int_arr2[2];
 tmp_int_arr2[0] = debug;
 tmp_int_arr2[1] = disp;
 while(!UebertragungAbgeschlossen);  // evtl warten
 SendOutData('i',SlaveAdresse,(unsigned char *) &tmp_int_arr2,sizeof(tmp_int_arr2));
}

void ClearIntervalle(void)
{
 unsigned int tmp_int_arr2[2];
 tmp_int_arr2[0] = 0;
 tmp_int_arr2[1] = 0;
 while(!UebertragungAbgeschlossen);  // evtl warten
 SendOutData('i',0,(unsigned char *) &tmp_int_arr2,sizeof(tmp_int_arr2)); // 0= an alle
}

void SendeRemoteKanaele(unsigned char keys)
{
 static unsigned char state = 0;
 unsigned int  tmp_int_arr3[3];
 unsigned char tmp_char_arr3[3];
 switch(state)
 {
  case 0:
            tmp_int_arr3[0] = 10000;
            tmp_int_arr3[1] = DebugIn.Digital[0];
            while(!UebertragungAbgeschlossen);  // evtl warten
            SendOutData('l',0,tmp_int_arr3,3);
			state++;
         break;
  case 1:	
            tmp_int_arr3[0] = 10000;
            tmp_int_arr3[1] = AnalogWerte[0];
            tmp_int_arr3[2] = AnalogWerte[1];
            while(!UebertragungAbgeschlossen);  // evtl warten
            SendOutData('m',0,tmp_int_arr3,sizeof(tmp_int_arr3));
			state++;
         break;
  case 2:	
            tmp_int_arr3[0] = 10001;
            tmp_int_arr3[1] = AnalogWerte[2];
            tmp_int_arr3[2] = AnalogWerte[3];
            while(!UebertragungAbgeschlossen);  // evtl warten
            SendOutData('m',0,tmp_int_arr3,sizeof(tmp_int_arr3));
			state++;
         break;
  case 3:	
            tmp_int_arr3[0] = 10002;
            tmp_int_arr3[1] = AnalogWerte[4];
            tmp_int_arr3[2] = IR_Code;
            while(!UebertragungAbgeschlossen);  // evtl warten
            SendOutData('m',0,tmp_int_arr3,sizeof(tmp_int_arr3));
			state++;
         break;
  case 4:	
            while(!UebertragungAbgeschlossen);  // evtl warten
            DebugIn.RemoteTasten = keys;
            DebugIn.Analog[0] = AnalogWerte[0];
            DebugIn.Analog[1] = AnalogWerte[1];
            DebugIn.Analog[2] = AnalogWerte[2];
            DebugIn.Analog[3] = IR_Code;
            SendOutData('d',SlaveAdresse,(unsigned char *) &DebugIn,sizeof(DebugIn));
			state++;
         break;
  case 5:	
            while(!UebertragungAbgeschlossen);  // evtl warten
            SendOutData('e',SlaveAdresse,tmp_int_arr3,3);
			state=0;
         break;
  default: 
        state = 0;
        break;
 }
 
}

void DatenUebertragung(unsigned char key) 
{
 static unsigned char state = 1;
 unsigned char i;
 unsigned char temp_1[1];
 unsigned char temp_2[2];
 static unsigned char temp_3[3];
 unsigned int tmp_int_arr2[2];
 static unsigned char KanalSlave = 1;

 while(!UebertragungAbgeschlossen);  // evtl warten

 if(PollDisplay) 
  {
   temp_2[0] = key; 
   temp_2[1] = 6;
   if(DisplayZeilen == 4) temp_2[1] = 4 + 9;   // anzahl Zeilen --> + 8 bedeutet: ersten Pollingzyklus freilassen
   else                   temp_2[1] = 2 + 9;
   SendOutData('h',SlaveAdresse,(unsigned char *) &temp_2,sizeof(temp_2));
   ErwarteAntwort = '0';
   DisplayBusy = 90;
   PollDisplay = 0;
  }


// KanalSlave = 0;
 if(!DisplayBusy)
 {
   for(i=0;i<26;i++)
    {
	 if(++KanalSlave >= 26)
	  {
        SendeRemoteKanaele(key);
		KanalSlave = 1;
//		i = 100;
      }
     if(!TeilnehmerHatDaten[KanalSlave]) break;
	 else TeilnehmerHatDaten[KanalSlave]--;
	}
//   if(i < 26) 
    {
     SendOutData('k',KanalSlave,(unsigned char *) &temp_3,sizeof(temp_3));
     ErwarteAntwort = 'K';
     TeilnehmerHatDaten[KanalSlave] = 27;
	}
//   if(++KanalSlave > AnzahlTeilnehmer) KanalSlave = 1;
 }
}
