#ifndef _UART_H
 #define _UART_H

#define MIN_TX_DELAY 5

extern unsigned volatile char UebertragungAbgeschlossen;
extern unsigned volatile char PC_DebugTimeout;
extern unsigned char TX_DigTransferKanalL;
extern unsigned char TX_DigTransferKanalH;
extern unsigned char TX_DigTransferKanalDaten;
volatile extern unsigned char DisplayBusy;
extern unsigned char AntwortEingetroffen;
extern unsigned char ErwarteAntwort;
extern unsigned volatile int CntCrcError;
extern unsigned char AnzahlTeilnehmer;
extern volatile unsigned char WaitTXD; // minimale Zeit zwischen zwei Sende-Daten
extern void UART_Init (void);
extern int uart_putchar (char c);
extern void boot_program_page (uint32_t page, uint8_t *buf);
extern void SimuliereTxDaten(void);
extern void BearbeiteRxDaten(void);
extern unsigned char TeilnehmerHatDaten[30];
extern unsigned char KanalRelaisLifetime; // Lifetime
extern unsigned char KanalRelaisWert; 
extern unsigned char DebuggerRelaisLifetime; // Lifetime
extern unsigned char DebuggerRelaisWert; 


//Die Baud_Rate der Seriellen Schnittstelle ist 9600 Baud
//#define BAUD_RATE 9600		//Baud Rate fr die Serielle Schnittstelle	
//#define BAUD_RATE 14400		//Baud Rate fr die Serielle Schnittstelle	
//#define BAUD_RATE 28800		//Baud Rate fr die Serielle Schnittstelle	
//#define BAUD_RATE 38400		//Baud Rate fr die Serielle Schnittstelle	
#define BAUD_RATE 57600		//Baud Rate fr die Serielle Schnittstelle	

//Anpassen der seriellen Schnittstellen Register wenn ein ATMega128 benutzt wird
#if defined (__AVR_ATmega128__)
#	define USR UCSR0A
#	define UCR UCSR0B
#	define UDR UDR0
#	define UBRR UBRR0L
#	define EICR EICRB
#endif

#if defined (__AVR_ATmega32__)
#	define USR UCSRA
#	define UCR UCSRB
#	define UBRR UBRRL
#	define EICR EICRB
#   define INT_VEC_RX  SIG_UART_RECV
#   define INT_VEC_TX  SIG_UART_TRANS
#endif

#if defined (__AVR_ATmega644__)
#	define USR  UCSR0A
#	define UCR  UCSR0B
#	define UDR  UDR0
#	define UBRR UBRR0L
#	define EICR EICR0B
#   define TXEN TXEN0
#   define RXEN RXEN0
#   define RXCIE RXCIE0
#   define TXCIE TXCIE0
#   define U2X  U2X0
#   define UCSRB UCSR0B
#   define UDRE UDRE0
#   define INT_VEC_RX  SIG_USART_RECV
#   define INT_VEC_TX  SIG_USART_TRANS
#endif


#endif //_UART_H
