.syntax unified
.arch armv7-m
.thumb

/* this is only a very basic vector table; if more vectors are used, create a
   new vector table in the C code and use the VTOR register */
.section .vectors
.long   StackTop        /* initial sp */
.long   ResetHandler    /* reset entry point */
.long   dummy_handler   /* nmi */
.long   dummy_handler   /* hardfault */
.long   dummy_handler   /* memmanage */
.long   dummy_handler   /* busfault */
.long   dummy_handler   /* usagefault */
.long   0               /* reserved */
.long   dummy_handler   /* svcall */
.long   dummy_handler   /* debug monitor */
.long   0               /* reserved */
.long   dummy_handler   /* pendsv */
.long   dummy_handler   /* systick */

.text

.thumb_func
ResetHandler:

/* copy initialised data from flash to ram */
    ldr    r1, =_etext
    ldr    r2, =_sdata
    ldr    r3, =_edata
    subs   r3, r2
    ble    1f
1:
    subs   r3, #4
    ldr    r0, [r1, r3]
    str    r0, [r2, r3]
    bgt    1b
1:

/* this fills the stack initially with some pattern; this allows one to find out
   the max. stack usage */
    ldr    r0,=stackstart
    mov    r1,#0xdcdcdcdc
1:
    cmp    sp,r0
    beq    1f
    str    r1,[r0]
    add    r0,#4
    b      1b
1:

/* this enables the FPU if necessary */
#ifdef __FPU_USED
    ldr    r0, =0xe000ed88
    ldr    r1, [r0]
    orr    r1, r1, #(0xf << 20)
    str    r1, [r0]
    dsb
    isb
#endif

/* clear the bss region */
    mov    r0, #0
    ldr    r1, =_sbss
    ldr    r2, =_ebss
1:
    cmp    r1, r2
    beq    1f
    str    r0, [r1], #4
    b      1b
1:

    bl     main
    b      .

.thumb_func
dummy_handler:
    b      .

    .end
