﻿// Uart Initialisieren auf 38400Baud
#include <avr/io.h> //Portpins


void InitUART()
{

	UCSRA&=0xFC;		//U2X=0, kein MCPM
	UCSRB=0x98;			//RX/TX-Enable, IRQ-Enable
	UBRRH=0x00;
	UCSRC=0x86;			//8Bit, Kein Parity, ein Stop
	UBRRL=0x33;			// Baud-Rate @8MHz = 1200Baud
	UDR=0x41;
}

// Sendet Zeichenkette, wartet bis alles gesendet
void SendUART(char* zeig)
{
	int i=0;
	while (zeig[i]!=0)				//Solange String nicht zu Ende
	{
		UDR=zeig[i];
		i++;
		while(!(UCSRA&(1<<UDRE)))	//Warte bis Zeichen gesendet...
		;
	}
}

void ReceiveUART()
{
	while(!(UCSRA&(1<<RXC)))
	{
		char a[2]="Z";
		a[0]=char(UDR);
		SendUART(a);
	}
}
