/*
 * Aquasteuer_V1_0.cpp
 *
 * Created: 16.03.2020 20:16:58
 *  Author: Matze
 */ 

#ifndef F_CPU
#define F_CPU 1000000UL
#endif


#include <util/delay.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include "RS232.h"
#include "TWI_Master.h"

void InituC()
{
	DDRD = 0xf2;   //Ausgang fr 5A-LoW-Treiber, Ausgang fr RS232-TX
	DDRC = 0x00;   //I2C, Periph/uc = input
	DDRB = 0x00;   //kein SPI oder externe eingnge
	DDRA = 0x00;   //Keine Analog-Eingang nutzung
	sei();         //Global IRQ-Enable
}

int main(void)
{
	TWI_Master_Initialise();
	InituC();
	InitUART();
	unsigned char write_addr0[2] ={0xd0,0x00};
		
		
	//char a[] = {0x01,0x02,0x00};
		
	//char []
    while(1)
    {
		_delay_ms(1000);
		//PORTD &= 0x0F;
		//SendUART(a);
		//addr=11010000 = Write
		//1Byte Word-Addr
		//n. data-Byte
		//addr=11010001 = read
		TWI_Start_Transceiver_With_Data(write_addr0 , 2);
		_delay_ms(1000);
		//unsigned char TWI_Get_Data_From_Transceiver( unsigned char *, unsigned char );
		//SendUART("b");
		PORTC = 0x00;
		PORTD |= 0xf0;
    }
}

ISR(USART_RXC_vect)			//Wartet auf ein erstes Zeichen des PC's
{
	UCSRB=0x18;				//IRQ abschalten
	char b=char(UDR);
	char e[6]="OOOOO";
	e[5]=0;
	char s[2]="O";
	s[1]=0;
	SendUART("P");
	if (b=='R')				//Es werden Daten geschrieben
	{						//Nun wird der Datensatz empfangen
		SendUART("Q");
		for (int i=0;i<=4;i++)	//Der Datensatz enthlt 5 Zeichen
		{
			while(!(UCSRA&(1<<RXC)))
			{
			}
			e[i]=char(UDR);
		}
		if (e[0]=='R')	//Setze Zeiten fr Rote-LED's
		{
			SendUART("R");
		}
		if (e[0]=='Y')	//Setze zeiten fr Gelbe LED's
		{
			SendUART("S");
		}
		if (e[0]=='B')	//Setze Zeiten fr Hellen LED's
		{
			SendUART("T");
		}
		//SendUART(a);	//Sendet gesamten Datensatz zur Kontrolle --> Funktioniert korrekt
	}
	else if (b=='S')		//Es sollen Daten abgerufen werden
	{
		SendUART("A");
		for (int i=0;i<1;i++)	//Es wird auf eine 1-Zeichen Addresse gewartet... um 99 Elemente adressieren zu knnen
		{
			SendUART("B");
			while(!(UCSRA&(1<<RXC)))
			{
			}
			s[i]=char(UDR);
		}
		SendUART("C");
		//Nun wurde die Adresse komplett empfangen
		if (s[0]=='R')	//Lese zeiten der Roten LEDs
		{
			SendUART("D");
			//Send_LBD_Zeit();
		}
		if (s[0]=='Y')	//Lese zeiten der weien LEDs
		{
			SendUART("E");
			//Send_LBD_Zeit();
		}
		if (s[0]=='B')	//Lese zeiten der Hellen LEDs
		{
			SendUART("F");
			//Send_LBD_Zeit();
		}
	}
	UCSRB=0x98;				//IRQ Einschalten
}