;################################################################################
;#										#
;# libi2c - i2c library for ATmega controllers					#
;# copyright (c) 2007-2009 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 2		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; withsts even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;-------------------------------------------------------------------------------
; initialize twi
;-------------------------------------------------------------------------------
libi2c_initl:	cbi	portd,6
		ldi	tempreg1,92		;set bitrate
		sts	TWBR,tempreg1
		ldi	tempreg1,(1<<TWEN) | (1<<TWINT)	;enable twi
		sts	TWCR,tempreg1

;-------------------------------------------------------------------------------
; generate stop condition
;-------------------------------------------------------------------------------
libi2c_stop:	ldi	tempreg1,(1<<TWSTO) | (1<<TWINT) | (1<<TWEN)
		sts	TWCR,tempreg1			;set control
		ret

;-------------------------------------------------------------------------------
; generate start condition
;-------------------------------------------------------------------------------
libi2c_start:	ldi	tempreg1,(1<<TWSTA) | (1<<TWINT) | (1<<TWEN)
		rjmp	libi2c_wready
		
;-------------------------------------------------------------------------------
; write byte (tempreg2) to I2C
;-------------------------------------------------------------------------------
libi2c_wbyte:	sts	TWDR,tempreg2
		ldi	tempreg1,(1<<TWINT) | (1<<TWEN)
		rjmp	libi2c_wready

;-------------------------------------------------------------------------------
; read byte (tempreg2) from I2C (ACK)
;-------------------------------------------------------------------------------
libi2c_rbyte:	ldi	tempreg1,(1<<TWINT) | (1<<TWEN) | (1<<TWEA)
		rcall	libi2c_wready
		lds	tempreg2,TWDR			;get data
		ret

;-------------------------------------------------------------------------------
; read byte (tempreg2) from I2C (NACK)
;-------------------------------------------------------------------------------
libi2c_rbyten:	ldi	tempreg1,(1<<TWINT) | (1<<TWEN)
		rcall	libi2c_wready
		lds	tempreg2,TWDR			;get data
		ret

;-------------------------------------------------------------------------------
; set control to tempreg1 and wait for TWI is ready
;-------------------------------------------------------------------------------
libi2c_wready:	sts	TWCR,tempreg1			;set control
libi2c_wready1:	lds	tempreg1,TWCR			;get control
		sbrs	tempreg1,TWINT			;skip if ready
		rjmp	libi2c_wready1			;loop
		lds	tempreg3,TWSR			;get status
		andi	tempreg3,0xf8			;mask bits
		ret					;thats all

;-------------------------------------------------------------------------------
; write memory address X to I2C EEPROM (tempreg4)
;-------------------------------------------------------------------------------
libi2c_wad:	rcall	libi2c_start		;start condition
		cpi	tempreg3,0x08
		brne	libi2c_wad_e		;error
		mov	tempreg2,tempreg4	;write devsel
		lsl	tempreg2
		andi	tempreg2,0x0e		;mask
		ori	tempreg2,0xa0		;EEPROM devsel
		rcall	libi2c_wbyte		
		cpi	tempreg3,0x18
		brne	libi2c_wad_e		;error
		mov	tempreg2,XH		;write address MSB
		rcall	libi2c_wbyte		
		cpi	tempreg3,0x28
		brne	libi2c_wad_e		;error
		mov	tempreg2,XL		;write address LSB
		rcall	libi2c_wbyte		
		cpi	tempreg3,0x28
		brne	libi2c_wad_e		;error
		clr	ereg
		ret
libi2c_wad_e:	ldi	ereg,15			;set error
		pop	tempreg2		;kill stack
		pop	tempreg2
		rjmp	libi2c_stop		;stop condition and end

;-------------------------------------------------------------------------------
; read data byte X+ from external eeprom (tempreg4) to tempreg2
;-------------------------------------------------------------------------------
.ifdef use_libi2c_read
libi2c_read:	rcall	libi2c_wad		;write address
		rcall	libi2c_start		;repeated start condition
		cpi	tempreg3,0x10
		brne	libi2c_read1		;error
		mov	tempreg2,tempreg4	;read devsel
		lsl	tempreg2
		andi	tempreg2,0x0e		;mask 
		ori	tempreg2,0xa1		;EEPROM devsel
		rcall	libi2c_wbyte		
		cpi	tempreg3,0x40
		brne	libi2c_read1		;error
		rcall	libi2c_rbyten		;read byte with NACK
		cpi	tempreg3,0x58		;error?
		brne	libi2c_read1
		adiw	XL,1			;X+1
		clr	ereg
		rjmp	libi2c_stop

libi2c_read1:	ldi	ereg,15			;I2C error
		rjmp	libi2c_stop		;generate stop condition
.endif

;-------------------------------------------------------------------------------
; write data byte tempreg2 to external eeprom (tempreg4) address X+
;-------------------------------------------------------------------------------
.ifdef use_libi2c_write
libi2c_write:	mov	r0,tempreg2		;save data
		rcall	libi2c_wad		;write address
		mov	tempreg2,r0		;restore data
		rcall	libi2c_wbyte		;write byte
		cpi	tempreg3,0x28		;error?
		brne	libi2c_write1
		adiw	XL,1			;Y+1
		clr	ereg
		rjmp	libi2c_stop

libi2c_write1:	ldi	ereg,15			;I2C error
		ret
.endif

;-------------------------------------------------------------------------------
; read temperature from external lm75 sensor no. (tempreg4) to X
;-------------------------------------------------------------------------------
.ifdef use_libi2c_lm75
libi2c_rlm75:	rcall	libi2c_start		;start condition
		cpi	tempreg3,0x08
		brne	libi2c_rlm75e		;error
		mov	tempreg2,tempreg4	;sensor number		
		andi	tempreg2,0x07		;8 addresses
		lsl	tempreg2		;set correct devsel
		ori	tempreg2,0x91
		rcall	libi2c_wbyte
		cpi	tempreg3,0x40		;error?
		brne	libi2c_rlm75e
		rcall	libi2c_rbyte		;read byte with ACK
		cpi	tempreg3,0x50		;error?
		brne	libi2c_rlm75e
		mov	XL,tempreg2		;get low byte
		rcall	libi2c_rbyten		;read byte with NAK
		cpi	tempreg3,0x58		;error?
		brne	libi2c_rlm75e
		clr	XH			;high result
		lsl	tempreg2		; result * 2
		rol	XL
		brcc	libi2c_rlm751
		com	XH
libi2c_rlm751:	clr	ereg			;no error
		rjmp	libi2c_stop		;stop and end
		
libi2c_rlm75e:	ldi	ereg,15			;I2C error		
		rjmp	libi2c_stop
.endif
