;################################################################################
;#										#
;# libmio - multi i/o for ATMega644 version 0.41				#
;# video-bootloader								#
;# copyright (c) 2005-2008 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 2 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################
;-------------------------------------------------------------------------------
;bootloader init
;-------------------------------------------------------------------------------
libmio_bl_init:	cli
		ldi	XL,0x00
		mov	const_0,XL
		ldi	XL,0x01
		mov	const_1,XL
		ldi	XL,HIGH(stack)
		out	SPH,XL
		ldi	XL,LOW(stack)
		out	SPL,XL
		ldi	XH,0x00
libmio_bl_lo1:	ldi	XL,0x00		
libmio_bl_lo2:	dec	XL
		brne	libmio_bl_lo2
		dec	XH
		brne	libmio_bl_lo1

		ldi	XL,0xba			;port direction (+SPI)
		out	DDRB,XL
		ldi	XL,0xff
		out	PORTB,XL	

		ldi	XL,0x80			;port direction only green enabled
		out	DDRC,XL
		ldi	XL,0x00
		out	PORTC,XL	

		ldi	XL,0xf0			;set pin 4-7 as output
		out	DDRD,XL
		ldi	XL,0xff
		out	PORTD,XL	

		in	XL,PINC			;get portc (bit 2-4 = config)
		andi	XL,0x1f			;clear editor mode bit
		sts	libmio_config,XL	;store configuration

		sbic	PIND,3			;serial pin
		rjmp	libmio_bl_end		;is high
			
;-------------------------------------------------------------------------------
;timer configuration
;-------------------------------------------------------------------------------
		ldi	XH,0xc2			;FAST-PWM-Mode 14 (PWM channel B)
		sts	TCCR1A,XH
		ldi	XH,0x19			;FAST-PWM-Mode (no prescaler)
		sts	TCCR1B,XH
		ldi	ZH,HIGH(libmio_counter_p-1)
		sbrs	XL,2			;1 pal/ntsc bit
		ldi	ZH,HIGH(libmio_counter_n-1)
		sts	ICR1H,ZH
		ldi	ZH,LOW(libmio_counter_p-1)
		sbrs	XL,2			;1 pal/ntsc bit
		ldi	ZH,LOW(libmio_counter_n-1)
		sts	ICR1L,ZH

		sts	OCR1AH,const_0		;we use only 8 bits
		ldi	ZH,libmio_hslen		;1 hsync length
		sts	OCR1AL,ZH		

		ldi	XL,0x02
		sts	TIMSK1,XL		;enable compare OC1A int

		ldi	XL,0x40			;ctc and enable output
		out	TCCR0A,XL
		ldi	XL,0x01
		out	TCCR0B,XL
		ldi	XL,49			;ca. 200KHz
		out	OCR0A,XL			

;-------------------------------------------------------------------------------
;usart configuration (synchronous for keyboard)
;-------------------------------------------------------------------------------
		sts	UCSR0A,const_0
		ldi	XL,0x10
		sts	UCSR0B,XL
		ldi	XL,0x66
		sts	UCSR0C,XL
				
;-------------------------------------------------------------------------------
;clear video-RAM and set pointers
;-------------------------------------------------------------------------------
		ldi	ZL,LOW(libmio_bl_txt1*2)
		ldi	ZH,HIGH(libmio_bl_txt1*2)
		rcall	libmio_bl_ct
		ldi	XL,34			;no of chars
libmio_bl_lo3:	lpm	XH,Z+			;copy text to screen
		st	Y+,XH
		dec	XL
		brne	libmio_bl_lo3
;set vector table to bootloader
		in	r16,MCUCR		;get MCUCR
		ori	r16,0x03		;set
		out	MCUCR,r16		;out
		andi	r16,0xfe		;
		out	MCUCR,r16				
		sei				;enable Interrupts

;-------------------------------------------------------------------------------
;the main loop
;-------------------------------------------------------------------------------				
libmio_bl_m01:	ldi	XL,200			;wait loop (2s)
libmio_bl_m02:	rcall	libmio_bl_sy		;sync
		lds	XH,UDR0
		cpi	XH,0x78			;F11 key
		breq	libmio_bl_m03		;yes->start BL
		dec	XL			;loop counter
		brne	libmio_bl_m02		;loop
		rjmp	libmio_bl_end		;end
					
libmio_bl_m03:	ldi	ZL,LOW(libmio_bl_txt2*2)
		ldi	ZH,HIGH(libmio_bl_txt2*2)
		rcall	libmio_bl_ct	
		ldi	tempreg1,0x15		;NAK
		rcall	libmio_bl_ps		;send
		
libmio_bl_m08:	ldi	YL,LOW(libmio_vram)	;set adr		
		ldi	YH,HIGH(libmio_vram)
		rcall	libmio_bl_gb		;read first block (0) to vram
		ldi	tempreg1,0x06		;ACK
		rcall	libmio_bl_ps		;send					
		ldi	ZL,0x00			;set pointer to start of Flash	
		ldi	ZH,0x00
		
libmio_bl_m10:	ldi	YL,LOW(bas_array+512)	;buffer address
		ldi	YH,HIGH(bas_array+512)
		rcall	libmio_bl_gb		;get block
		ldi	tempreg1,0x06		;ACK
		rcall	libmio_bl_ps		;send			
		ldi	YL,LOW(bas_array+640)	;buffer address
		ldi	YH,HIGH(bas_array+640)						
		rcall	libmio_bl_gb		;get block
		cpi	ZH,0x8e			;end
		brcc	libmio_bl_m11		;beyond end							
		call	mem_writepage
		adiw	ZL,2
		sei
libmio_bl_m11:	ldi	tempreg1,0x06		;ACK
		rcall	libmio_bl_ps		;send			
		ldi	XL,LOW(libmio_vram+22)	;set adr		
		ldi	XH,HIGH(libmio_vram+22)				
		rcall 	libmio_bl_sbn		;show block number
		rjmp	libmio_bl_m10		;loop
				
libmio_bl_end:	cli				;disable Interrupts
;set vector table to main
		in	r16,MCUCR		;get MCUCR
		ori	r16,0x01		;set
		out	MCUCR,r16		;out
		andi	r16,0xfc		;
		out	MCUCR,r16		;
		jmp	0x000			;restart system

;------------------------------------------------------------------------------
;get block to bas_array+512
;------------------------------------------------------------------------------		
libmio_bl_gb:	rcall	libmio_bl_gs		;get SOH/EOT (0x01) and ignore
		cpi	tempreg1,0x04		;EOT
		brne	libmio_bl_gb2		;no
		ldi	tempreg1,0x06		;ACK
		rcall	libmio_bl_ps		;send		
libmio_bl_gb1:	lds	XH,libmio_tcnt		;counter
		cpi	XH,0x00			;ready?
		brne	libmio_bl_gb1		;loop		
		rjmp	libmio_bl_end		;end
		
libmio_bl_gb2:	ldi	tempreg2,0x80		;data bytes
		rcall	libmio_bl_gs		;get blockno and ignore
		rcall	libmio_bl_gs		;get inv blockno and ignore
libmio_bl_gb3:	rcall	libmio_bl_gs		;get data
		st	Y+,tempreg1		
		dec	tempreg2
		brne	libmio_bl_gb3
		rjmp	libmio_bl_gs		;get checksum and ignore						

;------------------------------------------------------------------------------
;write blocknumber as hex
;------------------------------------------------------------------------------				
libmio_bl_sbn:	mov	tempreg1,ZH		;
		swap	tempreg1		;high-nibble
		rcall	libmio_bl_oh
		mov	tempreg1,ZH		;

; out hexadecimal char (tempreg1)
libmio_bl_oh:	andi	tempreg1,0x0f		;mask nibble
		subi	tempreg1,0xd0		;+30
		cpi	tempreg1,0x3a		;>9
		brcs	libmio_bl_oh_1		;jump, if not
		subi	tempreg1,0xf9		;+6
libmio_bl_oh_1:	st	X+,tempreg1
		ret		
						
;------------------------------------------------------------------------------
;put tempreg1 to serial output
;------------------------------------------------------------------------------
libmio_bl_ps:	push	XH
libmio_bl_ps_1:	lds	XH,libmio_tcnt		;counter
		cpi	XH,0x00			;ready?
		brne	libmio_bl_ps_1		;loop
		sts	libmio_tdat,tempreg1	;store data
		dec	XH			;prepare 0xff
		sts	libmio_tcnt,XH		;store start
		pop	XH
		ret				;thats all

;------------------------------------------------------------------------------
;get tempreg1 from serial input
;------------------------------------------------------------------------------
libmio_bl_gs:	push	XH
libmio_bl_gs_1:	lds	XH,libmio_rcnt		;counter
		cpi	XH,0x00			;ready?
		brne	libmio_bl_gs_1		;loop
		dec	XH			;prepare 0xff
		sts	libmio_rcnt,XH		;store start
libmio_bl_gs_2:	lds	XH,libmio_rcnt		;counter
		cpi	XH,0x00			;ready?
		brne	libmio_bl_gs_2		;loop
		lds	tempreg1,libmio_rdat	;get char
		pop	XH
		ret				;thats all			

;-------------------------------------------------------------------------------
; wait for the end of visible frame
;-------------------------------------------------------------------------------
libmio_bl_sy:	push	XL
libmio_bl_sy_1:	mov	XL,vline_l
		cpi	XL,libmio_pixel_rows+1
		breq	libmio_bl_sy_1
libmio_bl_sy_2:	mov	XL,vline_l
		cpi	XL,libmio_pixel_rows+1
		brne	libmio_bl_sy_2
		pop	XL
		ret		    

;-------------------------------------------------------------------------------
; copy text
;-------------------------------------------------------------------------------
libmio_bl_ct:	ldi	YL,LOW(libmio_vram)
		ldi	YH,HIGH(libmio_vram)
		ldi	XL,34			;no of chars
libmio_bl_ct1:	lpm	XH,Z+			;copy text to screen
		st	Y+,XH
		dec	XL
		brne	libmio_bl_ct1
		ret
				
libmio_bl_txt1:	.db	"AVR-ChipBasic2 (F11=Update Sys) "
libmio_bl_txt2:	.db	"Bootloader Error (ESC to exit)  "
		