;################################################################################
;#										#
;# libmio - multi i/o for ATMega644 version 0.41				#
;# video-bootloader								#
;# copyright (c) 2005-2008 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 2 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################
libmio_bl:	jmp	libmio_bl_init		;0
		nop				;+2
		nop
		nop				;+4
		nop
		nop				;+6
		nop
		nop				;+8
		nop
		nop				;+a
		nop
		nop				;+c
		nop
		nop				;+e
		nop
		nop				;+10
		nop
		nop				;+12
		nop
		nop				;+14
		nop
		nop				;+16
		nop
		nop				;+18
		nop
		jmp	libmio_bli

;-------------------------------------------------------------------------------		
;video-interrupt (no registers destroyed, stack=13)
;save registers
;-------------------------------------------------------------------------------		
libmio_bli:	push	tempreg1		;2
		push	tempreg2		;2
		push	tempreg3		;2
		push	ZH			;2 save Z-register
		push	ZL			;2 save Z-register
		push	YH			;2 save Y-register
		push	YL			;2 save Y-register
		push	XH			;2 save Y-register
		push	XL			;2 save Y-register
		push	r0			;2 save r0
		push	r1			;2 save r1		
		in	ZH,SREG			;1 save status
		push	ZH			;2

;-------------------------------------------------------------------------------
; set pointer for code saving
;-------------------------------------------------------------------------------
		ldi	YL,LOW(libmio_ram)	;1 set ptr
		ldi	YH,HIGH(libmio_ram)	;1
						
;-------------------------------------------------------------------------------		
;serial port io
;-------------------------------------------------------------------------------
		ldd	XH,Y+lmo_serio		;2 serial io
		sbrs	XH,7			;1 skip if 1-bit
		cbi	PORTD,4			;2 clear pin
		sbrc	XH,7			;1 skip if 0-bit
		sbi	PORTD,4			;2 set pin
		sbic	PIND,3			;1 check signal
		andi	XH,0xfe			;1
		sbis	PIND,3			;1 check signal
		ori	XH,0x01			;1
		std	Y+lmo_serio,XH		;2

;-------------------------------------------------------------------------------		
;count line up and set border
;-------------------------------------------------------------------------------
		add	vline_l,const_1		;1
		adc	vline_h,const_0		;1
				
;-------------------------------------------------------------------------------		
;check if line is image
;-------------------------------------------------------------------------------
		ldd	ZL,Y+lmo_config		;2 configuration
		mov	ZH,vline_h		;1 10 max visible lines
		cpi	ZH,0x00
		brne	libmio_bli_02
		mov	ZH,vline_l		
		cpi	ZH,10			;1 max lines
		brcs	libmio_bli_50		;2 goto image-line			
		cpi	ZH,230
		brcs	libmio_bli_06
		
;-------------------------------------------------------------------------------
;no image line
;-------------------------------------------------------------------------------			
libmio_bli_02:	ldi	ZH,libmio_vstart_p	;1 vstart pal
		sbrs	ZL,2			;1 pal/ntsc bit
		ldi	ZH,libmio_vstart_n	;1 vstart ntsc
		cp	vline_l,ZH
		brne	libmio_bli_03		;no vsync start
		cbi	PORTD,6
		sbrs	ZL,3			;csync bit
		rjmp	libmio_bli_06  
		ldi	XH,0x82			;invert CSYNC
		sts	TCCR1A,XH
		rjmp	libmio_bli_06  


libmio_bli_03:	ldi	ZH,libmio_vstop_p	;1 vstop pal
		sbrs	ZL,2			;1 pal/ntsc bit
		ldi	ZH,libmio_vstop_n	;1 vstop ntsc
		cp	vline_l,ZH
		brne	libmio_bli_04		;no vsync stop
		sbi	PORTD,6
		sbrs	ZL,3			;csync bit
		rjmp	libmio_bli_06  
		ldi	XH,0xc2			;normal CSYNC
		sts	TCCR1A,XH
		rjmp	libmio_bli_06  

libmio_bli_04:	ldi	ZH,57			;1 maxlines pal
		sbrs	ZL,2			;1 pal/ntsc bit
		ldi	ZH,7			;1 maxlines ntsc
		cp	vline_l,ZH
		brne	libmio_bli_06		;2 end of frame		
		
libmio_bli_05:	clr	vline_l			;line_l=0
		clr	vline_h			;line_h=0
libmio_bli_06:	rjmp	libmio_bli_ser		;goto serial

;-------------------------------------------------------------------------------
;sync to counter
;-------------------------------------------------------------------------------		
libmio_bli_50:	lds	XL,TCNT1L		;1 get timer
		cpi	XL,libmio_hstart+70 	;1
		brcs	libmio_bli_50		;1 loop		
libmio_bli_51:	cpi	XL,libmio_hstart+71	
		brcs	libmio_bli_52
libmio_bli_52:	cpi	XL,libmio_hstart+72	
		brcs	libmio_bli_53
libmio_bli_53:	cpi	XL,libmio_hstart+73	
		brcs	libmio_bli_54
libmio_bli_54:	cpi	XL,libmio_hstart+74	
		brcs	libmio_bli_55
libmio_bli_55:	
			
;-------------------------------------------------------------------------------
; -output character line 4 clocks per pixel
; -256 characters are in table 6x12px each
;-------------------------------------------------------------------------------
libmio_bli_60:	ldi	XL,LOW(libmio_vram)	;2 BS low
		ldi	XH,HIGH(libmio_vram)	;1 BS high
		ldi	ZH,HIGH(libmio_ctable*2)	;start chartable
		add	ZH,vline_l		;1

		ldi	YL,32			;1 no of chars
		ld	ZL,X+			;2 get char
		lpm	tempreg2,Z		;3 get pixline
		ldi	tempreg1,0x00		;2 black
		ldi	tempreg3,0x80

libmio_bli_61:	out	PORTC,tempreg1		;1 out P0
		ld	ZL,X+			;2 get next char		
		sbrc	tempreg2,6		;1 check P1 
		
		out	PINC,tempreg3		;1 out P1
		nop				;1 filling
		nop				;1 filling
		sbrc	tempreg2,5		;1 check P2
		
		out	PINC,tempreg3		;1 out P2
		lpm	r0,Z			;3
		sbrc	tempreg2,4		;1 check P3

		out	PINC,tempreg3		;1 out P3
		dec	YL			;1		
		nop				;1 filling
		sbrc	tempreg2,3		;1 check P4
		
		out	PINC,tempreg3		;1 out P4
		nop				;1 filling
		nop				;1 filling
		sbrc	tempreg2,2		;1 check P4
		
		out	PINC,tempreg3		;1 out P5=0
		mov	tempreg2,r0		;1		
		brne	libmio_bli_61		;2 loop
		
		nop				;1 filling
		out	PORTC,const_0		;1 end of line
		
libmio_bli_ser: rcall	libmio_bl_2rx		;serio 2400 Bps
		

;-------------------------------------------------------------------------------
;abort if esc (scan 0x76) received
;-------------------------------------------------------------------------------			
		lds	ZL,UDR0			;2
		cpi	ZL,0x76			;esc
		brne	libmio_bli_90		;no
		jmp	libmio_bl_end		;yes	
		
;-------------------------------------------------------------------------------
;restore registers and exit
;-------------------------------------------------------------------------------		
libmio_bli_90:	pop	ZH			;2 restore sreg
		out	SREG,ZH			;1 put back    
		pop	r1			;2 restore r1
		pop	r0			;2 restore r0
		pop	XL			;2 restore Y-register
		pop	XH			;2 restore Y-register
		pop	YL			;2 restore Y-register
		pop	YH			;2 restore Y-register
		pop	ZL			;2 restore Z-register
		pop	ZH			;2 restore Z-register
		pop	tempreg3		;
		pop	tempreg2		;2
		pop	tempreg1		;2 restore register
		reti				;4 thats all

;-------------------------------------------------------------------------------
;serial port (receive 2400)
;-------------------------------------------------------------------------------		
libmio_bl_2rx:	lds	XL,libmio_serio		;2 get signal byte
		lds	ZL,libmio_rcnt		;2 clock counter
		cpi	ZL,0x00			;1 end
		breq	libmio_bl_2rxe		;1/2		
		cpi	ZL,0xff			;1 wait for sig
		brne	libmio_bl_2rx1		;1/2
		sbrc	XL,0			;1 skip if line is 0
		rjmp	libmio_bl_2rxe		;1/2
		ldi	ZL,62			;1 start value 2400
		rjmp	libmio_bl_2rxe		;2
		
;+9		
libmio_bl_2rx1:	dec	ZL			;1 counter -1
		ldi	ZH,HIGH(libmio_kstab*2)	;1 set start of table
		lpm	XH,Z			;3
		sbrs	XH,5			;1 skip if sample bit
		rjmp	libmio_bl_2rxe		;2
		
		lds	XH,libmio_rdat		;2 serial data
		lsr	XH			;1
		bst	XL,0			;1 RXD data
		bld	XH,7			;1 shift in
		sts	libmio_rdat,XH		;2

libmio_bl_2rxe:	sts	libmio_rcnt,ZL		;2
			
;-------------------------------------------------------------------------------
;serial port (transmit 2400)
;-------------------------------------------------------------------------------		
libmio_bl_2tx:	lds	ZL,libmio_tcnt		;2 clock counter
		cpi	ZL,0x00			;1
		breq	libmio_bl_2txe		;1/2 nothing to do
		cpi	ZL,0xff			;1 wait for start
		brne	libmio_bl_2tx1		;1/2
		ldi	ZL,72			;1
		andi	XL,0x7f			;1 clear bit		
		rjmp	libmio_bl_2txe		;2
;+7 clk		
libmio_bl_2tx1:	dec	ZL			;1 counter -1
		ldi	ZH,HIGH(libmio_kstab*2)	;1 set start of table
		lpm	XH,Z			;3
		sbrs	XH,4			;1 skip if setout bit
		rjmp	libmio_bl_2txe		;2
		
		lds	XH,libmio_tdat		;2
		bst	XH,0			;1
		sec				;1
		ror	XH			;1
		bld	XL,7			;1
		sts	libmio_tdat,XH		;2

libmio_bl_2txe:	sts	libmio_tcnt,ZL		;2
		sts	libmio_serio,XL		;2
		ret

;-------------------------------------------------------------------------------
;serial port (receive 1200)
;-------------------------------------------------------------------------------		
libmio_bl_1rx:	lds	XL,libmio_serio		;2 get signal byte
		lds	ZL,libmio_rcnt		;2 clock counter
		cpi	ZL,0x00			;1 end
		breq	libmio_bl_1rxe		;1/2		
		cpi	ZL,0xff			;1 wait for sig
		brne	libmio_bl_1rx1		;1/2
		sbrc	XL,0			;1 skip if line is 0
		rjmp	libmio_bl_1rxe		;1/2
		ldi	ZL,124			;1 start value 1200
		rjmp	libmio_bl_1rxe		;2
		
;+9		
libmio_bl_1rx1:	dec	ZL			;1 counter -1
		ldi	ZH,HIGH(libmio_kstab*2)	;1 set start of table
		lpm	XH,Z			;3
		sbrs	XH,7			;1 skip if sample bit
		rjmp	libmio_bl_1rxe		;2
		
		lds	XH,libmio_rdat		;2 serial data
		lsr	XH			;1
		bst	XL,0			;1 RXD data
		bld	XH,7			;1 shift in
		sts	libmio_rdat,XH		;2

libmio_bl_1rxe:	sts	libmio_rcnt,ZL		;2
			
;-------------------------------------------------------------------------------
;serial port (transmit 1200)
;-------------------------------------------------------------------------------		
libmio_bl_1tx:	lds	ZL,libmio_tcnt		;2 clock counter
		cpi	ZL,0x00			;1
		breq	libmio_bl_2txe		;1/2 nothing to do
		cpi	ZL,0xff			;1 wait for start
		brne	libmio_bl_1tx1		;1/2
		ldi	ZL,144			;1 start value 1200
		andi	XL,0x7f			;1 clear bit		
		rjmp	libmio_bl_2txe		;2
;+7 clk		
libmio_bl_1tx1:	dec	ZL			;1 counter -1
		ldi	ZH,HIGH(libmio_kstab*2)	;1 set start of table
		lpm	XH,Z			;3
		sbrs	XH,6			;1 skip if setout bit
		rjmp	libmio_bl_2txe		;2
		
		lds	XH,libmio_tdat		;2
		bst	XH,0			;1
		sec				;1
		ror	XH			;1
		bld	XL,7			;1
		sts	libmio_tdat,XH		;2
		rjmp	libmio_bl_2txe
		
		
		