;################################################################################
;#										#
;# libmio - multi i/o for ATMega644 version 0.40				#
;# circles									#
;# copyright (c) 2005-2008 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 2 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;------------------------------------------------------------------------------
;circle routines
;libmio_costab	= cosinus table 255->0 256 values
;------------------------------------------------------------------------------
.ifdef use_libmio_circle
libmio_circle:	push	XL
		push	XH
		push	ZL
		push	ZH
		push	tempreg2
		push	tempreg3
		push	r16
		push	r17
		push	r18		
		ldi	r17,0x00		;init oldvalues
		ldi	r18,0x00
		ldi	ZH,HIGH(libmio_costab*2)
		clr	ZL
		lds	tempreg2,libmio_bcdx	;rx
		andi	tempreg2,0x7f		;limit to 127
		lds	tempreg3,libmio_bcdy	;ry
		andi	tempreg3,0x7f		;limit to 127	
		
libmio_ci_10:	lpm	r16,Z			;cos
		mul	r16,tempreg2		;*rx
		mov	XL,r1			;new x offset
		com	ZL
		lpm	r16,Z			;sin
		com	ZL
		mul	r16,tempreg3		;*ry
		mov	XH,r1			;new y offset
		cp	XL,r17			;new X?
		brne	libmio_ci_12		;yes
		cp	XH,r18			;new Y?
		brne	libmio_ci_12		;yes
		inc	ZL			;loop counter
		brne	libmio_ci_10		;loop
		rjmp	libmio_ci_14		;end
		
libmio_ci_12:	mov	r17,XL			;set oldvalues
		mov	r18,XH
		lds	XL,libmio_bcsrcx	;X0
		lds	XH,libmio_bcsrcy	;Y0						
		add	XL,r17
		add	XH,r18
		call	libmio_plot		;plot
		lds	XL,libmio_bcsrcx	;X0
		lds	XH,libmio_bcsrcy	;Y0						
		add	XL,r17
		sub	XH,r18
		call	libmio_plot
		lds	XL,libmio_bcsrcx	;X0
		lds	XH,libmio_bcsrcy	;Y0						
		sub	XL,r17
		sub	XH,r18	
		call	libmio_plot
		lds	XL,libmio_bcsrcx	;X0
		lds	XH,libmio_bcsrcy	;Y0						
		sub	XL,r17
		add	XH,r18	
		call	libmio_plot
		inc	ZL			;loop counter
		brne	libmio_ci_10		;loop

libmio_ci_14:	pop	r18
		pop	r17
		pop	r16
		pop	tempreg3
		pop	tempreg2
		pop	ZH
		pop	ZL
		pop	YH
		pop	XL
		ret					
		
libmio_fcircle:	push	XL
		push	XH
		push	ZL
		push	ZH
		push	tempreg2
		push	tempreg3
		push	r16
		push	r17
		push	r18
		push	r19
		ldi	r18,0xff		;init oldvalue Y
		ldi	ZH,HIGH(libmio_costab*2)
		clr	ZL
		lds	tempreg2,libmio_bcdx	;rx
		andi	tempreg2,0x7f		;limit to 127
		lds	tempreg3,libmio_bcdy	;ry
		andi	tempreg3,0x7f		;limit to 127	
		
libmio_fci_10:	lpm	r16,Z			;X
		mul	r16,tempreg2		;*rx
		mov	XL,r1			;new x offset
		com	ZL
		lpm	r16,Z			;X
		com	ZL
		mul	r16,tempreg3		;*ry
		mov	XH,r1			;new y offset
		cp	XH,r18			;new Y?
		brne	libmio_fci_12		;yes
		inc	ZL			;loop counter
		brne	libmio_fci_10		;loop
		pop	r19
		rjmp	libmio_ci_14		;end
		
libmio_fci_12:	mov	r17,XL			;set oldvalue X
		mov	r18,XH			;set oldvalue y
		lds	XL,libmio_bcsrcx	;X0
		lds	XH,libmio_bcsrcy	;y0
		mov	r19,XL			;copy x0
		sub	XH,r18			;line Y
		sub	XL,r17			;start X
		add	r19,r17			;end X
libmio_fci_14:	call	libmio_plot		;set pix
		add	XH,r18
		add	XH,r18
		call	libmio_plot		;set pix
		sub	XH,r18			;line Y
		sub	XH,r18			;line Y
		inc	XL
		cp	r19,XL
		brcc	libmio_fci_14
		inc	ZL			;loop counter
		brne	libmio_fci_10		;loop
		pop	r19
		rjmp	libmio_ci_14
		
.endif		