#!/usr/bin/perl

$takt=16000000;
$pwm=256;
$maxcount=65536;
$fakt=3.5;


open ($fh, ">../soundtables.inc");

#---generate wave 1 ---------------------------
$sin1=0.65;
$cos1=0;
$sin2=0;
$cos2=0;
$sin3=0.2;
$cos3=0;
$sin4=0;
$cos4=0;
$sin5=0;
$cos5=0.1;
$sin6=0;
$cos6=0;
$sin7=0.05;
$cos7=0;

print $fh "libmio_wtable1:";
for($j=0;$j<16;$j++)
{
    print $fh "\n    .db ";
     for($i=0;$i<16;$i++)
    {
	$x=$i+16*$j;
	$y=0;
	$y+=$sin1*127*sin($x*3.1416/128);
	$y+=$cos1*127*cos($x*3.1416/128);
	$y+=$sin2*127*sin($x*3.1416/64);
	$y+=$cos2*127*cos($x*3.1416/64);
	$y+=$sin3*127*sin($x*3.1416/42.66667);
	$y+=$cos3*127*cos($x*3.1416/42.66667);
	$y+=$sin4*127*sin($x*3.1416/32);
	$y+=$cos4*127*cos($x*3.1416/32);
	$y+=$sin5*127*sin($x*3.1416/25.6);
	$y+=$cos5*127*cos($x*3.1416/25.6);
	$y+=$sin6*127*sin($x*3.1416/21.33333);
	$y+=$cos6*127*cos($x*3.1416/21.33333);
	$y+=$sin7*127*sin($x*3.1416/18.2857);
	$y+=$cos7*127*cos($x*3.1416/18.2857);
	if ($y<(-0.5)) {$y=256+$y};
	if ($y<1) {printf $fh "0x00"} else {printf $fh "%#2.2x",$y};
	if($i<15) {print $fh ","}    
    }
}

#---generate wave 2 ---------------------------
$sin1=0.25;
$cos1=0;
$sin2=0.25;
$cos2=0;
$sin3=0;
$cos3=0;
$sin4=0.25;
$cos4=0;
$sin5=0;
$cos5=0;
$sin6=0.25;
$cos6=0;
$sin7=0.00;
$cos7=0;

print $fh "\nlibmio_wtable2:";
for($j=0;$j<16;$j++)
{
    print $fh "\n    .db ";
     for($i=0;$i<16;$i++)
    {
	$x=$i+16*$j;
	$y=0;
	$y+=$sin1*127*sin($x*3.1416/128);
	$y+=$cos1*127*cos($x*3.1416/128);
	$y+=$sin2*127*sin($x*3.1416/64);
	$y+=$cos2*127*cos($x*3.1416/64);
	$y+=$sin3*127*sin($x*3.1416/42.66667);
	$y+=$cos3*127*cos($x*3.1416/42.66667);
	$y+=$sin4*127*sin($x*3.1416/32);
	$y+=$cos4*127*cos($x*3.1416/32);
	$y+=$sin5*127*sin($x*3.1416/25.6);
	$y+=$cos5*127*cos($x*3.1416/25.6);
	$y+=$sin6*127*sin($x*3.1416/21.33333);
	$y+=$cos6*127*cos($x*3.1416/21.33333);
	$y+=$sin7*127*sin($x*3.1416/18.2857);
	$y+=$cos7*127*cos($x*3.1416/18.2857);
	if ($y<(-0.5)) {$y=256+$y};
	if ($y<1) {printf $fh "0x00"} else {printf $fh "%#2.2x",$y};
	if($i<15) {print $fh ","}    
    }
}

#---envelope 1 (simply e^-x) -------------------------------
print $fh "\n\nlibmio_etable:";
$ende=16;
for($j=0;$j<8;$j++)
{
    print $fh "\n    .db ";
    for($i=0;$i<16;$i++)
    {
	$x=$i+16*$j;
	$y=128*exp(-($x/$ende*$fakt))+0.5;
	if ($x > $ende) {$y=0};
	if (($y)<1) {printf $fh "0x00"} else {printf $fh "%#2.2x",$y};
	if ($i<15) {print $fh ","};
    }	
}

#---generate offset table for notes--------------------------
$sprung=exp(log(2)/12);
$samfrq=$takt/$pwm;
print $fh "\n\nlibmio_ntable:";

for($j=0;$j<8;$j++)
{
    print $fh "\n    .db ";
    for($i=0;$i<8;$i++)
    {
	$x=$i+8*$j;
	$freq=110*$sprung**($x+3);
	$delta=$maxcount*$freq/$samfrq;
	$y=int($delta+0.5);
	if (($y%256)<1) {printf $fh "0x00,"} else {printf $fh "%#2.2x,",$y%256};
	if (($y/256)<1) {printf $fh "0x00"} else {printf $fh "%#2.2x",$y/256};
	if ($i<7) {print $fh ","};
    }	
}

close($fh);

