;################################################################################
;#										#
;# libmio - multi i/o for ATMega644 version 0.40				#
;# main library									#
;# copyright (c) 2005-2008 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 2 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;-------------------------------------------------------------------------------		
;border-end-interrupt (no registers destroyed)
;-------------------------------------------------------------------------------		
libmio_bisr:	out	PORTC,const_0		;2
		reti

;-------------------------------------------------------------------------------		
;video-interrupt (no registers destroyed, stack=13)
;save registers
;-------------------------------------------------------------------------------		
libmio_aisr:	push	tempreg1		;2
		push	tempreg2		;2
		push	tempreg3		;2
		push	ZH			;2 save Z-register
		push	ZL			;2 save Z-register
		push	YH			;2 save Y-register
		push	YL			;2 save Y-register
		push	XH			;2 save Y-register
		push	XL			;2 save Y-register
		push	r0			;2 save r0
		push	r1			;2 save r1		
		in	ZH,SREG			;1 save status
		push	ZH			;2
		sts	libmio_wasvint,const_1	;2 mark interrupt
		
;-------------------------------------------------------------------------------		
;serial port io
;-------------------------------------------------------------------------------
		lds	XH,libmio_serio		;2 serial io
		sbrs	XH,7			;1 skip if 1-bit
		cbi	PORTD,4			;2 clear pin
		sbrc	XH,7			;1 skip if 0-bit
		sbi	PORTD,4			;2 set pin
		sbic	PIND,3			;1 check signal
		andi	XH,0xfe			;1
		sbis	PIND,3			;1 check signal
		ori	XH,0x01			;1
		sts	libmio_serio,XH		;2

;-------------------------------------------------------------------------------
; set pointer for code saving
;-------------------------------------------------------------------------------
		ldi	YL,LOW(libmio_ram)	;1 set ptr
		ldi	YH,HIGH(libmio_ram)	;1
				
;-------------------------------------------------------------------------------
; calculate sound (34c)
;-------------------------------------------------------------------------------
		ldd	tempreg2,Y+lmo_rand2	;2 noise signal
		ldd	XL,Y+lmo_wpos_l		;2 wave pointer low
		ldd	ZL,Y+lmo_wpos_h		;2 wave pointer high
		ldd	r0,Y+lmo_woff_l		;2 wave offset low
		ldd	r1,Y+lmo_woff_h		;2 wave offset high
		add	XL,r0			;1 calculate new pointer
		adc	ZL,r1			;1 
		std	Y+lmo_wpos_l,XL		;2 writeback new pointer
		std	Y+lmo_wpos_h,ZL		;2 
		ldd	ZH,Y+lmo_wavtab		;1 start wavetable high
		lpm	tempreg1,Z		;3 get wave value
		ldd	XL,Y+lmo_note_val	;2 note val
		cpi	XL,0xff			;1
		brne	libmio_wa_01		;1/2
		mov	tempreg1,tempreg2	;1		
libmio_wa_01:	ldd	tempreg2,Y+lmo_envv	;2 envelope value
		mulsu	tempreg1,tempreg2	;2 shaped value
		ldi	XH,0x80			;1 neutral signal
		add	XH,r1			;1 add result
		sts	OCR2A,XH		;1 set level

;-------------------------------------------------------------------------------
; pseudo-random generator (31C)
;-------------------------------------------------------------------------------
		ldd	ZL,Y+lmo_rand1		;2
		ldd	ZH,Y+lmo_rand2		;2
		ldd	tempreg1,Y+lmo_rand3	;2
		ldd	tempreg2,Y+lmo_rand4	;2
		clr	XL			;1
		sbrc	ZL,2			;1
		com	XL			;1
		sbrc	ZL,5			;1
		com	XL			;1
		sbrc	ZH,4			;1
		com	XL			;1
		sbrc	tempreg2,7		;1
		com	XL			;1
		rol	XL			;1
		rol	ZL			;1
		rol	ZH			;1
		rol	tempreg1		;1
		rol	tempreg2		;1
		std	Y+lmo_rand1,ZL		;2
		std	Y+lmo_rand2,ZH		;2
		std	Y+lmo_rand3,tempreg1	;2
		std	Y+lmo_rand4,tempreg2	;2		
				
;-------------------------------------------------------------------------------		
;count line up and set border
;-------------------------------------------------------------------------------
		add	vline_l,const_1		;1
		adc	vline_h,const_0		;1
		ldd	ZL,Y+lmo_sborder	;2
		ldd	ZH,Y+lmo_border		;2
		and	ZL,ZH			;1
		out	PORTC,ZL		;1
		sei				;1 -> testen?
				
;-------------------------------------------------------------------------------		
;check if line is image
;-------------------------------------------------------------------------------
		ldd	ZL,Y+lmo_config		;2 configuration
		sbrc	vline_h,0		;1 skip if less than 256
		rjmp	libmio_is_02		;2 no visible line
		ldd	ZH,Y+lmo_vislines
libmio_ismode1:	cp	vline_l,ZH		;1 max lines
		brcc	libmio_is_02		;2 goto no image-line
		rjmp	libmio_iss		;2 goto image line		

;-------------------------------------------------------------------------------
;no image line
;-------------------------------------------------------------------------------			
libmio_is_02:	ldi	ZH,libmio_vstart_p	;1 vstart pal
		sbrs	ZL,2			;1 pal/ntsc bit
		ldi	ZH,libmio_vstart_n	;1 vstart ntsc
		cp	vline_l,ZH
		brne	libmio_is_09		;no vsync start
		cbi	PORTD,6
		sbrs	ZL,3			;csync bit
		rjmp	libmio_is_15  
		ldi	XH,0x82			;invert CSYNC
		sts	TCCR1A,XH
		rjmp	libmio_is_15  


libmio_is_09:	ldi	ZH,libmio_vstop_p	;1 vstop pal
		sbrs	ZL,2			;1 pal/ntsc bit
		ldi	ZH,libmio_vstop_n	;1 vstop ntsc
		cp	vline_l,ZH
		brne	libmio_is_10		;no vsync stop
		sbi	PORTD,6
		sbrs	ZL,3			;csync bit
		rjmp	libmio_is_15  
		ldi	XH,0xc2			;normal CSYNC
		sts	TCCR1A,XH
		rjmp	libmio_is_15  

libmio_is_10:	ldi	ZH,libmio_bstart_p	;1 vstop pal
		sbrs	ZL,2			;1 pal/ntsc bit
		ldi	ZH,libmio_bstart_n	;1 vstop ntsc
		cp	vline_l,ZH
		brne	libmio_is_11		;no border start
		ldi	ZL,0xff
		sts	libmio_sborder,ZL
		rjmp	libmio_is_15  

libmio_is_11:	ldi	ZH,libmio_bstop_p	;1 vstop pal
		sbrs	ZL,2			;1 pal/ntsc bit
		ldi	ZH,libmio_bstop_n	;1 vstop ntsc
		cp	vline_l,ZH
		brne	libmio_is_13		;no border stop
		sts	libmio_sborder,const_0
		rjmp	libmio_is_15  		
								
libmio_is_13:	ldi	ZH,57			;1 maxlines pal
		sbrs	ZL,2			;1 pal/ntsc bit
		ldi	ZH,7			;1 maxlines ntsc
		cp	vline_l,ZH
		breq	libmio_is_14		;2 end of frame		
		rjmp	libmio_is_15  
		
libmio_is_14:	ldi	XL,LOW(libmio_vram)	;1 set vram start
		std	Y+lmo_rampos_l,XL	;2
		ldi	XL,HIGH(libmio_vram)	;1
		std	Y+lmo_rampos_h,XL	;2
		std	Y+lmo_cline,const_0	;2 store cline
		clr	vline_l			;line_l=0
		clr	vline_h			;line_h=0
		ldi	XL,0x0a			;editor head color
		std	Y+lmo_elcolor,XL
;increment counters
		ldi	XL,5			;1 fps/10 for pal
		sbrs	ZL,2			;1 pal/ntsc bit
		inc	XL			;1 fps/10 for ntsc
		ldi	tempreg1,50		;1 fps for pal
		sbrs	ZL,2			;1 pal/ntsc bit
		ldi	tempreg1,60		;1 fps for ntsc
		ldd	XH,Y+lmo_time0		;2 timer
		inc	XH
		cp	XH,XL			;1 frames (5/6)
		brne	libmio_is_06a
		clr	XH
		ldd	ZL,Y+lmo_time_l
		ldd	ZH,Y+lmo_time_h
		adiw	ZL,1
		std	Y+lmo_time_l,ZL
		std	Y+lmo_time_h,ZH		
libmio_is_06a:	std	Y+lmo_time0,XH		
		ldd	ZL,Y+lmo_frames		;2 get frame counter
		inc	ZL			;1 +1
		cp	ZL,tempreg1		;1 frames (50/60)
		brne	libmio_is_07		;2 frame oveflow
		clr	ZL			;1 set frames=0
libmio_is_07:	std	Y+lmo_frames,ZL		;2 set frames=0

;-------------------------------------------------------------------------------
; calculate envelope position
;-------------------------------------------------------------------------------		
		ldi	ZH,HIGH(libmio_etable*2);1 start envtable high
		ldi	ZL,LOW(libmio_etable*2)	;1 start envtable low
		ldd	XL,Y+lmo_env		;2 envelope pointer
		add	ZL,XL			;1 envelope-position
		adc	ZH,const_0		;1
		lpm	XH,Z			;get envelope value
		cp	XH,const_0		;must be zero to stop
		breq	libmio_is_11a		;the end is reached
		inc	XL			;+1
		std	Y+lmo_env,XL		;write back
libmio_is_11a:	std	Y+lmo_envv,XH		;write envelope value

;-------------------------------------------------------------------------------
; check sequencer
;-------------------------------------------------------------------------------		
libmio_is_seq:	lds	XL,libmio_seqspeed	;speed
		cpi	XL,0x00			;enabled?
		brne	libmio_is_seq1		;yes
libmio_is_seq0:	rjmp	libmio_is_15
libmio_is_seq1:	lds	XH,libmio_seqcount	;counter
		inc	XH
		sts	libmio_seqcount,XH
		cp	XH,XL
		brcs	libmio_is_seq0
		clr	XH
		sts	libmio_seqcount,XH
		lds	ZL,libmio_seql
		lds	ZH,libmio_seqh
		lds	YL,libmio_seqbl
		lds	YH,libmio_seqbh
		adiw	YL,1
		ld	XL,Z+
		sts	libmio_seql,ZL		;store back pointer
		sts	libmio_seqh,ZH
		cpi	XL,0xfe			;no tone
		breq	libmio_is_seq2
		rcall	libmio_note
libmio_is_seq2:	cp	ZH,YH			;compare hi
		brcs	libmio_is_seq7		;is less				
		cp	ZL,YL			;compare low
		brcs	libmio_is_seq7		;is less
		lds	XL,libmio_seqstat
		cpi	XL,0x01			;stop required
		brne	libmio_is_seq6		;no
		ldi	XL,0x02			;stop status
		sts	libmio_seqspeed,const_0	;stop sequencer
		sts	libmio_seqstat,XL	;write stop status
						
libmio_is_seq6:	lds	ZL,libmio_seqal		;get start pointer
		lds	ZH,libmio_seqah
		sts	libmio_seql,ZL		;store pointer
		sts	libmio_seqh,ZH
		
libmio_is_seq7:	rjmp	libmio_is_15

;-------------------------------------------------------------------------------
;sync to counter
;-------------------------------------------------------------------------------
libmio_iss:	lds	XL,TCNT1L		;1 get timer
		cpi	XL,libmio_hstart+70 	;1
		brcs	libmio_iss		;1 loop
libmio_iss_01:	cpi	XL,libmio_hstart+71	
		brcs	libmio_iss_02
libmio_iss_02:	cpi	XL,libmio_hstart+72	
		brcs	libmio_iss_03
libmio_iss_03:	cpi	XL,libmio_hstart+73	
		brcs	libmio_iss_03a
libmio_iss_03a:	cpi	XL,libmio_hstart+74	
		brcs	libmio_iss_04
		
libmio_iss_04:	sbrc	ZL,5			;1 fast flag
		rjmp	libmio_is_15		;2 no visible lines

		lds	ZL,libmio_config
		sbrc	ZL,7
		jmp	libmio_tvm		;editor mode
		lds	ZL,libmio_vidmode
		cpi	ZL,0x05			;mode 5
		brne	libmio_iss_08
		jmp	libmio_tvg1		;2 color graphics
libmio_iss_08:	andi	ZL,0x03			;only 4 modes
		brne	libmio_iss_05
		jmp	libmio_tvc		;standard mode
libmio_iss_05:	cpi	ZL,0x01			
		brne	libmio_iss_06		
		jmp	libmio_tvg2		;2 color graphics
libmio_iss_06:	cpi	ZL,0x02			
		brne	libmio_iss_07		
		jmp	libmio_tvg4		;4 color graphics
libmio_iss_07:	jmp	libmio_tvg8		;8 color graphics

libmio_is_15:
;------------------------------------------------------------------------------
;the keyboard routine
;09 no char from keyboard
;26 key, but released
;43 key, state 1
;------------------------------------------------------------------------------
libmio_kir:	lds	XL,libmio_kbdstate	;2
		sbrc	XL,5			;1 skip if not state2
		rjmp	libmio_kir_s2		;2 jump to next state
;+4		
		lds	ZL,UCSR0A		;2 status
		sbrs	ZL,RXC0			;1 RXC?
		rjmp	libmio_kir_end		;2 no byte available
		lds	ZL,UDR0			;2 get data
;		sts	debug_scode,ZL		;2 save scancode for debug only
;+10
		ldi	ZH,HIGH(libmio_kstab*2)	;1 set start of table
		lpm	XH,Z			;3 get config byte
;+14
		sbrs	XH,0			;1 skip if char
		rjmp	libmio_kir_nch		;2 no char
;+16
		sbrs	XL,7			;1 check release flag
		rjmp	libmio_kir_01		;2
		sts	libmio_keycode,const_0	;2 clear keycode
		rjmp	libmio_kir_enb		;2		
;+19
libmio_kir_01:	cpi	ZL,0x83			;1 change this one code
		brne	libmio_kir_02		;1 jump if not
		ldi	ZL,0x10			;1 replacement
;+22		
libmio_kir_02:	ldi	ZH,HIGH(libmio_ktables*2) ;1 start ext keytable
		lds	tempreg1,libmio_sysconf	;2 keytable offset
		sbrc	tempreg1,0		
		subi	ZH,0xfe			;1 +2 tab2

;+26		
;check for extended
		andi	ZL,0x7f			;1 clear bit 7 of low
		
		sbrs	XL,4			;1 skip if alt
		sbrc	XL,6			;1 skip if extended
		inc	ZH			;1 table 3 (extended)

		sbrs	XL,4			;1 alt
		sbrc	XL,0			;1 left shift
		ori	ZL,0x80			;1 part 2 of table
		sbrc	XL,1			;1 right shift
		ori	ZL,0x80			;1 part 2 of table
;+33
		lpm	ZL,Z			;3 get value
		sts	libmio_scancode,ZL	;2
		ori	XL,0x20			;1 set state 2
		rjmp	libmio_kir_enc		;2

;second cycle (+5)
libmio_kir_s2:	lds	ZL,libmio_scancode	;2 get code back
;+7
		sts	libmio_keycode,ZL	;store result
		sts	libmio_lastkey,ZL
		cpi	ZL,0xee			;1 alt+del
		brne	libmio_kir_03		;1/2
		sbrc	XL,2			;2 left control
		jmp	start			;4 restart

;+11
libmio_kir_03:	lds	tempreg1,libmio_kflags	;2 keyboard control
		cpi	ZL,'c'			;1 Break?
		brne	libmio_kir_04		;1/2
		sbrc	XL,2			;1 left control?
		ori	tempreg1,1		;1 set break bit

libmio_kir_04:	cpi	ZL,'p'			;Screenshot?
		brne	libmio_kir_05		;1/2
		sbrc	XL,3			;1 right control?
		ori	tempreg1,2		;set screenshot bit

libmio_kir_05:	cpi	ZL,0xfc			;monitor?
		brne	libmio_kir_06
		ori	tempreg1,4		;set monitor bit
libmio_kir_06:	sts	libmio_kflags,tempreg1	;save keyboard control
		rjmp	libmio_kir_enb		;end


;no char (+17)	
libmio_kir_nch:	cpi	ZL,0xf0	
		brne	libmio_kir_nc1
		ori	XL,0x80			;1 set release flag
		rjmp	libmio_kir_enc
;+20		
libmio_kir_nc1:	cpi	ZL,0xe0
		brne	libmio_kir_nc2
		ori	XL,0x40			;1 set extended flag
		rjmp	libmio_kir_enc		
;+23
libmio_kir_nc2:	cpi	ZL,0x12			;left shift
		brne	libmio_kir_nc3		;no
		sbrc	XL,6			;skip if not extended
		rjmp	libmio_kir_enb		;extended->ignore
		ori	XL,0x01			;set shift bit
		sbrc	XL,7			;skip if not release
		andi	XL,0xfe			;clear shift bit
		rjmp	libmio_kir_enb		;thats all
;+26		
libmio_kir_nc3:	cpi	ZL,0x59			;right shift
		brne	libmio_kir_nc4		;jump if not
		ori	XL,0x02			;set shift bit
		sbrc	XL,7			;skip if not release
		andi	XL,0xfd			;clear shift bit
		rjmp	libmio_kir_enb		;thats all
;+29
libmio_kir_nc4:	cpi	ZL,0x14			;control
		brne	libmio_kir_nc6		;jump if not
		sbrc	XL,6			;extended? (right ctrl key)
		rjmp	libmio_kir_nc5
		ori	XL,0x04			;set control bit
		sbrc	XL,7			;skip if not release
		andi	XL,0xfb			;clear ctrl bit
		rjmp	libmio_kir_enb		;thats all
libmio_kir_nc5:	ori	XL,0x08			;set control bit
		sbrc	XL,7			;skip if not release
		andi	XL,0xf7			;clear ctrl bit
		rjmp	libmio_kir_enb		;thats all
;+32		
libmio_kir_nc6:	cpi	ZL,0x11			;alternate
		brne	libmio_kir_nc7		;jump if not
		ori	XL,0x10			;set alt bit
		sbrc	XL,7			;skip if not release
		andi	XL,0xef			;clear alt bit
		rjmp	libmio_kir_enb		;thats all
		
libmio_kir_nc7:	sts	libmio_keycode,const_0	;clear keycode
		
libmio_kir_enb: andi	XL,0x1f			;1 clear ext and release bit
libmio_kir_enc:	sts	libmio_kbdstate,XL	;2 store keyboard status
libmio_kir_end:

;-------------------------------------------------------------------------------
;serial port select baud
;-------------------------------------------------------------------------------
		lds	tempreg1,libmio_sysconf	;baud sel
		sbrc	tempreg1,1		;skip if 1200
		call	libmio_bl_2rx
		sbrs	tempreg1,1		;skip if 2400
		call	libmio_bl_1rx
		
;-------------------------------------------------------------------------------
;restore registers and exit
;-------------------------------------------------------------------------------
libmio_is_20:	pop	ZH			;2 restore sreg
		out	SREG,ZH			;1 put back    
		pop	r1			;2 restore r1
		pop	r0			;2 restore r0
		pop	XL			;2 restore Y-register
		pop	XH			;2 restore Y-register
libmio_is_30:	pop	YL			;2 restore Y-register
		pop	YH			;2 restore Y-register
		pop	ZL			;2 restore Z-register
		pop	ZH			;2 restore Z-register
		pop	tempreg3		;
		pop	tempreg2		;2
		pop	tempreg1		;2 restore register
		reti				;4 thats all

;-------------------------------------------------------------------------------
;port konfiguration for port B ... D
;-------------------------------------------------------------------------------
libmio_init:	ldi	XL,0xba			;port direction (+SPI)
		out	DDRB,XL
		ldi	XL,0xff
		out	PORTB,XL	

		ldi	XL,0xe0			;port direction
		out	DDRC,XL
		ldi	XL,0x00
		out	PORTC,XL	

		ldi	XL,0xf0			;set pin 4-7 as output
		out	DDRD,XL
		ldi	XL,0xff
		out	PORTD,XL	

		in	XL,PINC			;get portc (bit 2-4 = config)
		andi	XL,0x7f			;clear editor mode bit
		sts	libmio_config,XL	;store configuration

		
;-------------------------------------------------------------------------------
;timer configuration
;-------------------------------------------------------------------------------
		ldi	XH,0xc2			;FAST-PWM-Mode 14 (PWM channel B)
		sts	TCCR1A,XH
		ldi	XH,0x19			;FAST-PWM-Mode (no prescaler)
		sts	TCCR1B,XH
		ldi	ZH,HIGH(libmio_counter_p-1)
		sbrs	XL,2			;1 pal/ntsc bit
		ldi	ZH,HIGH(libmio_counter_n-1)
		sts	ICR1H,ZH
		ldi	ZH,LOW(libmio_counter_p-1)
		sbrs	XL,2			;1 pal/ntsc bit
		ldi	ZH,LOW(libmio_counter_n-1)
		sts	ICR1L,ZH

		sts	OCR1AH,const_0		;we use only 8 bits
		ldi	ZH,libmio_hslen	;1 hsync length pal
		sts	OCR1AL,ZH		

		ldi	ZH,HIGH(libmio_bend)	;border end Interrupt
		sts	OCR1BH,ZH		
		ldi	ZH,LOW(libmio_bend)	;1 hor position pal
		sts	OCR1BL,ZH		
				
		ldi	XL,0x06
		sts	TIMSK1,XL		;enable compare OC1A/OC1B int

		ldi	XL,0x02			;ctc but disable output
		out	TCCR0A,XL
		ldi	XL,0x01
		out	TCCR0B,XL
		ldi	XL,49			;ca. 200KHz
		out	OCR0A,XL			

		ldi	XL,0x83			;timer 2 config
		sts	TCCR2A,XL
		ldi	XL,0x01			;timer 2 config
		sts	TCCR2B,XL
		ldi	XL,0x80			;zero signal
		sts	OCR2A,XL
		sts	ASSR,const_0

;-------------------------------------------------------------------------------
;usart configuration (synchronous for keyboard)
;-------------------------------------------------------------------------------
		sts	UCSR0A,const_0
		ldi	XL,0x10
		sts	UCSR0B,XL
		ldi	XL,0x66
		sts	UCSR0C,XL

;-------------------------------------------------------------------------------
;spi configuration (mode 3 master 5MHz/156kHz)
;-------------------------------------------------------------------------------
		ldi	XL,0x5c		;f/4
		lds	XH,libmio_sysconf
		sbrc	XH,3
		ldi	XL,0x5f		;f/128
		out	SPCR0,XL
		ldi	XL,0x00
		out	SPSR0,XL

;-------------------------------------------------------------------------------
;clear video-RAM and set pointers
;-------------------------------------------------------------------------------
		ldi	XL,0x15			;color = white
		rcall	libmio_setcol		;set color
		ldi	YL,LOW(libmio_ram)
		ldi	YH,HIGH(libmio_ram)
		ldi	XL,LOW(libmio_vram)	;2
		st	Y+,XL			;2 start vram
		ldi	XL,HIGH(libmio_vram)	;2
		st	Y+,XL			;2 start vram
		ldi	XL,0x1e
libmio_init_c:	st	Y+,const_0
	    	dec	XL
		brne	libmio_init_c	
		ldi	XL,0xaa	    
		sts	libmio_rand1,XL
		sts	libmio_rand3,XL
		sts	libmio_channel,const_0	;set output to screen
		sts	libmio_font,const_0	;set output to screen
		ldi	XL,0x3e
		sts	libmio_env,XL		;sound off
		
;------------------------------------------------------------------------------
; set display to normal mode
;------------------------------------------------------------------------------
libmio_nmode:	push	r16
		lds	r16,libmio_config
		andi	r16,0x7f	
		sts	libmio_config,r16
		ldi	r16,230
		rjmp	libmio_emodes

;------------------------------------------------------------------------------
; set display to editor mode
;------------------------------------------------------------------------------
libmio_emode:	push	r16
		lds	r16,libmio_config
		ori	r16,0x80    	
		sts	libmio_config,r16
		ldi	r16,228
libmio_emodes:	sts	libmio_vislines,r16		
		pop	r16
		ret		

;------------------------------------------------------------------------------
; set video mode
;------------------------------------------------------------------------------
libmio_svmode:	sts	libmio_vidmode,XL	;set videomode
		cpi	XL,0x00
		brne	libmio_vmode1
		ldi	XL,libmio_v0cols
		sts	libmio_clipx2,XL
		ldi	XL,libmio_v0rows
		sts	libmio_clipy2,XL
		ldi	XL,230
		rjmp	libmio_vmodes
				
libmio_vmode1:	cpi	XL,0x01
		brne	libmio_vmode2
		ldi	XL,libmio_v1cols
		sts	libmio_clipx2,XL
		ldi	XL,libmio_v1rows
		sts	libmio_clipy2,XL
		ldi	XL,0x00			;black
		sts	libmio_palette,XL		;palette 0
		ldi	XL,0xe0			;white
		sts	libmio_palette+1,XL		;palette 1
		rjmp	libmio_vmode13
				
libmio_vmode2:	cpi	XL,0x02
		brne	libmio_vmode3
		ldi	XL,libmio_v2cols
		sts	libmio_clipx2,XL
		ldi	XL,libmio_v2rows
		sts	libmio_clipy2,XL
		ldi	YL,0x00
		ldi	YH,0x01
		ldi	XL,0x00			;black
		st	Y+,XL			;palette 0
		ldi	XL,0x40			;red
		st	Y+,XL			;palette 1
		ldi	XL,0xa0			;cyan
		st	Y+,XL			;palette 2
		ldi	XL,0xe0			;white
		st	Y+,XL			;palette 3
		ldi	XL,227
		rjmp	libmio_vmodes		
				
libmio_vmode3:	cpi	XL,0x03
		brne	libmio_vmode5
		ldi	XL,libmio_v3cols
		sts	libmio_clipx2,XL
		ldi	XL,libmio_v3rows
		sts	libmio_clipy2,XL
		ldi	YL,0x00
		ldi	YH,0x01
		clr	XL
		ldi	XH,0x08
libmio_vmode3a:	st	Y+,XL
		subi	XL,0xe0
		dec	XH
		brne	libmio_vmode3a
libmio_vmode13:	ldi	XL,231
		rjmp	libmio_vmodes	
		
libmio_vmode5:	ldi	XL,libmio_v5cols
		sts	libmio_clipx2,XL
		ldi	XL,libmio_v5rows
		sts	libmio_clipy2,XL
		ldi	XL,0x20				;blue
		sts	libmio_palette,XL		;palette 0
		ldi	XL,0xe0				;white
		sts	libmio_palette+1,XL		;palette 1
		ldi	XL,192				

libmio_vmodes:	sts	libmio_vislines,XL
		ret    
		
;------------------------------------------------------------------------------
; set color to XL
;------------------------------------------------------------------------------
libmio_setcol:	lsl	XL
		andi	XL,0xee
		sts	libmio_color,XL
		ret		

;------------------------------------------------------------------------------
; set border to XL
;------------------------------------------------------------------------------
libmio_setbrd:	swap	XL
		lsl	XL
		andi	XL,0xe0
		sts	libmio_border,XL
		ret				
;------------------------------------------------------------------------------
; write char tempreg1 to Y
;------------------------------------------------------------------------------
libmio_wchar:	st	Y,tempreg1
		lds	tempreg1,libmio_config
		sbrc	tempreg1,7
		rjmp	libmio_wchar1
		push	YL
		push	YH
		push	tempreg2
		ldi	tempreg1,LOW(libmio_cols*libmio_rows)
		add	YL,tempreg1
		ldi	tempreg1,HIGH(libmio_cols*libmio_rows)
		adc	YH,tempreg1		
		lds	tempreg1,libmio_color
		andi	tempreg1,0xee
		st	Y,tempreg1
		pop	tempreg2
		pop	YH
		pop	YL
libmio_wchar1:	ret

;-------------------------------------------------------------------------------
; Bin16 -> ASCII (dez)
; XL,XH 	= number
; ctrl		= format
; 	Bit 0,1	 = format	00 = compact
;				01 = leading spaces
;				10 = leading zeroes 0...65536
;				11 = leading zeroes with +- sign  
;			
;	Bit 2,3	 = number of visible digits (2,3,4,5)
;	Bit 4,5	 = comma position (no  xxxx,x   xxx,xx  xx,xxx) 
;	Bit 6	1= big size (only in monochrome mode) 
;-------------------------------------------------------------------------------
.ifdef use_libmio_outd
libmio_outd:	push	tempreg1		;save registers
		push	tempreg2
		push	tempreg3
		push	XL
		push	XH
		ldi	tempreg1,0x20		;space
		mov	tempreg2,ctrl
		andi	tempreg2,0x03
		cpi	tempreg2,0x02		;leading zeroes without sign
		breq	libmio_outd_03
		cpi	tempreg2,0x03		;leading zeroes with +- sign
		brne	libmio_outd_01
		ldi	tempreg1,'+'		;set positive sign
libmio_outd_01:	sbrs	XH,7
		rjmp	libmio_outd_02
		com	XL			;X=-X
		com	XH			;
		add	XL,const_1		;
		adc	XH,const_0		;
		ldi	tempreg1,'-'		;sign is negative
libmio_outd_02:	call	libmio_char		;out sign


libmio_outd_03:	mov	tempreg2,ctrl		;format byte
		andi	tempreg2,0x0c		;mask number of digits
		mov	tempreg3,ctrl		;format byte
		andi	tempreg3,0x30		;mask comma position
		clt				;clear nonzero-flag
		ldi	tempreg1,47		;"0"-1 	
libmio_outd_04:	inc	tempreg1			;
		subi	XL,16			;-10000
		sbci	XH,39
		brcc	libmio_outd_04		;no overflow
		subi	XL,240			;+10000
		sbci	XH,216			;
		cpi	tempreg2,0x0c		;5 digits?
		brne	libmio_outd_05		;no		
		rcall	libmio_nc		;out digit 10^4

libmio_outd_05:	ldi	tempreg1,47		;"0"-1 	
libmio_outd_06:	inc	tempreg1			;
		subi	XL,232			;-1000
		sbci	XH,3			;
		brcc	libmio_outd_06		;no overflow
		subi	XL,24			;+1000
		sbci	XH,252			;
		sbrc	tempreg2,3		;skip if < 4 digits
		rcall	libmio_nc		;out digit 10^3
		cpi	tempreg3,0x30		;comma?
		brne	libmio_outd_07		;no
		rcall	libmio_comma		;

libmio_outd_07:	ldi	tempreg1,47		;"0"-1 	
libmio_outd_08:	inc	tempreg1		;+1
		subi	XL,100			;-100
		sbc	XH,const_0		;
		brcc	libmio_outd_08		;no overflow
		subi	XL,156			;+100
		sbci	XH,255			;
		cpi	tempreg2,0x00		;3 digits
		breq	libmio_outd_09
		rcall	libmio_nc		;out digit 10^2
libmio_outd_09:	cpi	tempreg3,0x20		;comma?
		brne	libmio_outd_10		;no
		rcall	libmio_comma		;

libmio_outd_10:	ldi	tempreg1,47		;"0"-1 	
libmio_outd_11:	inc	tempreg1		;+1
		subi	XL,10			;-10
		brcc	libmio_outd_11		;no overflow
		rcall	libmio_nc		;out digit 10^1
		subi	XL,246			;+10
		cpi	tempreg3,0x10		;comma?
		brne	libmio_outd_12		;no
		rcall	libmio_comma		;
		
libmio_outd_12:	ldi	tempreg1,48		;"0"
		add	tempreg1,XL		;LSB digit
		rcall	libmio_char
		pop	XH
		pop	XL
		pop	tempreg3
		pop	tempreg2
		pop	tempreg1
		ret

;-------------------------------------------------------------------------------
; out numeric char (tempreg1)
;-------------------------------------------------------------------------------
libmio_nc:	cpi	tempreg1,48		;is zero
		breq	libmio_nc_1		;yes
		set				;set flag
		rjmp	libmio_char		;send char
		
libmio_nc_1:	sbrc	ctrl,1			;skip if no leading zeroes
libmio_nc_2:	rjmp	libmio_char		;send zero
		brts	libmio_nc_2		;flag is set
		
		sbrs	ctrl,0			;skip if no leading spaces
		ret 
		rjmp	libmio_space		;send space
		ret
.endif

;-------------------------------------------------------------------------------
; Bin -> ASCII (hex) 
; (XL,XH) = number
; ctrl 		= format
; 	Bit 0	1= 16Bit (4 chars)
;	Bit 6	1= Big size
;-------------------------------------------------------------------------------
.ifdef use_libmio_outh
libmio_outh:	push	tempreg1		;save temp register
		sbrs	ctrl,0
		rjmp	libmio_outh1		;only 8
		mov	tempreg1,XH		;
		swap	tempreg1		;high-nibble
		rcall	libmio_oh
		mov	tempreg1,XH		;
		rcall	libmio_oh
libmio_outh1:	mov	tempreg1,XL		;
		swap	tempreg1		;high-nibble
		rcall	libmio_oh
		mov	tempreg1,XL		;
		rcall	libmio_oh
		pop	tempreg1		;restore temp register
		ret

;-------------------------------------------------------------------------------
; out hexadecimal char (tempreg1)
;-------------------------------------------------------------------------------
libmio_oh:	andi	tempreg1,0x0f		;mask nibble
		subi	tempreg1,0xd0		;+30
		cpi	tempreg1,0x3a		;>9
		brcs	libmio_oh_1		;jump, if not
		subi	tempreg1,0xf9		;+6
libmio_oh_1:	rjmp	libmio_char		
.endif
		
;-------------------------------------------------------------------------------
; clear video-RAM
;-------------------------------------------------------------------------------
libmio_clr:	lds	tempreg1,libmio_vidmode	;video mode
		cpi	tempreg1,0x00		;standard?
		breq	libmio_fill		;yes
		push	XL
		push	XH
		push	YL
		push	YH
		ldi	YH,HIGH(libmio_vram)	;home position
		ldi	YL,LOW(libmio_vram)	;home position
		ldi	XL,libmio_rows*4
libmio_cls_g01:	ldi	XH,libmio_cols
libmio_cls_g02:	st	Y+,const_0		;write to RAM
		dec	XH			;decrement counter
		brne	libmio_cls_g02		;loop
		dec	XL			;decrement counter
		brne	libmio_cls_g01		;loop
		pop	YH
		pop	YL
		clr	libmio_cur_x		;set X-position
		clr	libmio_cur_y		;set Y-position
		sts	libmio_lpos,const_0
		pop	XH
		pop	XL
		ret
		

libmio_fill:	push	XL
		push	XH
		push	YL
		push	YH		
		ldi	YH,HIGH(libmio_vram)	;home position
		ldi	YL,LOW(libmio_vram)	;home position
		ldi	XL,libmio_rows
libmio_cls_01:	ldi	XH,libmio_cols
libmio_cls_02:	st	Y+,tempreg1		;write to RAM
		dec	XH			;decrement counter
		brne	libmio_cls_02		;loop
		dec	XL			;decrement counter
		brne	libmio_cls_01		;loop
		lds	tempreg1,libmio_color
		andi	tempreg1,0xee
		ldi	XL,libmio_rows
libmio_cls_05:	ldi	XH,libmio_cols
libmio_cls_06:	st	Y+,tempreg1		;write to RAM
		dec	XH			;decrement counter
		brne	libmio_cls_06		;loop
		dec	XL			;decrement counter
		brne	libmio_cls_05		;loop
		pop	YH
		pop	YL
libmio_cls_03:	clr	libmio_cur_x		;set X-position
		clr	libmio_cur_y		;set Y-position
libmio_cls_04:	sts	libmio_lpos,const_0
		pop	XH
		pop	XL
		ret				;the end

;-------------------------------------------------------------------------------
; newline and calculate new position
;-------------------------------------------------------------------------------
.ifdef use_libmio_newline
libmio_newline:	push	XL
		push	XH
		sts	libmio_lpos,const_0
		lds	XL,libmio_channel
		cpi	XL,0			;screen
		brne	libmio_newl1
		ldi	XL,libmio_rows
		clr	libmio_cur_x		;begin of line
		inc	libmio_cur_y		;next line
		cp	XL,libmio_cur_y		;beyond screen
		brne	libmio_cls_04
		ldi	XH,(libmio_rows-1)	;last line
		mov	libmio_cur_y,XH
		push	YL
		push	YH
		rjmp	libmio_char_04		;scroll screen

libmio_newl1:	cpi	XL,1			;serial
		brne	libmio_newl2
		pop	XH
		pop	XL
		ldi	tempreg1,0x0a		;newline
		jmp	libmio_pser		;write serial
		
libmio_newl2:	cpi	XL,2			;parallel
		brne	libmio_newl3
		pop	XH
		pop	XL
		ldi	tempreg1,0x0a		;newline
		rjmp	libmio_ppar		;write parallel
		
libmio_newl3:	cpi	XL,3			;array
		brne	libmio_newl4
		pop	XH
		pop	XL
		ret

libmio_newl4:	pop	XH			;i2c
		pop	XL
		ldi	tempreg2,0x0a
		libi2c_wbyte
		ret
.endif

;-------------------------------------------------------------------------------
; output character and calculate new position (tempreg1=char)
;-------------------------------------------------------------------------------
libmio_comma:	ldi	tempreg1,0x2c		;set char to comma
		rjmp	libmio_char		;write
libmio_space:	ldi	tempreg1,32		;set char to space
libmio_char:	push	XL
		push	XH
		lds	XL,libmio_lpos
		inc	XL
		sts	libmio_lpos,XL
		lds	XL,libmio_channel
		cpi	XL,4
		brcs	libmio_chr_1
		pop	XH
		pop	XL
		mov	tempreg2,tempreg1	;copy char
		libi2c_wbyte			;output to i2c
		ret
		
libmio_chr_1:	cpi	XL,0			;screen
		breq	libmio_char2
		cpi	XL,3			;array
		brne	libmio_char0
		mov	XL,tempreg1
		clr	XH
		push	tempreg2
		push	tempreg3
		call	bas_warr		;write to array
		pop	tempreg3
		pop	tempreg2
		pop	XH
		pop	XL
		ret	
		
libmio_char0:	pop	XH
		pop	XL
		lds	XL,libmio_channel
		sbrs	XL,1			;serial
		jmp	libmio_pser		;write serial
libmio_char1:	rjmp	libmio_ppar		;write parallel

libmio_char2:	push	ZL			;save
		lds	ZL,libmio_vidmode	;get video mode
		cpi	ZL,0x00
		breq	libmio_char_0
		rjmp	libmio_gchar		;graphics mode
		
libmio_char_0:	pop	ZL
		push	YL
		push	YH
		rcall	libmio_calc		;calculate address		
		sbrc	ctrl,6			;big chars
		rjmp	libmio_bchar

		rcall	libmio_wchar		;write char
		inc	XL			;next position
		cpi	XL,libmio_cols		;beyond the end of line
		brne	libmio_char_01
		clr	XL			;begin of line
		inc	XH			;of next line
		cpi	XH,libmio_rows		;beyond screen
		brne	libmio_char_01
		ldi	XH,libmio_rows-1	;last line
		rjmp	libmio_char_03		;we must scroll			
libmio_char_01:	mov	libmio_cur_x,XL		;X
		mov	libmio_cur_y,XH		;Y
libmio_char_02:	pop	YH
		pop	YL
		pop	XH
		pop	XL
		ret

; scroll screen
libmio_char_03:	mov	libmio_cur_x,XL		;save X-position
		mov	libmio_cur_y,XH		;save Y-position
libmio_char_04:	ldi	YH,HIGH(libmio_vram)	;home position
		ldi	YL,LOW(libmio_vram)	;home position
		push	tempreg1
		ldi	XL,libmio_rows-1	;lines -1
libmio_char_05:	ldi	XH,libmio_cols		
libmio_char_06:	ldd	tempreg1,Y+libmio_cols
		st	Y+,tempreg1
		dec	XH
		brne	libmio_char_06
		dec	XL
		brne	libmio_char_05		
		ldi	XL,libmio_cols
		ldi	tempreg1,32		;space
libmio_char_07:	st	Y+,tempreg1
		dec	XL
		brne	libmio_char_07

libmio_char_14:	ldi	YH,HIGH(libmio_vram+libmio_cols*libmio_rows)	;attr start
		ldi	YL,LOW(libmio_vram+libmio_cols*libmio_rows)	;attr start

		ldi	XL,libmio_rows-1	;lines -1
libmio_char_15:	ldi	XH,libmio_cols		
libmio_char_16:	ldd	tempreg1,Y+libmio_cols
		st	Y+,tempreg1
		dec	XH
		brne	libmio_char_16
		dec	XL
		brne	libmio_char_15		
		ldi	XL,libmio_cols
		lds	tempreg1,libmio_color	;space
libmio_char_17:	st	Y+,tempreg1
		dec	XL
		brne	libmio_char_17
		pop	tempreg1
		rjmp	libmio_char_02


libmio_bchar:	cpi	XL,libmio_cols-3
		brcc	libmio_char_02
		cpi	XH,libmio_rows-5
		brcc	libmio_char_02
		subi	XL,0xfd			;X+3
		mov	libmio_cur_x,XL		;store new X
		push	ZL
		push	ZH
		push	tempreg5		;byte 1
		push	tempreg6		;byte 2
		push 	tempreg7		;byte 3
		push	tempreg8		;for stroring T-bit
		bld	tempreg8,0		;store T
		push	tempreg2		;temp value

libmio_bchar_0:	mov	ZL,tempreg1		;char
		ldi	ZH,HIGH(libmio_ctable*2)	;start char ROM
		ldi	XH,5			;10 char lines
		
libmio_bchar_1:	clr	tempreg5		;clear columns
		clr	tempreg6
		clr	tempreg7
		clr	tempreg2		;clear temp value
		
		lpm	XL,Z			;get pixel line
		sbrc	XL,7			;pixel 0
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg5,0
		sbrc	XL,6			
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg5,1
		sbrc	XL,5			
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg6,0
		sbrc	XL,4			
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg6,1
		sbrc	XL,3			
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg7,0
		sbrc	XL,2			
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg7,1

		inc	ZH			;next line
		clr	tempreg2		;clear temp value
		
		lpm	XL,Z			;get pixel line
		sbrc	XL,7			;pixel 0
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg5,2
		sbrc	XL,6			
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg5,3
		sbrc	XL,5			
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg6,2
		sbrc	XL,4			
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg6,3
		sbrc	XL,3			
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg7,2
		sbrc	XL,2			
		inc	tempreg2
		bst	tempreg2,0		;copy pix
		bld	tempreg7,3

libmio_bchar_d:	inc	ZH
		mov	tempreg1,tempreg5	;char1
		rcall	libmio_wchar
		adiw	YL,0x01
		mov	tempreg1,tempreg6	;char2
		rcall	libmio_wchar
		adiw	YL,0x01
		mov	tempreg1,tempreg7	;char3
		rcall	libmio_wchar
		adiw	YL,libmio_cols-2	;next line
		dec	XH
		breq	libmio_bchar_e
		rjmp	libmio_bchar_1
		
libmio_bchar_e:	pop	tempreg2
		bst	tempreg8,0		;restore T
		pop	tempreg8
		pop	tempreg7
		pop	tempreg6
		pop	tempreg5
		pop	ZH
		pop	ZL
		rjmp	libmio_char_02

;graphics mode
libmio_gchar:	push	ZH			;restore Z reg
		push	YL
		push	YH
		push	tempreg3
		push	tempreg4
		mov	ZL,tempreg1		;char
		lds	tempreg3,libmio_font	;get font
		sbrc	tempreg3,0		;skip if font 0
		rjmp	libmio_gchar5		;jump to fnt1 routine
		
		ldi	ZH,HIGH(libmio_ctable*2)	;start char ROM
		mov	XL,libmio_cur_x		;get X-position
		mov	XH,libmio_cur_y		;get Y-position
		ldi	YH,10			;number of lines
		
libmio_gchar1:	lpm	YL,Z			;get pixline
		rcall	libmio_plpl
		inc	XH
		mov	XL,libmio_cur_x		;get X-position
		sbrc	ctrl,6			;bigchars
		rcall	libmio_plpl
		sbrc	ctrl,6			;bigchars
		inc	XH
		inc	ZH			;next pixline
		mov	XL,libmio_cur_x		;get X-position
		dec	YH
		brne	libmio_gchar1		
		mov	XL,libmio_cur_x		;get X-position
		subi	XL,0xfa			;+6
		sbrc	ctrl,6
		subi	XL,0xfa			;+6
		mov	libmio_cur_x,XL	
libmio_gchar4:	pop	tempreg4	
		pop	tempreg3
		pop	YH
		pop	YL
		pop	ZH		
		pop	ZL
		pop	XH
		pop	XL
		ret

libmio_gchar5:	ldi	ZH,HIGH(libmio_ctable1*2)	;start char ROM
		andi	ZL,0x7f
		mov	XL,ZL
		ldi	ZL,LOW(libmio_ctable1*2)	;start char ROM
		add	ZL,XL
		adc	ZH,const_0				
		lsl	XL
		add	ZL,XL
		adc	ZH,const_0
		
		mov	XL,libmio_cur_x		;get X-position
		mov	XH,libmio_cur_y		;get Y-position
		ldi	YH,6			;number of lines
		
libmio_gchar6:	lpm	YL,Z			;get pixline
		rcall	libmio_plpl5		
		inc	XH
		mov	XL,libmio_cur_x		;get X-position
		sbrc	ctrl,6			;bigchars
		rcall	libmio_plpl5
		sbrc	ctrl,6			;bigchars
		inc	XH
		sbrc	YH,0			;skip if first nibble is used
		adiw	ZL,1
		mov	XL,libmio_cur_x		;get X-position
		dec	YH
		brne	libmio_gchar6		
		mov	XL,libmio_cur_x		;get X-position
		subi	XL,0xfc			;+4
		sbrc	ctrl,6
		subi	XL,0xfc			;+4
		mov	libmio_cur_x,XL	
		rjmp	libmio_gchar4

;-------------------------------------------------------------------------------
; plot pixline in graphics mode with font 0, YL=pixline
;-------------------------------------------------------------------------------
libmio_plpl:	lds	tempreg3,libmio_color
		push	tempreg3
		swap	tempreg3
		sbrc	YL,7			;pix 1
		swap	tempreg3		
		sts	libmio_color,tempreg3
		rcall	libmio_plot		;output pix
		inc	XL			;next pos
		sbrc	ctrl,6			;no bigchar
		rcall	libmio_plot		;output pix again
		sbrc	ctrl,6			;no bigchar
		inc	XL			;next pos
		
		sbrc	YL,6			;pix 2
		swap	tempreg3		
		sts	libmio_color,tempreg3
		rcall	libmio_plot		;output pix
		inc	XL			;next pos
		sbrc	ctrl,6			;no bigchar
		rcall	libmio_plot		;output pix again
		sbrc	ctrl,6			;no bigchar
		inc	XL			;next pos

		sbrc	YL,5			;pix 3
		swap	tempreg3		
		sts	libmio_color,tempreg3
		rcall	libmio_plot		;output pix
		inc	XL			;next pos
		sbrc	ctrl,6			;no bigchar
		rcall	libmio_plot		;output pix again
		sbrc	ctrl,6			;no bigchar
		inc	XL			;next pos

		sbrc	YL,4			;pix 4
		swap	tempreg3		
		sts	libmio_color,tempreg3
		rcall	libmio_plot		;output pix
		inc	XL			;next pos
		sbrc	ctrl,6			;no bigchar
		rcall	libmio_plot		;output pix again
		sbrc	ctrl,6			;no bigchar
		inc	XL			;next pos

		sbrc	YL,3			;pix 5
		swap	tempreg3		
		sts	libmio_color,tempreg3
		rcall	libmio_plot		;output pix
		inc	XL			;next pos
		sbrc	ctrl,6			;no bigchar
		rcall	libmio_plot		;output pix again
		sbrc	ctrl,6			;no bigchar
		inc	XL			;next pos

		sbrc	YL,2			;pix 6
		swap	tempreg3		
		sts	libmio_color,tempreg3
		rcall	libmio_plot		;output pix
		inc	XL			;next pos
		sbrc	ctrl,6			;no bigchar
		rcall	libmio_plot		;output pix again
		sbrc	ctrl,6			;no bigchar
		inc	XL			;next pos

libmio_plpl1:	pop	tempreg3		;restore color
		sts	libmio_color,tempreg3
		ret

;-------------------------------------------------------------------------------
; plot pixline in graphics mode with font 1, YL=pixline
;-------------------------------------------------------------------------------
libmio_plpl5:	lds	tempreg3,libmio_color
		sbrc	YH,0
		swap	YL
		mov	tempreg4,tempreg3
		sbrs	YL,7			;pix 1
		swap	tempreg4		
		sts	libmio_color,tempreg4
		rcall	libmio_plot		;output pix
		inc	XL			;next pos
		sbrc	ctrl,6			;no bigchar
		rcall	libmio_plot		;output pix again
		sbrc	ctrl,6			;no bigchar
		inc	XL			;next pos
		
		mov	tempreg4,tempreg3
		sbrs	YL,6			;pix 2
		swap	tempreg4		
		sts	libmio_color,tempreg4
		rcall	libmio_plot		;output pix
		inc	XL			;next pos
		sbrc	ctrl,6			;no bigchar
		rcall	libmio_plot		;output pix again
		sbrc	ctrl,6			;no bigchar
		inc	XL			;next pos

		mov	tempreg4,tempreg3
		sbrs	YL,5			;pix 3
		swap	tempreg4		
		sts	libmio_color,tempreg4
		rcall	libmio_plot		;output pix
		inc	XL			;next pos
		sbrc	ctrl,6			;no bigchar
		rcall	libmio_plot		;output pix again
		sbrc	ctrl,6			;no bigchar
		inc	XL			;next pos

		mov	tempreg4,tempreg3
		sbrs	YL,4			;pix 4
		swap	tempreg4		
		sts	libmio_color,tempreg4
		rcall	libmio_plot		;output pix
		inc	XL			;next pos
		sbrc	ctrl,6			;no bigchar
		rcall	libmio_plot		;output pix again
		sbrc	ctrl,6			;no bigchar
		inc	XL			;next pos

libmio_plpl6:	sts	libmio_color,tempreg3
		ret
			
;-------------------------------------------------------------------------------
; output text from ROM (Z=text,nullterminated)
;-------------------------------------------------------------------------------
.ifdef use_libmio_orom
libmio_orom:	push	tempreg1	
libmio_orom_1:	lpm	tempreg1,Z+		;get char
		cpi	tempreg1,0		;end?
		brne	libmio_orom_2		;no
		pop	tempreg1
		ret				;the end
libmio_orom_2:	rcall	libmio_char		;write char to screen
		rjmp	libmio_orom_1		;next char	
.endif

;-------------------------------------------------------------------------------
; output text from ROM (following y,x,nullterminated text)
;-------------------------------------------------------------------------------
.ifdef use_libmio_othis
libmio_othis:	pop	ZH			;get return address
		pop	ZL
		lsl	ZL			;*2 so we use bytes
		rol	ZH
		push	XL
		push	XH
		lpm	XH,Z+			;get first value (255/Y)
		cpi	XH,0xff			;no position
		breq	libmio_othis_0
		lpm	XL,Z+			;get second value
		rcall	libmio_gxy		;set position
libmio_othis_0:	pop	XH
		pop	XL
		push	tempreg1		;save reg
libmio_othis_1:	lpm	tempreg1,Z+		;get char
		cpi	tempreg1,0		;end?
		brne	libmio_othis_2		;no
		pop	tempreg1		;restore reg
		sbiw	ZL,1			;point to zero
		lsr	ZH			;/2
		ror	ZL
		adiw	ZL,1			;point to next instruction
		ijmp
libmio_othis_2:	rcall	libmio_char		;write char to screen
		rjmp	libmio_othis_1		;next char	
.endif

;-------------------------------------------------------------------------------
; output text from RAM (Z=text,nullterminated)
;-------------------------------------------------------------------------------
.ifdef use_libmio_oram
libmio_oram:	push	tempreg1
libmio_oram_1:	ld	tempreg1,Z+		;get char
		cpi	tempreg1,0		;end?
		brne	libmio_oram_2		;no
		pop	tempreg1
		ret				;the end
libmio_oram_2:	call	libmio_char		;write char to screen
		rjmp	libmio_oram_1		;next char	
.endif

;-------------------------------------------------------------------------------
; output text (multiple char) ZL=number
;-------------------------------------------------------------------------------
.ifdef use_libmio_mtext
libmio_mtext:	call	libmio_char		;write char to screen
		dec	ZL
		brne	libmio_mtext	
		ret
.endif

;-------------------------------------------------------------------------------
; set cursor to position XL:XH
;-------------------------------------------------------------------------------
.ifdef use_libmio_gotoxy
libmio_gxy:	push	ZL
		lds	ZL,libmio_vidmode
		cpi	ZL,0x00
		breq	libmio_gxy_00
		pop	ZL
		mov	libmio_cur_x,XL		;save X-position
		mov	libmio_cur_y,XH		;save Y-position
		ret

libmio_gxy_00:	pop	ZL		
		cpi	XL,libmio_cols
		brcs	libmio_gxy_01
		ldi	XL,libmio_cols-1
libmio_gxy_01:	cpi	XH,libmio_rows
		brcs	libmio_gxy_02
		ldi	XH,libmio_rows-1
libmio_gxy_02:	mov	libmio_cur_x,XL		;save X-position
		mov	libmio_cur_y,XH		;save Y-position
		ret
.endif

;-------------------------------------------------------------------------------
; plot  XL=X XH=Y  
;-------------------------------------------------------------------------------
.ifdef use_libmio_plot
libmio_plot:	push	YL
		push	YH
		lds	YL,libmio_clipx2	;right limit
		cp	YL,XL			;greater?
		brcs	libmio_nplot		;yes
		lds	YL,libmio_clipy2	;right limit
		cp	YL,XH			;greater?
		brcs	libmio_nplot		;yes
		rjmp	libmio_plot0		;OK, we can plot
libmio_nplot:	pop	YH			;restore registers
		pop	YL
		ret		
		
libmio_plot0:	push	XL			;save coords
		push	XH
		push	tempreg1
		push	tempreg2
		lds	YL,libmio_vidmode
		cpi	YL,0x05
		breq	libmio_plot05
		andi	YL,0x03
		breq	libmio_plot_0
		cpi	YL,0x02
		brcc	libmio_plot1
libmio_plot05:	rjmp	libmio_plot1_0
libmio_plot1:	brne	libmio_plot2
		rjmp	libmio_plot2_0
libmio_plot2:	rjmp	libmio_plot3_0				
	
libmio_plot_0:	ldi	tempreg2,1		;bit left top

		cpi	XL,libmio_cols*2	;limit X-coord
		brcc	libmio_plot_os
		cpi	XH,libmio_rows*2	;limit Y-coord
		brcc	libmio_plot_os

		sbrc	XH,0
		lsl	tempreg2
		sbrc	XH,0
		lsl	tempreg2
		sbrc	XL,0
		lsl	tempreg2		;tempreg2 = bitmask
		lsr	XH			;Y/2
		lsr	XL			;X/2
		ldi	YL,libmio_cols
		mul	XH,YL
		ldi	YH,HIGH(libmio_vram)	;home position
		ldi	YL,LOW(libmio_vram)	;home position
		add	YL,XL
		adc	YH,const_0
		add	YL,r0
		adc	YH,r1
		ldi	XL,LOW(libmio_cols*libmio_rows)
		ldi	XH,HIGH(libmio_cols*libmio_rows)
		add	YL,XL			;calc attr pointer
		adc	YH,XH
		ld	XL,Y			;attr at position
		lds	XH,libmio_color		;plot color
		andi	XH,0x0e			;only background is needed
		swap	XH			;swap f/b
		andi	XL,0xe0			;only background is needed
		cp	XH,XL			;background = plot color?
		breq	libmio_plot_r		;pixel must be only deleted

		lds	XH,libmio_color		;plot color
		andi	XH,0x0e			;only foreground
		or	XL,XH			;set new fg
		andi	XL,0xee			;font 0
		st	Y,XL			;write back attribute
		
libmio_plot_s:	ldi	XL,LOW(libmio_cols*libmio_rows)
		ldi	XH,HIGH(libmio_cols*libmio_rows)
		sub	YL,XL			;recalc char pointer
		sbc	YH,XH
		ld	XH,Y			;get char
		or	XH,tempreg2		;set pix
libmio_plot_e:	andi	XH,0x0f			;mask bits
		st	Y,XH				
libmio_plot_os:	pop	tempreg2		
		pop	tempreg1
		pop	XH
		pop	XL
		pop	YH
		pop	YL
		ret
	
libmio_plot_r:	ldi	XL,LOW(libmio_cols*libmio_rows)
		ldi	XH,HIGH(libmio_cols*libmio_rows)
		sub	YL,XL			;recalc char pointer
		sbc	YH,XH
		ld	XH,Y			;get char
		com	tempreg2
		and	XH,tempreg2		;clear pix
		rjmp	libmio_plot_e

libmio_plot1_0:	mov	YL,XL			;X
		andi	YL,0x07			;only bits
		inc	YL			;+1
		ldi	tempreg1,0x00		;bitmask
		sec				;set carry
libmio_plot1_1:	rol	tempreg1		;shift in bit
		dec	YL
		brne	libmio_plot1_1
;bit mask is in tempreg1
		lsr	XL			;X/8
		lsr	XL
		lsr	XL
		ldi	YL,libmio_v1cols/8
		lds 	YH,libmio_vidmode
		sbrc	YH,2
		ldi	YL,libmio_v5cols/8		
		mul	XH,YL
		ldi	YH,HIGH(libmio_vram)	;home position
		ldi	YL,LOW(libmio_vram)	;home position
		add	YL,XL
		adc	YH,const_0
		add	YL,r0
		adc	YH,r1
;address is now in Y	    	
		lds	XL,libmio_color		;active color
		lsr	XL
		andi	XL,0x01			;we check only bit 0
		brne	libmio_plot1_2		;set
		com	tempreg1
		ld	XL,Y
		and	XL,tempreg1
		st	Y,XL
		rjmp	libmio_plot_os
				
libmio_plot1_2:	ld	XL,Y
		or	XL,tempreg1
		st	Y,XL		
		rjmp	libmio_plot_os

libmio_plot2_0:	mov	YL,XL			;X
		lds	tempreg2,libmio_color	;active color
		lsr	tempreg2
		andi	tempreg2,0x03		;we check only bit 0+1
		ldi	tempreg1,0x03		;bitmask
		andi	YL,0x03			;only bits
libmio_plot2_1:	breq	libmio_plot2_2
		lsl	tempreg1
		lsl	tempreg1
		lsl	tempreg2
		lsl	tempreg2
		dec	YL
		brne	libmio_plot2_1
libmio_plot2_2:	com	tempreg1	
;bit mask is in tempreg1
;value is in tempreg2
		lsr	XL			;X/4
		lsr	XL
		ldi	YL,libmio_v2cols/4
		mul	XH,YL
		ldi	YH,HIGH(libmio_vram)	;home position
		ldi	YL,LOW(libmio_vram)	;home position
		add	YL,XL
		adc	YH,const_0
		add	YL,r0
		adc	YH,r1
;address is now in Y	    	
		ld	XL,Y
		and	XL,tempreg1
		or	XL,tempreg2
		st	Y,XL	
		rjmp	libmio_plot_os


libmio_plot3_0:	mov	YL,XL			;X
		lds	tempreg2,libmio_color	;active color
		andi	tempreg2,0x0e		;we check only bit 0-2
		ldi	tempreg1,0x0e		;bitmask
		andi	YL,0x01			;only bits
		brne	libmio_plot3_1
		swap	tempreg1
		swap	tempreg2
libmio_plot3_1:	com	tempreg1	
;bit mask is in tempreg1
;value is in tempreg2
		lsr	XL			;X/2
		ldi	YL,libmio_v3cols/2
		mul	XH,YL
		ldi	YH,HIGH(libmio_vram)	;home position
		ldi	YL,LOW(libmio_vram)	;home position
		add	YL,XL
		adc	YH,const_0
		add	YL,r0
		adc	YH,r1
;address is now in Y	    	
		ld	XL,Y
		and	XL,tempreg1		;mask
		or	XL,tempreg2		;new bit
		st	Y,XL
		rjmp	libmio_plot_os
.endif


;-------------------------------------------------------------------------------
; correct char coordinates from YL,YH to ZL,ZH
;-------------------------------------------------------------------------------
libmio_corrc:	cpi	YL,libmio_cols
		brcs	libmio_corrc1
		ldi	YL,libmio_cols-1
libmio_corrc1:	cpi	ZL,libmio_cols
		brcs	libmio_corrc2
		ldi	ZL,libmio_cols-1
libmio_corrc2:	cpi	YH,libmio_rows
		brcs	libmio_corrc3
		ldi	YH,libmio_rows-1
libmio_corrc3:	cpi	ZH,libmio_rows
		brcs	libmio_corrc4
		ldi	ZH,libmio_rows-1
libmio_corrc4:	cp	ZL,YL
		brcc	libmio_corrc5
		mov	r0,ZL
		mov	ZL,YL
		mov	YL,r0
libmio_corrc5:	cp	ZH,YH
		brcc	libmio_corrc6
		mov	r0,ZH
		mov	ZH,YH
		mov	YH,r0
libmio_corrc6:	ret		

;-------------------------------------------------------------------------------
; correct plot coordinates from YL,YH to ZL,ZH
;-------------------------------------------------------------------------------
libmio_corrp:	cp	ZL,YL
		brcc	libmio_corrp1
		mov	r0,ZL
		mov	ZL,YL
		mov	YL,r0
libmio_corrp1:	cp	ZH,YH
		brcc	libmio_corrp2
		mov	r0,ZH
		mov	ZH,YH
		mov	YH,r0
libmio_corrp2:	ret		

;-------------------------------------------------------------------------------
; cbox YL,YH to ZL,ZH
;-------------------------------------------------------------------------------
.ifdef use_libmio_cbox
libmio_cbox:	push	XL			;save registers
		push	XH
		push	YL
		push	YH
		push	ZL
		push	ZH
		push	tempreg2
		rcall	libmio_corrc		;correct coords
libmio_cbox_2:	mov	XL,YL			;set start
		mov	XH,YH
libmio_cbox_3:	push	YL
		push	YH
		rcall	libmio_calc1
		st	Y,const_0
		ldi	tempreg2,LOW(libmio_cols*libmio_rows)
		add	YL,tempreg2
		ldi	tempreg2,HIGH(libmio_cols*libmio_rows)
		adc	YH,tempreg2
		lds	tempreg2,libmio_color
		st	Y,tempreg2
		pop	YH
		pop	YL
		cp	XL,ZL
		breq	libmio_cbox_4
		inc	XL
		rjmp	libmio_cbox_3
libmio_cbox_4:	cp	XH,ZH
		breq	libmio_cbox_5
		mov	XL,YL
		inc	XH
		rjmp	libmio_cbox_3
libmio_cbox_5:	pop	tempreg2
		pop	ZH
		pop	ZL
		pop	YH
		pop	YL
		pop	XH
		pop	XL
		ret				
.endif				

;-------------------------------------------------------------------------------
; ibox YL,YH to ZL,ZH
;-------------------------------------------------------------------------------
.ifdef use_libmio_ibox
libmio_ibox:	push	XL			;save registers
		push	XH
		push	YL
		push	YH
		push	ZL
		push	ZH
		push	tempreg1
		push	tempreg2
		rcall	libmio_corrc		;correct coords
libmio_ibox_2:	mov	XL,YL			;set start
		mov	XH,YH
libmio_ibox_3:	push	YL
		push	YH
		ldi	YH,HIGH(libmio_vram)	;home position
		ldi	YL,LOW(libmio_vram)	;home position
		ldi	tempreg2,LOW(libmio_cols*libmio_rows)
		add	YL,tempreg2
		ldi	tempreg2,HIGH(libmio_cols*libmio_rows)
		adc	YH,tempreg2
		add	YL,XL
		adc	YH,const_0		
		ldi	tempreg2,libmio_cols
		mul	XH,tempreg2
		add	YL,r0
		adc	YH,r1
		ld	tempreg2,Y
		mov	tempreg1,tempreg2
		andi	tempreg2,0xee
		andi	tempreg1,0x11
		swap	tempreg2
		or	tempreg2,tempreg1
		st	Y,tempreg2
		pop	YH
		pop	YL
		cp	XL,ZL
		breq	libmio_ibox_4
		inc	XL
		rjmp	libmio_ibox_3
libmio_ibox_4:	cp	XH,ZH
		breq	libmio_ibox_5
		mov	XL,YL
		inc	XH
		rjmp	libmio_ibox_3
libmio_ibox_5:	pop	tempreg2
		pop	tempreg1
		pop	ZH
		pop	ZL
		pop	YH
		pop	YL
		pop	XH
		pop	XL
		ret						
.endif				

;-------------------------------------------------------------------------------
; box YL,YH to ZL,ZH
;-------------------------------------------------------------------------------
.ifdef use_libmio_box
libmio_box:	push	XL
		push	XH
		push	YL
		push	YH
		push	ZL
		push	ZH
		push	tempreg2
		rcall	libmio_corrp
libmio_box_2:	mov	XL,YL
		mov	XH,YH
libmio_box_3:	rcall	libmio_plot
		inc	XL
		cp	XL,ZL
		brne	libmio_box_3
libmio_box_4:	rcall	libmio_plot
		inc	XH
		cp	ZH,XH
		brne	libmio_box_4
libmio_box_5:	rcall	libmio_plot
		dec	XL
		cp	XL,YL
		brne	libmio_box_5
libmio_box_6:	rcall	libmio_plot
		dec	XH
		cp	XH,YH
		brne	libmio_box_6
		pop	tempreg2
		pop	ZH
		pop	ZL
		pop	YH
		pop	YL
		pop	XH
		pop	XL
		ret				
.endif				

;-------------------------------------------------------------------------------
; fbox YL,YH to ZL,ZH
;-------------------------------------------------------------------------------
.ifdef use_libmio_fbox
libmio_fbox:	push	XL
		push	XH
		push	YL
		push	YH
		push	ZL
		push	ZH
		push	tempreg2
		rcall	libmio_corrp
libmio_fbox_2:	mov	XH,YH
libmio_fbox_3:	mov	XL,YL
libmio_fbox_4:	rcall	libmio_plot
		cp	XL,ZL
		breq	libmio_fbox_5
		inc	XL
		rjmp	libmio_fbox_4
libmio_fbox_5:	rcall	libmio_plot
		cp	ZH,XH
		breq	libmio_fbox_6
		inc	XH
		rjmp	libmio_fbox_3
.endif
		
libmio_fbox_6:	pop	tempreg2
libmio_fbox_7:	pop	ZH
		pop	ZL
		pop	YH
		pop	YL
		pop	XH
		pop	XL
		ret				

;-------------------------------------------------------------------------------
; windowbox YL,YH to ZL,ZH
;-------------------------------------------------------------------------------
.ifdef use_libmio_wbox
libmio_wbox:	rcall	libmio_cbox		;clear box
		push	XL
		push	XH
		push	YL
		push	YH
		push	ZL
		push	ZH
		push	tempreg1
		push	tempreg2
		rcall	libmio_corrc		;sort data
		mov	tempreg1,YL		;save X-pos
		mov	XH,YH
		mov	XL,YL
		rcall	libmio_calc1		;get address
		ldi	tempreg2,0xf2		;upper left corner
		st	Y+,tempreg2		;store
		ldi	tempreg2,0xf1		;hor line
libmio_wbox1:	inc	XL
		cp	XL,ZL
		breq	libmio_wbox2
		st	Y+,tempreg2		;store
		rjmp	libmio_wbox1		;loop
		
libmio_wbox2:	ldi	tempreg2,0xf3		;upper right corner
		st	Y+,tempreg2		;store
libmio_wbox3:	mov	XL,tempreg1		;restore X
		inc	XH			;next line
		cp	XH,ZH			;last line?
		breq	libmio_wbox4		;yes
		rcall	libmio_calc1		;get address
		ldi	tempreg2,0xf0		;vertical line
		st	Y+,tempreg2
		mov	XL,ZL
		rcall	libmio_calc1		;get address
		st	Y+,tempreg2
		rjmp	libmio_wbox3									
libmio_wbox4:	mov	XL,tempreg1
		rcall	libmio_calc1		;get address
		ldi	tempreg2,0xf4		;lower left corner
		st	Y+,tempreg2		;store
		ldi	tempreg2,0xf1		;hor line
libmio_wbox5:	inc	XL
		cp	XL,ZL
		breq	libmio_wbox6
		st	Y+,tempreg2		;store
		rjmp	libmio_wbox5		;loop
		
libmio_wbox6:	ldi	tempreg2,0xf5		;lower right corner
		st	Y+,tempreg2		;store
				
		pop	tempreg2
		pop	tempreg1
		pop	ZH
		pop	ZL
		pop	YH
		pop	YL
		pop	XH
		pop	XL
		ret				

.endif

;-------------------------------------------------------------------------------
; windowheadbox YL,YH to ZL,ZH
;-------------------------------------------------------------------------------
.ifdef use_libmio_whbox
libmio_whbox:	rcall	libmio_wbox		;draw normal windowbox
		push	tempreg2
		push	XL
		push	XH
		push	YL
		push	YH
		push	ZL
		push	ZH
	
		rcall	libmio_corrc		;sort data
		mov	XH,YH
		mov	XL,YL
		rcall	libmio_calc1		;get address
		ldi	tempreg2,0xfb		;left corner
		st	Y+,tempreg2		;store
		ldi	tempreg2,0xec		;header fields
libmio_whbox1:	inc	XL
		cp	XL,ZL
		breq	libmio_whbox2
		st	Y+,tempreg2		;store
		rjmp	libmio_whbox1		;loop
libmio_whbox2:	ldi	tempreg2,0xfc		;right corner
		st	Y+,tempreg2		;store

		pop	ZH			;restore coordinates
		pop	ZL
		pop	YH
		pop	YL
		push	YL
		push	YH
		push	ZL
		push	ZH

		mov	XH,YH
		mov	XL,YL
		inc	XH			;Y+1
		rcall	libmio_calc1		;get address
		ldi	tempreg2,0xfd		;left side
		st	Y+,tempreg2		;store
		ldi	tempreg2,0x20		;space
libmio_whbox3:	inc	XL
		cp	XL,ZL
		breq	libmio_whbox4
		st	Y+,tempreg2		;store
		rjmp	libmio_whbox3		;loop
libmio_whbox4:	ldi	tempreg2,0xfe		;right side
		st	Y+,tempreg2		;store

		pop	ZH			;restore coordinates
		pop	ZL
		pop	YH
		pop	YL
		push	YL
		push	YH
		push	ZL
		push	ZH

		mov	XH,YH
		mov	XL,YL
		inc	XH			;Y+1
		push	XL
		rcall	libmio_calc1		;get address
		ldi	XL,LOW(libmio_cols*libmio_rows)
		ldi	XH,HIGH(libmio_cols*libmio_rows)
		add	YL,XL
		adc	YH,XH
		lds	tempreg2,libmio_color	;get color
		swap	tempreg2
		andi	tempreg2,0xee		;only charset 0
		adiw	YL,0x01			;skip first
		pop	XL
libmio_whboxc3:	inc	XL
		cp	XL,ZL
		breq	libmio_whboxc4
		st	Y+,tempreg2		;store
		rjmp	libmio_whboxc3		;loop

libmio_whboxc4:	pop	ZH			;restore coordinates
		pop	ZL
		pop	YH
		pop	YL
		push	YL
		push	YH
		push	ZL
		push	ZH

		mov	XH,YH
		mov	XL,YL
		subi	XH,0xfe			;Y+2
		rcall	libmio_calc1		;get address
		ldi	tempreg2,0xee		;left side
		st	Y+,tempreg2		;store
		ldi	tempreg2,0xed		;fill
libmio_whbox5:	inc	XL
		cp	XL,ZL
		breq	libmio_whbox6
		st	Y+,tempreg2		;store
		rjmp	libmio_whbox5		;loop
libmio_whbox6:	ldi	tempreg2,0xef		;right side
		st	Y+,tempreg2		;store

		pop	ZH
		pop	ZL
		pop	YH
		pop	YL
		pop	XH
		pop	XL
		pop	tempreg2
		ret				
.endif

;-------------------------------------------------------------------------------
; draw line from YL,YH to ZL,ZH
; this algorithm is a little bit quick and dirty, but it works...
;-------------------------------------------------------------------------------
.ifdef use_libmio_draw
libmio_draw:	push	r16
		push	r17
		push	r18
		push	r19
		push	XL
		push	XH
		push	YL
		push	YH		
		movw	XL,YL			;copy start pointer
		ldi	r16,0xff		;set sgn(dx) negative
		sub	YL,ZL			;x1-x2
		brcc	libmio_draw01		;branch if x1<x2
		neg	r16			;invert sgn(dx)
		neg	YL			;invert dx
libmio_draw01:	ldi	r17,0xff		;set sgn(dy) negative
		sub	YH,ZH			;-dy
		brcc	libmio_draw02		;branch if y1<y2
		neg	r17			;invert sgn(dy)
		neg	YH			;invert dy
libmio_draw02:	cp	YL,YH			;|dx|-|dy|
		brcs	libmio_draw6		;branch if |dy|>|dx|
		rjmp	libmio_draw3

		

;|dx|>|dy|		
libmio_draw3:	mov	r18,YL			;|dx|
		lsr	r18			;/2
libmio_draw4:	rcall	libmio_plot		;plot pixel
		cp	XL,ZL			;the endpoint?
		breq	libmio_draw_e		;yes
		add	XL,r16			;X-step
		sub	r18,YH			;-|dy|
		brcc	libmio_draw4		;no overflow
		add	XH,r17			;y-step
		add	r18,YL
		rjmp	libmio_draw4			

;|dy|>|dx|
libmio_draw6:	mov	r18,YH			;|dy|
		lsr	r18			;/2
libmio_draw7:	rcall	libmio_plot		;plot pixel
		cp	XH,ZH			;the endpoint?
		breq	libmio_draw_e
		add	XH,r17			;y-step
		sub	r18,YL
		brcc	libmio_draw7			
		add	XL,r16			;x-step
		add	r18,YH
		rjmp	libmio_draw7			

libmio_draw_e:	pop	YH
		pop	YL
		pop	XH
		pop	XL
		pop	r19
		pop	r18
		pop	r17
		pop	r16
		ret		


.endif

;-------------------------------------------------------------------------------
; scroll XL lines 1 character left
;-------------------------------------------------------------------------------
.ifdef use_libmio_lscroll
libmio_lsc:	push	XL
		push	XH
		push	YL
		push	YH
		push	ZL
		push	ZH
		ldi	YL,LOW(libmio_vram)
		ldi	YH,HIGH(libmio_vram)	
		clr	ZL
libmio_lsc_01:	ldi	ZH,libmio_cols-1
libmio_lsc_02:	ldd	XH,Y+1
		st	Y+,XH
		dec	ZH
		brne	libmio_lsc_02
		st	Y+,const_0
		inc	ZL
		cp	ZL,XL
		breq	libmio_lsc_03
		cpi	ZL,libmio_rows
		brne	libmio_lsc_01
libmio_lsc_03:	ldi	YL,LOW(libmio_vram)
		ldi	YH,HIGH(libmio_vram)
		ldi	ZH,LOW(libmio_cols*libmio_rows)
		add	YL,ZH
		ldi	ZH,HIGH(libmio_cols*libmio_rows)
		adc	YH,ZH
		clr	ZL
libmio_lsc_11:	ldi	ZH,libmio_cols-1
libmio_lsc_12:	ldd	XH,Y+1
		st	Y+,XH
		dec	ZH
		brne	libmio_lsc_12
		st	Y+,const_0
		inc	ZL
		cp	ZL,XL
		breq	libmio_lsc_13
		cpi	ZL,libmio_rows
		brne	libmio_lsc_11
libmio_lsc_13:	rjmp	libmio_fbox_7
.endif


;-------------------------------------------------------------------------------
; scroll XL lines 1/2 character left (1 plot pixel)
;-------------------------------------------------------------------------------
.ifdef use_libmio_lpscroll
libmio_lps:	push	XL
		push	XH
		push	YL
		push	YH
		push	ZL
		push	ZH
		push	r16
		push	r17
		ldi	YL,LOW(libmio_vram)
		ldi	YH,HIGH(libmio_vram)	
		clr	ZL
libmio_lps_01:	ld	r16,Y
		ldi	ZH,libmio_cols-1
libmio_lps_02:	ldd	r17,Y+1
		bst	r16,1
		bld	r16,0
		bst	r17,0
		bld	r16,1
		bst	r16,3
		bld	r16,2
		bst	r17,2
		bld	r16,3
		andi	r16,0x0f
		st	Y+,r16
		mov	r16,r17
		dec	ZH
		brne	libmio_lps_02
		bst	r17,1
		bld	r17,0
		bst	r17,3
		bld	r17,2
		andi	r17,0x05
		st	Y+,r17
		inc	ZL
		cp	ZL,XL
		breq	libmio_lps_03
		cpi	ZL,libmio_rows
		brne	libmio_lps_01
libmio_lps_03:	pop	r17
		pop	r16
		rjmp	libmio_fbox_7
.endif


;-------------------------------------------------------------------------------
; wait for the end of visible frame
;-------------------------------------------------------------------------------
.ifdef use_libmio_sync
libmio_sync:	push	XL
libmio_sync_1:	mov	XL,vline_l
		cpi	XL,libmio_pixel_rows+1
		breq	libmio_sync_1
libmio_sync_2:	mov	XL,vline_l
		cpi	XL,libmio_pixel_rows+1
		brne	libmio_sync_2
		pop	XL
		ret		    
.endif

;-------------------------------------------------------------------------------
; set palette to YH,YL,ZH,ZL
;-------------------------------------------------------------------------------
.ifdef use_libmio_setpal
libmio_setpal:	swap	YH
		lsl	YH
		andi	YH,0xe0
		sts	libmio_palette+0,YH
		swap	YL
		lsl	YL
		andi	YL,0xe0
		sts	libmio_palette+1,YL

		swap	ZH
		lsl	ZH
		andi	ZH,0xe0
		sts	libmio_palette+2,ZH
		swap	ZL
		lsl	ZL
		andi	ZL,0xe0
		sts	libmio_palette+3,ZL
		ret
.endif

;-------------------------------------------------------------------------------
; play a note (XL=note 0..63 0xff=>noise)
;-------------------------------------------------------------------------------
.ifdef use_libmio_note
libmio_note:	push	ZL
		push	ZH
		push	XL
		sts	libmio_note_val,XL	;write note value
		ldi	ZH,HIGH(libmio_wtable1*2)
		sbrc	XL,6
		ldi	ZH,HIGH(libmio_wtable2*2)
		sts	libmio_wavtab,ZH		
		andi	XL,0x3f			;64 notes
		lsl	XL
		ldi	ZH,HIGH(libmio_ntable*2)	;1 start envtable high
		ldi	ZL,LOW(libmio_ntable*2)	;1 start envtable low
		add	ZL,XL			;offsettable
		adc	ZH,const_0		;
		lpm	XL,Z+			;get low offset
		sts	libmio_woff_l,XL	;write
		lpm	XL,Z+			;get high offset
		sts	libmio_woff_h,XL	;write
		sts	libmio_env,const_0	;start
		sts	libmio_wpos_l,const_0
		sts	libmio_wpos_h,const_0
		pop	XL 
		pop	ZH
		pop	ZL
		ret		    
.endif

;------------------------------------------------------------------------------
;wait for a key
;------------------------------------------------------------------------------
.ifdef use_libmio_waitkey
libmio_waitkey:	sts	libmio_lastkey,const_0
libmio_wkey1:	lds	tempreg1,libmio_lastkey
		cpi	tempreg1,0
		breq	libmio_wkey1

.ifdef use_libmio_screenshot		
		rjmp	libmio_scrs
.else
		ret
.endif				
.endif

;------------------------------------------------------------------------------
;wait for no key
;------------------------------------------------------------------------------
libmio_nokey:	lds	tempreg1,libmio_keycode
		cpi	tempreg1,0
		brne	libmio_nokey
		ret

		
;------------------------------------------------------------------------------
;blink cursor and wait for key (return x,y in X ; adr in Y ; key in tempreg1)
;------------------------------------------------------------------------------
.ifdef use_libmio_cursor
libmio_cursor:	rcall	libmio_calc		;calculate address
		ldi	XL,LOW(690)
		add	YL,XL
		ldi	XL,HIGH(690)
		adc	YH,XL
		
libmio_cur1:	ld	XL,Y			;get original color
		mov	XH,XL			;copy
		push	XL
		andi	XL,0x11
		andi	XH,0xee
		swap	XH
		or	XH,XL
		pop	XL
		sts	libmio_lastkey,const_0	;clear key
libmio_cur_1:	lds	tempreg1,libmio_lastkey
		cpi	tempreg1,0
		brne	libmio_cur_e

		lds	tempreg1,libmio_frames
		cpi	tempreg1,27		;ca. half of fps
		brcc	libmio_cur_2
		st	Y,XL
		rjmp	libmio_cur_1
		
libmio_cur_2:	st	Y,XH
		rjmp	libmio_cur_1						
		
libmio_cur_e:	st	Y,XL			;put back original char
		
.ifdef use_libmio_screenshot		
		rcall	libmio_scrs
.endif				
		rjmp	libmio_calc
.endif			

;------------------------------------------------------------------------------
;blink cursor and wait for key (return x,y in X ; adr in Y ; key in tempreg1)
;------------------------------------------------------------------------------
.ifdef use_libmio_ecursor
libmio_ecursor:	push	r19
		ldi	r19,0xdd		;dummy
		rcall	libmio_ecalc
		sts	libmio_lastkey,const_0	;clear key
libmio_ecur_1:	lds	tempreg1,libmio_kbdstate
		andi	tempreg1,0x04		;left ctrl
		cp	tempreg1,r19
		breq	libmio_ecur_c
		cpi	tempreg1,0x00		;no
		brne	libmio_ecur_b
		call	editor_shline
		mov	r19,tempreg1
		rjmp	libmio_ecur_c
libmio_ecur_b:	call	editor_chline
		mov	r19,tempreg1
libmio_ecur_c:	lds	tempreg1,libmio_lastkey
		cpi	tempreg1,0
		brne	libmio_ecur_e
		lds	tempreg1,libmio_frames
		cpi	tempreg1,27		;ca. half of fps
		brcc	libmio_ecur_2
		ld	tempreg1,Y		;get char
		andi	tempreg1,0x7f		;set normal
		st	Y,tempreg1
		rjmp	libmio_ecur_1
libmio_ecur_2:	ld	tempreg1,Y		;get char
		ori	tempreg1,0x80		;set inverse
		st	Y,tempreg1
		rjmp	libmio_ecur_1						
		
libmio_ecur_e:	ld	tempreg2,Y		;get char
		andi	tempreg2,0x7f		;set normal
		st	Y,tempreg2
		pop	r19
		ret		
.endif

;------------------------------------------------------------------------------
;blink cursor and wait for key (return x,y in X ; adr in Y ; key in tempreg1)
;------------------------------------------------------------------------------
.ifdef use_libmio_ncursor
libmio_ncursor:	ldi	YH,HIGH(libmio_vram+11)	;home position
		ldi	YL,LOW(libmio_vram+11)	;home position
		add	YL,XL			;position+x
		adc	YH,const_0		
		sts	libmio_lastkey,const_0	;clear key
libmio_ncur_1:	lds	tempreg1,libmio_lastkey
		cpi	tempreg1,0
		brne	libmio_ncur_e
		lds	tempreg1,libmio_frames
		cpi	tempreg1,27		;ca. half of fps
		brcc	libmio_ncur_2
		ld	tempreg1,Y		;get char
		andi	tempreg1,0x7f		;set normal
		st	Y,tempreg1
		rjmp	libmio_ncur_1
libmio_ncur_2:	ld	tempreg1,Y		;get char
		ori	tempreg1,0x80		;set inverse
		st	Y,tempreg1
		rjmp	libmio_ncur_1						
		
libmio_ncur_e:	ld	tempreg2,Y		;get char
		andi	tempreg2,0x7f		;set normal
		st	Y,tempreg2
		ret		
.endif

;------------------------------------------------------------------------------
;calculate char address to Y
;------------------------------------------------------------------------------
libmio_calc:	mov	XL,libmio_cur_x		;X
		mov	XH,libmio_cur_y		;Y
libmio_calc1:	ldi	YH,libmio_cols		;chars per line
		mul	XH,YH			;store
		ldi	YH,HIGH(libmio_vram)	;home position
		ldi	YL,LOW(libmio_vram)	;home position
		add	YL,XL			;position+x
		adc	YH,const_0		
		add	YL,r0			;position+(cols*y)
		adc	YH,r1
		ret

;------------------------------------------------------------------------------
;calculate attributes address to Y
;------------------------------------------------------------------------------
libmio_calc2:	rcall	libmio_calc1
		push	r16
		ldi	r16,LOW(libmio_cols*libmio_rows)
		add	YL,r16
		ldi	r16,HIGH(libmio_cols*libmio_rows)
		adc	YH,r16
		pop	r16
		ret
		
;------------------------------------------------------------------------------
;calculate ecursor address to Y
;------------------------------------------------------------------------------
libmio_ecalc:	ldi	YH,libmio_ecols		;chars per line
		mul	XH,YH			;store
		ldi	YH,HIGH(libmio_vram+3*libmio_ecols+3)	;home position
		ldi	YL,LOW(libmio_vram+3*libmio_ecols+3)	;home position
		add	YL,XL			;position+x
		adc	YH,const_0		
		add	YL,r0			;position+(cols*y)
		adc	YH,r1
		ret

;------------------------------------------------------------------------------
;get char on cursor address
;------------------------------------------------------------------------------
.ifdef use_libmio_gchar
libmio_gchar:	rcall	libmio_calc
		ld	tempreg1,Y
		ret
.endif		

;------------------------------------------------------------------------------
;set cursor to down position
;------------------------------------------------------------------------------
.ifdef use_libmio_vcur
libmio_vcur:	mov	XL,libmio_cur_x		;X
		mov	XH,libmio_cur_y		;Y
		dec	XL
		inc	XH
		rjmp	libmio_gxy		;set new cursor position
.endif		
		
;------------------------------------------------------------------------------
;put tempreg1 to printer output
;------------------------------------------------------------------------------
libmio_ppar:	push	XH
		lds	XH,libmio_sysconf
		sbrc	XH,4
		rjmp	libmio_ppar_4
		ldi	XH,0xff
		out	DDRA,XH			;set port A4-7 as outputs
		nop
libmio_ppar_1:	sbic	PINB,2			;busy
		rjmp	libmio_ppar_1		;yes
		out	PORTA,tempreg1		;data
		ldi	XH,100			;pause
libmio_ppar_2:	dec	XH
		brne	libmio_ppar_2
		cbi	PORTB,1			;clear strobe (active)
		ldi	XH,100			;pause
libmio_ppar_3:	dec	XH
		brne	libmio_ppar_3
		sbi	PORTB,1			;set strobe (inactive)
libmio_ppar_4:	pop	XH
		ret				;thats all


;------------------------------------------------------------------------------
;output screenshot
;------------------------------------------------------------------------------
.ifdef use_libmio_screenshot
libmio_scrs_1:	pop	tempreg1
		ret
libmio_scrs:	push	tempreg1		;
		lds	tempreg1,libmio_kflags
		sbrs	tempreg1,1		;screenshot-flag
		rjmp	libmio_scrs_1
		andi	tempreg1,0xfd		;clear screenshot-flag
		sts	libmio_kflags,tempreg1	;write back
		push	ZH			;save Z-register
		push	ZL			;save Z-register
		push	YH			;save Y-register
		push	YL			;save Y-register
		lds	tempreg1,libmio_vidmode	;video mode
		cpi	tempreg1,0x00		;text?
		brne	libmio_scrs_01		;no
		lds	tempreg1,libmio_config	;editor/normal
		sbrs	tempreg1,7		;check bit 7
		rjmp	libmio_scrs_2		;normal
		rjmp	libmio_scrs_5		;editor
libmio_scrs_01:	push	tempreg1
		ldi	tempreg1,'G'		;identify
		rcall	libmio_pser
		pop	tempreg1		;reload
		push	tempreg1
		subi	tempreg1,0xd0		;+0x30
		rcall	libmio_pser
		pop	tempreg1		;restore
		cpi	tempreg1,0x01		;mode 1
		brne	libmio_scrs_02		
		rjmp	libmio_scrg1		;screenshot mode 1
libmio_scrs_02:	cpi	tempreg1,0x02		;mode 2
		brne	libmio_scrs_03		
		rjmp	libmio_scrg2		;screenshot mode 2
libmio_scrs_03:	cpi	tempreg1,0x03		;mode 2
		brne	libmio_scrs_05		
		rjmp	libmio_scrg3
libmio_scrs_05:	rjmp	libmio_scrg5	

		
libmio_scrs_2:	ldi	tempreg1,'T'		;identify
		call	libmio_pser
		
		ldi	tempreg1,0x0a
		call	libmio_pser

		ldi	YL,LOW(libmio_vram)
		ldi	YH,HIGH(libmio_vram)
		ldi	ZH,libmio_rows*2	;number of charlines
libmio_scrs_3:	ldi	ZL,libmio_cols		;number of chars per line
libmio_scrs_4:	ld	tempreg1,Y
		swap	tempreg1		;high nibble first
		rcall	libmio_scrs_c
		ld	tempreg1,Y+
		rcall	libmio_scrs_c
		dec	ZL
		brne	libmio_scrs_4
		ldi	tempreg1,0x0a
		call	libmio_pser
		dec	ZH
		brne	libmio_scrs_3
		pop	YL
		pop	YH
		pop	ZL
		pop	ZH
		pop	tempreg1
		clr	tempreg1		;kill character		
		ret

libmio_scrs_5:	ldi	tempreg1,'E'		;identify
		call	libmio_pser		;out
		lds	tempreg1,libmio_estatus	;color of status line
		rcall	libmio_scrs_cc		;out
		ldi	tempreg1,0x0a
		call	libmio_pser

		ldi	YL,LOW(libmio_vram)
		ldi	YH,HIGH(libmio_vram)
		ldi	ZH,0x03			;number of fix charlines
libmio_scrs_6:	ldi	ZL,libmio_ecols		;number of chars per line
libmio_scrs_7:	ld	tempreg1,Y
		swap	tempreg1		;high nibble first
		rcall	libmio_scrs_c
		ld	tempreg1,Y+
		rcall	libmio_scrs_c
		dec	ZL
		brne	libmio_scrs_7
		ldi	tempreg1,0x0a
		call	libmio_pser
		dec	ZH
		brne	libmio_scrs_6
		ldi	ZL,libmio_ecols		;calc startadr of listing 
		lds	ZH,libmio_edstart
		mul	ZL,ZH
		add	YL,r0
		adc	YH,r1
		ldi	ZH,0x10			;number of edit charlines
libmio_scrs_8:	ldi	ZL,libmio_ecols		;number of chars per line
libmio_scrs_9:	ld	tempreg1,Y
		andi	tempreg1,0x7f		;mask invert bit
		swap	tempreg1		;high nibble first
		rcall	libmio_scrs_c
		ld	tempreg1,Y+
		andi	tempreg1,0x7f		;mask invert bit
		rcall	libmio_scrs_c
		dec	ZL
		brne	libmio_scrs_9
		ldi	tempreg1,0x0a
		call	libmio_pser
		dec	ZH
		brne	libmio_scrs_8
libmio_scrs_e:	pop	YL
		pop	YH
		pop	ZL
		pop	ZH
		pop	tempreg1
		clr	tempreg1		;kill character		
		ret

;graphics mode 1	
libmio_scrg1:	lds	tempreg1,libmio_palette		;palette enty 0
		rcall	libmio_scrs_cc		;out
		lds	tempreg1,libmio_palette+1		;palette enty 1
		rcall	libmio_scrs_cc		;out
		ldi	tempreg1,0x0a
		rcall	libmio_pser

libmio_scrg1_1:	ldi	YL,LOW(libmio_vram)
		ldi	YH,HIGH(libmio_vram)
		ldi	ZH,116			;number of pixlines
libmio_scrg1_2:	ldi	ZL,21			;number of chars per line
libmio_scrg1_3:	ld	tempreg1,Y
		swap	tempreg1		;high nibble first
		rcall	libmio_scrs_c
		ld	tempreg1,Y+
		rcall	libmio_scrs_c
		dec	ZL
		brne	libmio_scrg1_3
		ldi	tempreg1,0x0a
		call	libmio_pser
		dec	ZH
		brne	libmio_scrg1_2
		rjmp	libmio_scrs_e

;graphics mode 2	
libmio_scrg2:	lds	tempreg1,libmio_palette		;palette enty 0
		rcall	libmio_scrs_cc		;out
		lds	tempreg1,libmio_palette+1		;palette enty 1
		rcall	libmio_scrs_cc		;out
		lds	tempreg1,libmio_palette+2		;palette enty 2
		rcall	libmio_scrs_cc		;out
		lds	tempreg1,libmio_palette+3		;palette enty 3
		rcall	libmio_scrs_cc		;out
		ldi	tempreg1,0x0a
		rcall	libmio_pser

libmio_scrg2_1:	ldi	YL,LOW(libmio_vram)
		ldi	YH,HIGH(libmio_vram)
		ldi	ZH,84			;number of pixlines
libmio_scrg2_2:	ldi	ZL,30			;number of chars per line
libmio_scrg2_3:	ld	tempreg1,Y
		swap	tempreg1		;high nibble first
		rcall	libmio_scrs_c
		ld	tempreg1,Y+
		rcall	libmio_scrs_c
		dec	ZL
		brne	libmio_scrg2_3
		ldi	tempreg1,0x0a
		call	libmio_pser
		dec	ZH
		brne	libmio_scrg2_2
		rjmp	libmio_scrs_e

;graphics mode 3	
libmio_scrg3:	ldi	tempreg1,0x0a
		rcall	libmio_pser

libmio_scrg3_1:	ldi	YL,LOW(libmio_vram)
		ldi	YH,HIGH(libmio_vram)
		ldi	ZH,58			;number of pixlines
libmio_scrg3_2:	ldi	ZL,42			;number of chars per line
libmio_scrg3_3:	ld	tempreg1,Y
		swap	tempreg1		;high nibble first
		rcall	libmio_scrs_c
		ld	tempreg1,Y+
		rcall	libmio_scrs_c
		dec	ZL
		brne	libmio_scrg3_3
		ldi	tempreg1,0x0a
		call	libmio_pser
		dec	ZH
		brne	libmio_scrg3_2
		rjmp	libmio_scrs_e

;graphics mode 5	
libmio_scrg5:	lds	tempreg1,libmio_palette		;palette enty 0
		rcall	libmio_scrs_cc		;out
		lds	tempreg1,libmio_palette+1	;palette enty 1
		rcall	libmio_scrs_cc		;out
		ldi	tempreg1,0x0a
		rcall	libmio_pser

libmio_scrg5_1:	ldi	YL,LOW(libmio_vram)
		ldi	YH,HIGH(libmio_vram)
		ldi	ZH,64			;number of pixlines
libmio_scrg5_2:	ldi	ZL,16			;number of chars per line
libmio_scrg5_3:	ld	tempreg1,Y
		swap	tempreg1		;high nibble first
		rcall	libmio_scrs_c
		ld	tempreg1,Y+
		rcall	libmio_scrs_c
		dec	ZL
		brne	libmio_scrg5_3
		ldi	tempreg1,0x0a
		call	libmio_pser
		dec	ZH
		brne	libmio_scrg5_2
		rjmp	libmio_scrs_e


libmio_scrs_cc:	swap	tempreg1		;
		lsr	tempreg1
		andi	tempreg1,0x07		;mask bits
		
libmio_scrs_c:	andi	tempreg1,0x0f		;mask bits
		subi	tempreg1,0xd0		;+30
		cpi	tempreg1,0x3a		;>9
		brcs	libmio_scrs_c1		;jump, if not
		subi	tempreg1,0xf9		;+6
libmio_scrs_c1:	jmp	libmio_pser		

.endif

;------------------------------------------------------------------------------
;enable/disable chargepump
;------------------------------------------------------------------------------
.ifdef use_libmio_chp
libmio_chp:	push	XH
		ldi	XH,0x02			;disable output
		cpi	XL,0			;is zero
		breq	libmio_chp1
		ori	XH,0x40			;enable output
libmio_chp1:	out	TCCR0A,XH
		pop	XH
		ret
.endif


;------------------------------------------------------------------------------
;put tempreg1 to serial output
;------------------------------------------------------------------------------
libmio_pser:	push	XH
libmio_pser_1:	lds	XH,libmio_tcnt		;counter
		cpi	XH,0x00			;ready?
		brne	libmio_pser_1		;loop
		sts	libmio_tdat,tempreg1	;store data
		dec	XH			;prepare 0xff
		sts	libmio_tcnt,XH		;store start
		pop	XH
		ret				;thats all

;------------------------------------------------------------------------------
;get tempreg1 from serial input
;------------------------------------------------------------------------------
libmio_gser:	push	XH
libmio_gser_1:	lds	XH,libmio_rcnt		;counter
		cpi	XH,0x00			;ready?
		brne	libmio_gser_1		;loop
		dec	XH			;prepare 0xff
		sts	libmio_rcnt,XH		;store start
libmio_gser_2:	lds	XH,libmio_rcnt		;counter
		cpi	XH,0x00			;ready?
		brne	libmio_gser_2		;loop
		lds	tempreg1,libmio_rdat	;get char
libmio_pconv1:	pop	XH
		ret				;thats all

;------------------------------------------------------------------------------
;get tempreg1 from serial input with break
;------------------------------------------------------------------------------
libmio_gserb:	push	XH
libmio_gserb_1:	lds	XH,libmio_rcnt		;counter
		cpi	XH,0x00			;ready?
		brne	libmio_gserb_1		;loop
		dec	XH			;prepare 0xff
		sts	libmio_rcnt,XH		;store start
libmio_gserb_2:	lds	tempreg1,libmio_keycode	;get keycode
		cpi	tempreg1,0xed		;ESC
		breq	libmio_gserb_4		;end if ESC key is pressed
		lds	XH,libmio_rcnt		;counter
		cpi	XH,0x00			;ready?
		brne	libmio_gserb_2		;loop
		lds	tempreg1,libmio_rdat	;get char
libmio_gserb_3:	pop	XH
		ret				;thats all
libmio_gserb_4:	ldi	tempreg1,0x1b		;ESC
		pop	XH
		ret				;thats all

;-------------------------------------------------------------------------------
; draw menu from Z and exit with a valid key in tempreg1 T=0 Flash T=1 RAM
;-------------------------------------------------------------------------------
libmio_dmenu:	push	YH
		push	YL
		push	XH
		push	XL
		push	ZH
		push	ZL
		ldi	YL,LOW(libmio_vram+1350)	;attr address
		ldi	YH,HIGH(libmio_vram+1350)
		ldi	ZL,LOW(libmio_menu_at*2)
		ldi	ZH,HIGH(libmio_menu_at*2)
		rcall	libmio_menu_fc			;copy from Flash
libmio_menu_1:	pop	ZL
		pop	ZH
		push	ZH
		push	ZL
		rcall	libmio_scrs
		ldi	YL,LOW(libmio_vram+660)		;char address
		ldi	YH,HIGH(libmio_vram+660)
		lds	XH,libmio_kbdstate
		sbrc	XH,2				;left ctrl
		adiw	ZL,30				;ctrl level
libmio_menu_2:	brts	libmio_menu_3			;branch if RAM
		rcall	libmio_menu_fc			;copy from flash
		rjmp	libmio_menu_4
libmio_menu_3:	rcall	libmio_menu_rc			;copy from ram
libmio_menu_4:	lds	tempreg1,libmio_keycode		;get keycode
		ldi	XL,0x01
		cpi	tempreg1,0xed			;ESC
		breq	libmio_menu_10
		ldi	XL,0x02
		cpi	tempreg1,0xf1			;F1
		breq	libmio_menu_10
		ldi	XL,0x03
		cpi	tempreg1,0xf2			;F2
		breq	libmio_menu_10
		ldi	XL,0x04
		cpi	tempreg1,0xf3			;F3
		breq	libmio_menu_10
		ldi	XL,0x05
		cpi	tempreg1,0xf4			;F4
		breq	libmio_menu_10
		rjmp	libmio_menu_1			;no valid key			
					
libmio_menu_10:	lds	XH,libmio_kbdstate
		sbrc	XH,2
		subi	XL,0xfb				;+5 for ctrl
		mov	tempreg1,XL			;copy result		
libmio_menu_12:	pop	ZL
		pop	ZH
		pop	XL
		pop	XH
		pop	YL
		pop	YH
		ret

;copy from RAM		
libmio_menu_rc:	ldi	XH,30
libmio_menu_r1:	ld	XL,Z+
		st	Y+,XL
		dec	XH
		brne	libmio_menu_r1
		ret
		

;copy from flash
libmio_menu_fc:	ldi	XH,30
libmio_menu_f1:	lpm	XL,Z+
		st	Y+,XL
		dec	XH
		brne	libmio_menu_f1
		ret
					
;color table		
libmio_menu_at:	.db	0x4e,0x4e,0x4e,0x4e,0x4e,0x4e
		.db	0xc0,0xc0,0xc0,0xc0,0xc0,0xc0
		.db	0x80,0x80,0x80,0x80,0x80,0x80
		.db	0x2e,0x2e,0x2e,0x2e,0x2e,0x2e			
		.db	0x6e,0x6e,0x6e,0x6e,0x6e,0x6e

;only draw menu
libmio_domenu:	push	YH
		push	YL
		push	XH
		push	XL
		push	ZH
		push	ZL
		ldi	YL,LOW(libmio_vram+1350)	;attr address
		ldi	YH,HIGH(libmio_vram+1350)
		ldi	ZL,LOW(libmio_menu_at*2)
		ldi	ZH,HIGH(libmio_menu_at*2)
		rcall	libmio_menu_fc			;copy from Flash
		pop	ZL
		pop	ZH
		push	ZH
		push	ZL
		ldi	YL,LOW(libmio_vram+660)		;char address
		ldi	YH,HIGH(libmio_vram+660)
		rcall	libmio_menu_fc			;copy from flash
		rjmp	libmio_menu_12

;-------------------------------------------------------------------------------
; set config for I2C and SPI
;-------------------------------------------------------------------------------
libmio_setconf:	ldi	XL,0x5c		;f/4
		lds	XH,libmio_sysconf
		sbrc	XH,3
		ldi	XL,0x5f		;f/128
		out	SPCR0,XL
		ldi	XL,92		;speed
		sts	TWBR,XL		
		ldi	XL,0x00		;/1
		sbrc	XH,2
		ldi	XL,0x01		;f/128
		sts	TWSR,XL
		ret		
		
;-------------------------------------------------------------------------------
; pseudo-random generator (external call)
;-------------------------------------------------------------------------------
libmio_psrg:	push	ZH
		push	ZL
		push	r16
		lds	ZL,libmio_rand1
		lds	XL,libmio_rand2
		lds	XH,libmio_rand3
		lds	ZH,libmio_rand4
		clr	r16
		sbrc	ZL,2
		com	r16
		sbrc	ZL,5
		com	r16
		sbrc	XL,4
		com	r16
		sbrc	ZH,7
		com	r16
		rol	r16
		rol	ZL
		rol	XL
		rol	XH
		rol	ZH
		sts	libmio_rand1,ZL
		sts	libmio_rand2,XL
		sts	libmio_rand3,XH
		sts	libmio_rand4,ZH
		pop	r16
		pop	ZL
		pop	ZH
		ret
		

.include 	"libmio/bcopy.asm"
.include 	"libmio/circle.asm"
.include	"libmio/alert.asm"
.include	"libmio/sprites.asm"
.include	"libmio/scroll.asm"
.include	"libmio/xmodem.asm"
					