;################################################################################
;#										#
;# libmio - multi i/o for ATMega644 version 0.40				#
;# scroll routines								#
;# copyright (c) 2008 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 2 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;-------------------------------------------------------------------------------
;scroll inner screen (tempreg1=0 to 3)
;-------------------------------------------------------------------------------
libmio_scrl:	push	XL
		push	XH
		push	YL
		push	YH
		push	tempreg1
		push	tempreg2
		push	tempreg3
		push	tempreg4
		push	tempreg5
		lds	tempreg4,libmio_color
		andi	tempreg1,0x03
		brne	libmio_scrl_10
;scroll up
		ldi	XL,LOW(libmio_vram+2*libmio_cols+2)	;destination
		ldi	XH,HIGH(libmio_vram+2*libmio_cols+2)		
		ldi	YL,LOW(libmio_vram+3*libmio_cols+2)	;source
		ldi	YH,HIGH(libmio_vram+3*libmio_cols+2)		
		mov	tempreg5,const_0
		rcall	libmio_scrl_05

		ldi	XL,LOW(libmio_vram+2*libmio_cols+2+libmio_rows*libmio_cols)	;destination
		ldi	XH,HIGH(libmio_vram+2*libmio_cols+2+libmio_rows*libmio_cols)		
		ldi	YL,LOW(libmio_vram+3*libmio_cols+2+libmio_rows*libmio_cols)	;source
		ldi	YH,HIGH(libmio_vram+3*libmio_cols+2+libmio_rows*libmio_cols)
		mov	tempreg5,tempreg4
		rcall	libmio_scrl_05
		rjmp	libmio_scrl_e

;subroutine
libmio_scrl_05:	ldi	tempreg3,libmio_rows-5
libmio_scrl_06:	ldi	tempreg2,libmio_cols-4
libmio_scrl_07:	ld	tempreg1,Y+
		st	X+,tempreg1
		dec	tempreg2
		brne	libmio_scrl_07
		adiw	XL,4
		adiw	YL,4
		dec	tempreg3
		brne	libmio_scrl_06
		ldi	tempreg2,libmio_cols-4
libmio_scrl_08:	st	X+,tempreg5
		dec	tempreg2		
		brne	libmio_scrl_08
		ret


;scroll right		
libmio_scrl_10:	cpi	tempreg1,0x01		;code for right
		brne	libmio_scrl_20		;no
		ldi	XL,LOW(libmio_vram+libmio_cols*(libmio_rows-2)-2)
		ldi	XH,HIGH(libmio_vram+libmio_cols*(libmio_rows-2)-2)		
		ldi	YL,LOW(libmio_vram+libmio_cols*(libmio_rows-2)-3)
		ldi	YH,HIGH(libmio_vram+libmio_cols*(libmio_rows-2)-3)		
		mov	tempreg5,const_0
		rcall	libmio_scrl_15
		
		ldi	XL,LOW(libmio_vram+libmio_cols*(libmio_rows-2)-2+libmio_rows*libmio_cols)
		ldi	XH,HIGH(libmio_vram+libmio_cols*(libmio_rows-2)-2+libmio_rows*libmio_cols)		
		ldi	YL,LOW(libmio_vram+libmio_cols*(libmio_rows-2)-3+libmio_rows*libmio_cols)
		ldi	YH,HIGH(libmio_vram+libmio_cols*(libmio_rows-2)-3+libmio_rows*libmio_cols)		
		mov	tempreg5,tempreg4
		rcall	libmio_scrl_15
		rjmp	libmio_scrl_e

;subroutine
libmio_scrl_15:	ldi	tempreg3,libmio_rows-4
libmio_scrl_16:	ldi	tempreg2,libmio_cols-5
libmio_scrl_17:	ld	tempreg1,-Y
		st	-X,tempreg1
		dec	tempreg2
		brne	libmio_scrl_17
		st	-X,tempreg5
		sbiw	XL,4
		sbiw	YL,5		
		dec	tempreg3
		brne	libmio_scrl_16
		ret		

		
;scroll down
libmio_scrl_20:	cpi	tempreg1,0x02		;code for down
		brne	libmio_scrl_30		;no
		ldi	XL,LOW(libmio_vram+libmio_cols*(libmio_rows-2)-2)
		ldi	XH,HIGH(libmio_vram+libmio_cols*(libmio_rows-2)-2)		
		ldi	YL,LOW(libmio_vram+libmio_cols*(libmio_rows-3)-2)
		ldi	YH,HIGH(libmio_vram+libmio_cols*(libmio_rows-3)-2)		
		mov	tempreg5,const_0
		rcall	libmio_scrl_25

		ldi	XL,LOW(libmio_vram+libmio_cols*(libmio_rows-2)-2+libmio_rows*libmio_cols)
		ldi	XH,HIGH(libmio_vram+libmio_cols*(libmio_rows-2)-2+libmio_rows*libmio_cols)		
		ldi	YL,LOW(libmio_vram+libmio_cols*(libmio_rows-3)-2+libmio_rows*libmio_cols)
		ldi	YH,HIGH(libmio_vram+libmio_cols*(libmio_rows-3)-2+libmio_rows*libmio_cols)		
		mov	tempreg5,tempreg4
		rcall	libmio_scrl_25
		rjmp	libmio_scrl_e


libmio_scrl_25:	ldi	tempreg3,libmio_rows-5
libmio_scrl_26:	ldi	tempreg2,libmio_cols-4
libmio_scrl_27:	ld	tempreg1,-Y
		st	-X,tempreg1
		dec	tempreg2
		brne	libmio_scrl_27
		sbiw	XL,4
		sbiw	YL,4				
		dec	tempreg3
		brne	libmio_scrl_26
		ldi	tempreg2,libmio_cols-4
libmio_scrl_28:	st	-X,tempreg5
		dec	tempreg2		
		brne	libmio_scrl_28	
		ret

;scroll left		
libmio_scrl_30:	ldi	XL,LOW(libmio_vram+libmio_cols*2+2)
		ldi	XH,HIGH(libmio_vram+libmio_cols*2+2)		
		ldi	YL,LOW(libmio_vram+libmio_cols*2+3)
		ldi	YH,HIGH(libmio_vram+libmio_cols*2+3)		
		mov	tempreg5,const_0
		rcall	libmio_scrl_35

		ldi	XL,LOW(libmio_vram+libmio_cols*2+2+libmio_rows*libmio_cols)
		ldi	XH,HIGH(libmio_vram+libmio_cols*2+2+libmio_rows*libmio_cols)		
		ldi	YL,LOW(libmio_vram+libmio_cols*2+3+libmio_rows*libmio_cols)
		ldi	YH,HIGH(libmio_vram+libmio_cols*2+3+libmio_rows*libmio_cols)		
		mov	tempreg5,tempreg4
		rcall	libmio_scrl_35
		rjmp	libmio_scrl_e


libmio_scrl_35:	ldi	tempreg3,libmio_rows-4
libmio_scrl_36:	ldi	tempreg2,libmio_cols-5
libmio_scrl_37:	ld	tempreg1,Y+
		st	X+,tempreg1
		dec	tempreg2
		brne	libmio_scrl_37
		st	X+,tempreg5
		adiw	YL,5
		adiw	XL,4
		dec	tempreg3
		brne	libmio_scrl_36
		ret
		
libmio_scrl_e:	pop	tempreg5
		pop	tempreg4
		pop	tempreg3
		pop	tempreg2
		pop	tempreg1
		pop	YH
		pop	YL
		pop	XH
		pop	XL
		ret
					