;################################################################################
;#										#
;# libmio - multi i/o for ATMega644 version 0.40				#
;# sprites									#
;# copyright (c) 2006-2008 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 2 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.ifdef use_libmio_sprites
;-------------------------------------------------------------------------------
; sprite definitions
; +00	collision flag
; +01	current X (ff=not visible)
; +02	current Y (ff=not visible)
; +03	dx
; +04  	dy
; +05... data
;------------------------------------------------------------------------------

;-------------------------------------------------------------------------------
; draw sprite with address
;-------------------------------------------------------------------------------
libmio_sprite:	push	ZH			;save Z-reg
		push	ZL
		push	YH			;save Y-reg
		push	YL
		push	XH			;save ccords
		push	XL		
		lds	YL,libmio_bcsrcx	;ptr
		lds	YH,libmio_bcsrcy
		ldd	r16,Y+2			;last X
		ldd	r17,Y+1			;last Y
		cpi	r16,libmio_cols		;visible?
		brcc	libmio_spr_1		;no
		cpi	r17,libmio_rows		;visible?
		brcc	libmio_spr_1		;no
;restore old if was visible
		rcall	libmio_srest		;restore screen
;backup and draw
libmio_spr_1:	lds	XL,libmio_bcdestx	;coords
		lds	XH,libmio_bcdesty
		lds	YL,libmio_bcsrcx	;ptr
		lds	YH,libmio_bcsrcy
		std	Y+1,XH			;set new old ccords
		std	Y+2,XL
		cpi	XL,libmio_cols		;visible?
		brcc	libmio_spr_2		;no
		cpi	XH,libmio_rows		;visible?
		brcc	libmio_spr_2		;no
		rcall	libmio_sback		;backup screen
		andi	tempreg4,0x03
		cpi	tempreg4,0x01		
		breq	libmio_spr_2
		rcall	libmio_sdraw

libmio_spr_2:	pop	XL			;restore registers
		pop	XH
		pop	YL
		pop	YH
		pop	ZL
		pop	ZH
		ret				;thats all

;-------------------------------------------------------------------------------
; restore old
;-------------------------------------------------------------------------------
libmio_srest:	lds	YL,libmio_bcsrcx	;ptr
		lds	YH,libmio_bcsrcy
		ldd	r16,Y+2			;last X
		ldd	r17,Y+1			;last Y
		ldd	r18,Y+4			;dX
		ldd	r19,Y+3			;dY		
		mul	r18,r19			;dx*dy
		add	r19,r17			;calc Y2
		adiw	YL,5			;header
		add	YL,r0			;skip sprite data
		adc	YH,r1
		add	YL,r0
		adc	YH,r1
;chars		
		mov	tempreg1,r17		;Y-pos		
libmio_srest1:	ldi	ZL,LOW(libmio_vram)	;base_address
		ldi	ZH,HIGH(libmio_vram)
		ldi	tempreg2,libmio_cols	;cols
		mul	tempreg2,tempreg1	;*Y
		add	ZL,r0			;add Y-offset
		adc	ZH,r1
		add	ZL,r16			;add X-offset
		adc	ZH,const_0
		mov	tempreg2,r18		;dx
libmio_srest2:	ld	tempreg3,Y+		;get char
		st	Z+,tempreg3		;copy to vram
		dec	tempreg2		;loop counter
		brne	libmio_srest2		;X loop
		inc	tempreg1		;Y+1
		cp	tempreg1,r19		;end
		brne	libmio_srest1		;loop
;attributes		
		mov	tempreg1,r17		;Y-pos		
libmio_srest3:	ldi	ZL,LOW(libmio_vram+690)	;base_address
		ldi	ZH,HIGH(libmio_vram+690)
		ldi	tempreg2,libmio_cols	;cols
		mul	tempreg2,tempreg1	;*Y
		add	ZL,r0			;add Y-offset
		adc	ZH,r1
		add	ZL,r16			;add X-offset
		adc	ZH,const_0
		mov	tempreg2,r18		;dx
libmio_srest4:	ld	tempreg3,Y+		;get char
		st	Z+,tempreg3		;copy to vram
		dec	tempreg2		;loop counter
		brne	libmio_srest4		;X loop
		inc	tempreg1		;Y+1
		cp	tempreg1,r19		;end
		brne	libmio_srest3		;loop
		ret				;thats all


;-------------------------------------------------------------------------------
; backup
;-------------------------------------------------------------------------------
libmio_sback:	lds	YL,libmio_bcsrcx	;ptr
		lds	YH,libmio_bcsrcy
		ldd	r16,Y+2			;last X
		ldd	r17,Y+1			;last Y
		ldd	r18,Y+4			;dX
		ldd	r19,Y+3			;dY		
		mul	r18,r19			;dx*dy
		add	r19,r17			;calc Y2
		adiw	YL,5			;header
		add	YL,r0			;skip sprite data
		adc	YH,r1
		add	YL,r0
		adc	YH,r1
		clr	tempreg4		;clear coll ptr
;chars		
		mov	tempreg1,r17		;Y-pos		
libmio_sback1:	ldi	ZL,LOW(libmio_vram)	;base_address
		ldi	ZH,HIGH(libmio_vram)
		ldi	tempreg2,libmio_cols	;cols
		mul	tempreg2,tempreg1	;*Y
		add	ZL,r0			;add Y-offset
		adc	ZH,r1
		add	ZL,r16			;add X-offset
		adc	ZH,const_0
		mov	tempreg2,r18		;dx
libmio_sback2:	ld	tempreg3,Z+		;get v-char
		st	Y+,tempreg3		;copy to ram
		andi	tempreg3,0x0f
		breq	libmio_sback3
		ldi	tempreg4,0x01		;set col flag
libmio_sback3:	dec	tempreg2		;loop counter
		brne	libmio_sback2		;X loop
		inc	tempreg1		;Y+1
		cp	tempreg1,r19		;end
		brne	libmio_sback1		;loop
;store coll
		lds	ZL,libmio_bcsrcx	;ptr
		lds	ZH,libmio_bcsrcy
		ld	tempreg1,Z
		or	tempreg4,tempreg1
		st	Z,tempreg4	
;attributes		
		mov	tempreg1,r17		;Y-pos		
libmio_sback4:	ldi	ZL,LOW(libmio_vram+690)	;base_address
		ldi	ZH,HIGH(libmio_vram+690)
		ldi	tempreg2,libmio_cols	;cols
		mul	tempreg2,tempreg1	;*Y
		add	ZL,r0			;add Y-offset
		adc	ZH,r1
		add	ZL,r16			;add X-offset
		adc	ZH,const_0
		mov	tempreg2,r18		;dx
libmio_sback5:	ld	tempreg3,Z+		;get v-attr
		st	Y+,tempreg3		;copy to ram
		dec	tempreg2		;loop counter
		brne	libmio_sback5		;X loop
		inc	tempreg1		;Y+1
		cp	tempreg1,r19		;end
		brne	libmio_sback4		;loop
		ret				;thats all

;-------------------------------------------------------------------------------
; draw
;-------------------------------------------------------------------------------
libmio_sdraw:	lds	YL,libmio_bcsrcx	;ptr
		lds	YH,libmio_bcsrcy
		ldd	r16,Y+2			;new X
		ldd	r17,Y+1			;new Y		
		ldd	r18,Y+4			;dX
		ldd	r19,Y+3			;dY		
		add	r19,r17			;calc Y2
		adiw	YL,5			;header
;chars		
		mov	tempreg1,r17		;Y-pos		
libmio_sdraw1:	ldi	ZL,LOW(libmio_vram)	;base_address
		ldi	ZH,HIGH(libmio_vram)
		ldi	tempreg2,libmio_cols	;cols
		mul	tempreg2,tempreg1	;*Y
		add	ZL,r0			;add Y-offset
		adc	ZH,r1
		add	ZL,r16			;add X-offset
		adc	ZH,const_0
		mov	tempreg2,r18		;dx
libmio_sdraw2:	ld	tempreg3,Y+		;get char
		st	Z+,tempreg3		;copy to vram
		dec	tempreg2		;loop counter
		brne	libmio_sdraw2		;X loop
		inc	tempreg1		;Y+1
		cp	tempreg1,r19		;end
		brne	libmio_sdraw1		;loop
;attributes		
		mov	tempreg1,r17		;Y-pos		
libmio_sdraw3:	ldi	ZL,LOW(libmio_vram+690)	;base_address
		ldi	ZH,HIGH(libmio_vram+690)
		ldi	tempreg2,libmio_cols	;cols
		mul	tempreg2,tempreg1	;*Y
		add	ZL,r0			;add Y-offset
		adc	ZH,r1
		add	ZL,r16			;add X-offset
		adc	ZH,const_0
		mov	tempreg2,r18		;dx
libmio_sdraw4:	ld	tempreg3,Y+		;get v-attr
		lsl	tempreg3		;*2
		brcc	libmio_sdraw5
		andi	tempreg3,0x0e
		mov	tempreg5,tempreg3
		ld	tempreg3,Z		;get old
		andi	tempreg3,0xf0
		or	tempreg3,tempreg5
libmio_sdraw5:	st	Z+,tempreg3		;copy to ram
		dec	tempreg2		;loop counter
		brne	libmio_sdraw4		;X loop
		inc	tempreg1		;Y+1
		cp	tempreg1,r19		;end
		brne	libmio_sdraw3		;loop
		ret				;thats all

.endif
					