#!/usr/bin/perl
#################################################################################
#										#
# screenshot convert tool for avr-chipbasic2 0.88				#
# copyright (c) 2006-2009 Joerg Wolfram (joerg@jcwolfram.de)			#
#										#
# This program is free software; you can redistribute it and/or			#
# modify it under the terms of the GNU General Public License			#
# as published by the Free Software Foundation; either version 2		#
# of the License, or (at your option) any later version.			#
#										#
# This program is distributed in the hope that it will be useful,		#
# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
# General Public License for more details.					#
#										#
# You should have received a copy of the GNU General Public			#
# License along with this library; if not, write to the				#
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
# Boston, MA 02111-1307, USA.							#
#										#
#################################################################################
$infile=$ARGV[0];

$ct[0]=".";
$ct[1]="B";
$ct[2]="R";
$ct[3]="M";
$ct[4]="G";
$ct[5]="C";
$ct[6]="Y";
$ct[7]="W";

###############################################################################
# get pixel value from tab
###############################################################################
sub get_pixel
{
    $nb=0;
    if ($z =~ /^\./) {$nb=0}
    elsif ($z =~ /^x/) {$nb=1}
    $z=$';
    return $nb;
}

###############################################################################
# get nibble data from matrix
###############################################################################
sub get_nibble
{
    $nb=0;
    if ($z =~ /^0/) {$nb=0}
    elsif ($z =~ /^1/) {$nb=1}
    elsif ($z =~ /^2/) {$nb=2}
    elsif ($z =~ /^3/) {$nb=3}
    elsif ($z =~ /^4/) {$nb=4}
    elsif ($z =~ /^5/) {$nb=5}
    elsif ($z =~ /^6/) {$nb=6}
    elsif ($z =~ /^7/) {$nb=7}
    elsif ($z =~ /^8/) {$nb=8}
    elsif ($z =~ /^9/) {$nb=9}
    elsif ($z =~ /^A/) {$nb=10}
    elsif ($z =~ /^B/) {$nb=11}
    elsif ($z =~ /^C/) {$nb=12}
    elsif ($z =~ /^D/) {$nb=13}
    elsif ($z =~ /^E/) {$nb=14}
    elsif ($z =~ /^F/) {$nb=15}
    $z=$';
    return $nb;
}

###############################################################################
# get screenshot type
###############################################################################
sub get_type
{
    $nb=0;
    if ($z =~ /^T/) {$nb=0}
    elsif ($z =~ /^E/) {$nb=1}
    elsif ($z =~ /^G/) {$nb=2}
    $z=$';
    return $nb;
}

###############################################################################
# read data from chip
###############################################################################
sub get_data
{
    open (SER, $infile);
    $z=<SER>;
    $gt=&get_type();
    if ($gt==0)
    {    
	for($i=0;$i<46;$i++)
	{
	    $data[$i]=<SER>;
	}
    }
    elsif ($gt==1)
    {    
	$pal[0]=&get_nibble();
	$pal[0]=$pal[0]*32;
	if ($pal[0]<128){$pal[0]=$pal[0]+14}
	for($i=0;$i<19;$i++)
	{
	    $data[$i]=<SER>;
	}
    }
    elsif ($gt==2)
    {
	$res=&get_nibble();
	if ($res==1)
	{
	    $pal[0]=&get_nibble();
	    $pal[1]=&get_nibble();
	    for($i=0;$i<116;$i++)
	    {
		$data[$i]=<SER>;
	    }	    
	}    
	elsif ($res==2)
	{
	    $pal[0]=&get_nibble();
	    $pal[1]=&get_nibble();
	    $pal[2]=&get_nibble();
	    $pal[3]=&get_nibble();
	    for($i=0;$i<76;$i++)
	    {
		$data[$i]=<SER>;
	    }	    
	}    
	elsif ($res==3)
	{
	    for($i=0;$i<58;$i++)
	    {
		$data[$i]=<SER>;
	    }
	}

	elsif ($res==5)
	{
	    $pal[0]=&get_nibble();
	    $pal[1]=&get_nibble();
	    for($i=0;$i<64;$i++)
	    {
		$data[$i]=<SER>;
	    }
	}
	
    }
    close(SER);
}

###############################################################################
# convert strings to char and attribute array (normal mode)
###############################################################################
sub fillarray_mode0
{
    for ($y=0;$y<23;$y++)
    {
	$z=$data[$y];
	for ($x=0;$x<30;$x++)
	{
	    $hi=&get_nibble();
	    $lo=&get_nibble();
	    $vcell[30*$y+$x]=16*$hi+$lo;
	}
    }

    for ($y=0;$y<23;$y++)
    {
	$z=$data[23+$y];
	for ($x=0;$x<30;$x++)
	{
	    $hi=&get_nibble();
	    $lo=&get_nibble();
	    $acell[30*$y+$x]=16*$hi+$lo;
	}
    }
}

###############################################################################
# convert strings to char and attribute array (editor mode)
###############################################################################
sub fillarray_emode
{
    for ($y=0;$y<19;$y++)
    {
	$z=$data[$y];
	for ($x=0;$x<36;$x++)
	{
	    $hi=&get_nibble();
	    $lo=&get_nibble();
	    if ($y==0)
	    {
		$vcell[$x]=16*$hi+$lo;
		$acell[$x]=10;		
	    }	
	    if ($y==1)
	    {
		$vcell[36+$x]=16*$hi+$lo;
		$acell[36+$x]=$pal[0];	
	    }
	    if ($y==2)
	    	
	    {
		$vcell[36*18+$x]=16*$hi+$lo;
		$acell[36*18+$x]=32*2+2*7;
		if ($x>6)
		{
		    $acell[36*18+$x]=32*6+2*0;
		}
		if ($x>13)
		{
		    $acell[36*18+$x]=32*4+2*0;
		}
		if ($x>20)
		{
		    $acell[36*18+$x]=32*1+2*7;
		}
		if ($x>27)
		{
		    $acell[36*18+$x]=32*3+2*7;
		}
	    }	
	    if ($y>2)
	    {
		$vcell[36*($y-1)+$x]=16*$hi+$lo;
		$acell[36*($y-1)+$x]=14;
	    }	
	    
	}
    }
}

###############################################################################
# convert strings to pixel array (graphics1)
###############################################################################
sub fillarray_gmode1
{
    $bgc=$ct[$pal[0]];
    $fgc=$ct[$pal[1]];
    
    for ($y=0;$y<116;$y++)
    {
	$z=$data[$y];
	for ($x=0;$x<21;$x++)
	{
	    $hi=&get_nibble();
	    $lo=&get_nibble();
	    $bline=$lo+16*$hi;
	    for ($px=0;$px<8;$px++)
	    {
		$bit=$bline & 1;
		if ($bit==0)
		{
		    $vcell[$px+8*$x+168*$y]=$bgc;
		}
		else
		{
		    $vcell[$px+8*$x+168*$y]=$fgc;
		}
		$bline=$bline >> 1;
	    }
	}
    }
}

###############################################################################
# convert strings to pixel array (graphics2)
###############################################################################
sub fillarray_gmode2
{
    for ($y=0;$y<76;$y++)
    {
	$z=$data[$y];
	for ($x=0;$x<30;$x++)
	{
	    $hi=&get_nibble();
	    $lo=&get_nibble();
	    $cin[0]=$lo & 3;
	    $lo=$lo >> 2;
	    $cin[1]=$lo & 3;
	    $cin[2]=$hi & 3;
	    $hi=$hi >> 2;
	    $cin[3]=$hi & 3;
	    $vcell[4*$x+120*$y+0]=$ct[$pal[$cin[0]]];
	    $vcell[4*$x+120*$y+1]=$ct[$pal[$cin[1]]];
	    $vcell[4*$x+120*$y+2]=$ct[$pal[$cin[2]]];
	    $vcell[4*$x+120*$y+3]=$ct[$pal[$cin[3]]];
	}
    }
}

###############################################################################
# convert strings to pixel array (graphics3)
###############################################################################
sub fillarray_gmode3
{
    for ($y=0;$y<58;$y++)
    {
	$z=$data[$y];
	for ($x=0;$x<42;$x++)
	{
	    $hi=&get_nibble();
	    $lo=&get_nibble();
	    $vcell[2*$x+84*$y+0]=$ct[$lo >> 1];
	    $vcell[2*$x+84*$y+1]=$ct[$hi >> 1];
	}
    }
}


###############################################################################
# convert strings to pixel array (graphics5)
###############################################################################
sub fillarray_gmode5
{
    $bgc=$ct[$pal[0]];
    $fgc=$ct[$pal[1]];
    for ($y=0;$y<64;$y++)
    {
	$z=$data[$y];
	for ($x=0;$x<16;$x++)
	{
	    $hi=&get_nibble();
	    $lo=&get_nibble();
	    $bline=$lo+16*$hi;
	    for ($px=0;$px<8;$px++)
	    {
		$bit=$bline & 1;
		if ($bit==0)
		{
		    $vcell[$px+8*$x+128*$y]=$bgc;
		}
		else
		{
		    $vcell[$px+8*$x+128*$y]=$fgc;
		}
		$bline=$bline >> 1;
	    }
	}
    }
}

###############################################################################
# write xpm image (normal mode)
###############################################################################
sub writexpm_mode0
{
    open (WTAB, ">temp.xpm");
    print WTAB "static char *screenshot_xpm[] ={\n";
    print WTAB "\"370 240 8 1\",\n";
    print WTAB "\". c #000000\",\n";
    print WTAB "\"B c #0000ff\",\n";
    print WTAB "\"R c #ff0000\",\n";
    print WTAB "\"M c #ff00ff\",\n";
    print WTAB "\"G c #00ff00\",\n";
    print WTAB "\"C c #00ffff\",\n";
    print WTAB "\"Y c #ffff00\",\n";
    print WTAB "\"W c #ffffff\",\n";

#Black border (upper)
    for($pline=0;$pline<5;$pline++)
    {
	print WTAB "\""; 
	for($chr=0;$chr<370;$chr++)
	{
    	    print WTAB "."; 
	}
	print WTAB "\",\n";
    }

    for($cline=0;$cline<23;$cline++)
    {
	for($pline=0;$pline<10;$pline++)
	{
    	    print WTAB "\"....."; 
	    for($chr=0;$chr<30;$chr++)
	    {
		$vchar=$vcell[30*$cline+$chr];
		$attr=$acell[30*$cline+$chr];
		$vg=$attr & 14;
		$vg=$ct[$vg/2];
		$hg=$attr & 224;
		$hg=$ct[$hg/32];

		for($pix=0;$pix<6;$pix++)
		{
		    $pchar=$hg;
		    if ($charcell[6*$pline+60*$vchar+$pix]>0)
		    {
			$pchar=$vg;    
	    	    }
		    print WTAB $pchar.$pchar;
		}
	    }    
    	    print WTAB ".....\",\n";
	}
    }

#Black border (lower)
    for($pline=0;$pline<5;$pline++)
    {
	print WTAB "\""; 
	for($chr=0;$chr<370;$chr++)
	{
    	    print WTAB "."; 
	}
	    if ($pline<5)
	    {
    	        print WTAB "\",\n";
	    }
	    else
	    {
        	print WTAB "\"\n";
	    }    
    }
    
    print WTAB "};\n"; 
    close(WTAB);
}

###############################################################################
# write xpm image (graphics mode 1)
###############################################################################
sub writexpm_gmode1
{
    open (WTAB, ">temp.xpm");
    print WTAB "static char *screenshot_xpm[] ={\n";
    print WTAB "\"346 242 8 1\",\n";
    print WTAB "\". c #000000\",\n";
    print WTAB "\"B c #0000ff\",\n";
    print WTAB "\"R c #ff0000\",\n";
    print WTAB "\"M c #ff00ff\",\n";
    print WTAB "\"G c #00ff00\",\n";
    print WTAB "\"C c #00ffff\",\n";
    print WTAB "\"Y c #ffff00\",\n";
    print WTAB "\"W c #ffffff\",\n";

#Black border (upper)
    for($pline=0;$pline<5;$pline++)
    {
	print WTAB "\""; 
	for($chr=0;$chr<346;$chr++)
	{
    	    print WTAB "."; 
	}
	print WTAB "\",\n";
    }

    for($cline=0;$cline<116;$cline++)
    {
	for ($pline=0;$pline<2;$pline++)
	{
    	    print WTAB "\"....."; 
	    for($chr=0;$chr<168;$chr++)
	    {
		$vchar=$vcell[168*$cline+$chr];
		print WTAB $vchar.$vchar;
	    }    
    	    print WTAB ".....\",\n";
	}
    }

#Black border (lower)
    for($pline=0;$pline<5;$pline++)
    {
	print WTAB "\""; 
	for($chr=0;$chr<346;$chr++)
	{
    	    print WTAB "."; 
	}
	    if ($pline<5)
	    {
    	        print WTAB "\",\n";
	    }
	    else
	    {
        	print WTAB "\"\n";
	    }    
    }
    
    print WTAB "};\n"; 
    close(WTAB);
}

###############################################################################
# write xpm image (graphics mode 2)
###############################################################################
sub writexpm_gmode2
{
    open (WTAB, ">temp.xpm");
    print WTAB "static char *screenshot_xpm[] ={\n";
    print WTAB "\"370 238 8 1\",\n";
    print WTAB "\". c #000000\",\n";
    print WTAB "\"B c #0000ff\",\n";
    print WTAB "\"R c #ff0000\",\n";
    print WTAB "\"M c #ff00ff\",\n";
    print WTAB "\"G c #00ff00\",\n";
    print WTAB "\"C c #00ffff\",\n";
    print WTAB "\"Y c #ffff00\",\n";
    print WTAB "\"W c #ffffff\",\n";

#Black border (upper)
    for($pline=0;$pline<5;$pline++)
    {
	print WTAB "\""; 
	for($chr=0;$chr<370;$chr++)
	{
    	    print WTAB "."; 
	}
	print WTAB "\",\n";
    }

    for($cline=0;$cline<76;$cline++)
    {
	for ($pline=0;$pline<3;$pline++)
	{
    	    print WTAB "\"....."; 
	    for($chr=0;$chr<120;$chr++)
	    {
		$vchar=$vcell[120*$cline+$chr];
		print WTAB $vchar.$vchar.$vchar;
	    }    
    	    print WTAB ".....\",\n";
	}
    }

#Black border (lower)
    for($pline=0;$pline<5;$pline++)
    {
	print WTAB "\""; 
	for($chr=0;$chr<370;$chr++)
	{
    	    print WTAB "."; 
	}
	    if ($pline<5)
	    {
    	        print WTAB "\",\n";
	    }
	    else
	    {
        	print WTAB "\"\n";
	    }    
    }
    
    print WTAB "};\n"; 
    close(WTAB);
}


###############################################################################
# write xpm image (graphics mode 3)
###############################################################################
sub writexpm_gmode3
{
    open (WTAB, ">temp.xpm");
    print WTAB "static char *screenshot_xpm[] ={\n";
    print WTAB "\"346 242 8 1\",\n";
    print WTAB "\". c #000000\",\n";
    print WTAB "\"B c #0000ff\",\n";
    print WTAB "\"R c #ff0000\",\n";
    print WTAB "\"M c #ff00ff\",\n";
    print WTAB "\"G c #00ff00\",\n";
    print WTAB "\"C c #00ffff\",\n";
    print WTAB "\"Y c #ffff00\",\n";
    print WTAB "\"W c #ffffff\",\n";

#Black border (upper)
    for($pline=0;$pline<5;$pline++)
    {
	print WTAB "\""; 
	for($chr=0;$chr<346;$chr++)
	{
    	    print WTAB "."; 
	}
	print WTAB "\",\n";
    }

    for($cline=0;$cline<58;$cline++)
    {
	for ($pline=0;$pline<4;$pline++)
	{
    	    print WTAB "\"....."; 
	    for($chr=0;$chr<84;$chr++)
	    {
		$vchar=$vcell[84*$cline+$chr];
		print WTAB $vchar.$vchar;
		print WTAB $vchar.$vchar;
	    }    
    	    print WTAB ".....\",\n";
	}
    }

#Black border (lower)
    for($pline=0;$pline<5;$pline++)
    {
	print WTAB "\""; 
	for($chr=0;$chr<346;$chr++)
	{
    	    print WTAB "."; 
	}
	    if ($pline<5)
	    {
    	        print WTAB "\",\n";
	    }
	    else
	    {
        	print WTAB "\"\n";
	    }    
    }
    
    print WTAB "};\n"; 
    close(WTAB);
}


###############################################################################
# write xpm image (graphics mode 5)
###############################################################################
sub writexpm_gmode5
{
    open (WTAB, ">temp.xpm");
    print WTAB "static char *screenshot_xpm[] ={\n";
    print WTAB "\"394 202 8 1\",\n";
    print WTAB "\". c #000000\",\n";
    print WTAB "\"B c #0000ff\",\n";
    print WTAB "\"R c #ff0000\",\n";
    print WTAB "\"M c #ff00ff\",\n";
    print WTAB "\"G c #00ff00\",\n";
    print WTAB "\"C c #00ffff\",\n";
    print WTAB "\"Y c #ffff00\",\n";
    print WTAB "\"W c #ffffff\",\n";

#Black border (upper)
    for($pline=0;$pline<5;$pline++)
    {
	print WTAB "\""; 
	for($chr=0;$chr<394;$chr++)
	{
    	    print WTAB "."; 
	}
	print WTAB "\",\n";
    }

    for($cline=0;$cline<64;$cline++)
    {
	for ($pline=0;$pline<3;$pline++)
	{
    	    print WTAB "\"....."; 
	    for($chr=0;$chr<128;$chr++)
	    {
		$vchar=$vcell[128*$cline+$chr];
		print WTAB $vchar.$vchar.$vchar;
	    }    
    	    print WTAB ".....\",\n";
	}
    }

#Black border (lower)
    for($pline=0;$pline<5;$pline++)
    {
	print WTAB "\""; 
	for($chr=0;$chr<394;$chr++)
	{
    	    print WTAB "."; 
	}
	    if ($pline<5)
	    {
    	        print WTAB "\",\n";
	    }
	    else
	    {
        	print WTAB "\"\n";
	    }    
    }
    
    print WTAB "};\n"; 
    close(WTAB);
}


###############################################################################
# write xpm image (editor mode)
###############################################################################
sub writexpm_emode
{
    open (WTAB, ">temp.xpm");
    print WTAB "static char *screenshot_xpm[] ={\n";
    print WTAB "\"442 238 8 1\",\n";
    print WTAB "\". c #000000\",\n";
    print WTAB "\"B c #0000ff\",\n";
    print WTAB "\"R c #ff0000\",\n";
    print WTAB "\"M c #ff00ff\",\n";
    print WTAB "\"G c #00ff00\",\n";
    print WTAB "\"C c #00ffff\",\n";
    print WTAB "\"Y c #ffff00\",\n";
    print WTAB "\"W c #ffffff\",\n";

#Black border (upper)
    for($pline=0;$pline<5;$pline++)
    {
	print WTAB "\""; 
	for($chr=0;$chr<442;$chr++)
	{
    	    print WTAB "."; 
	}
	print WTAB "\",\n";
    }

    for($cline=0;$cline<19;$cline++)
    {
	for($pline=0;$pline<12;$pline++)
	{
	    if (($pline==0) || ($pline==11))
	    {
    		print WTAB "\""; 
		for($chr=0;$chr<442;$chr++)
		{
    		    print WTAB "."; 
		}
    		print WTAB "\",\n"; 
	    }
	    else
	    {
    		print WTAB "\"....."; 
		for($chr=0;$chr<36;$chr++)
		{
		    $vchar=$vcell[36*$cline+$chr];
		    $attr=$acell[36*$cline+$chr];
		    $vg=$attr & 14;
		    $vg=$ct[$vg/2];
		    $hg=$attr & 224;
		    $hg=$ct[$hg/32];
		    $font=$attr & 1;
		    for($pix=0;$pix<6;$pix++)
		    {
			$pchar=$hg;
			if ($charcell[60*$vchar+6*($pline-1)+$pix]>0)
			{
			    $pchar=$vg;    
	    		}
			print WTAB $pchar.$pchar;
		    }
		}    
    		print WTAB ".....\",\n";
	    }
	}
    }

#Black border (lower)
    for($pline=0;$pline<5;$pline++)
    {
	print WTAB "\""; 
	for($chr=0;$chr<442;$chr++)
	{
    	    print WTAB "."; 
	}
	    if ($pline<5)
	    {
    	        print WTAB "\",\n";
	    }
	    else
	    {
        	print WTAB "\"\n";
	    }    
    }
    
    print WTAB "};\n"; 
    close(WTAB);
}

###############################################################################
# get filename and set color array
###############################################################################
$fname=$ARGV[0];

$ct[0]=".";
$ct[1]="B";
$ct[2]="R";
$ct[3]="M";
$ct[4]="G";
$ct[5]="C";
$ct[6]="Y";
$ct[7]="W";

###############################################################################
# read character cells from fnt0
###############################################################################
$cline=0;
$count=-1;
open (RTAB, "../generator/ctab_0.dat");
while(<RTAB>)
{
    $z=$_;
    chomp($z);
    if ($z =~ /cell/) 
    {
	$cline=0;
	$count++;
    }
    elsif (length($z)>4)
    {
	$charcell[6*($cline)+60*$count+0]=&get_pixel();
	$charcell[6*($cline)+60*$count+1]=&get_pixel();
	$charcell[6*($cline)+60*$count+2]=&get_pixel();
	$charcell[6*($cline)+60*$count+3]=&get_pixel();
	$charcell[6*($cline)+60*$count+4]=&get_pixel();
	$charcell[6*($cline)+60*$count+5]=&get_pixel();
	$cline++;
    }
}
close(RTAB);

###############################################################################
# set serial port and read data from chip
###############################################################################
print "AVR-ChipBASIC2 Screenshot converter V0.88\n";
&get_data();

###############################################################################
# do it
###############################################################################
if ($gt==0)
{
    &fillarray_mode0();
    &writexpm_mode0();
}
if ($gt==1)
{
    &fillarray_emode();
    &writexpm_emode();
}
if ($gt==2)
{
    if ($res==1)
    {
	&fillarray_gmode1();
	&writexpm_gmode1();
    }	
    if ($res==2)
    {
	&fillarray_gmode2();
	&writexpm_gmode2();
    }	
    if ($res==3)
    {
	&fillarray_gmode3();
	&writexpm_gmode3();
    }	
      if ($res==5)
    {
	&fillarray_gmode5();
	&writexpm_gmode5();
    }	  
}


