;################################################################################
;#										#
;# libmio - multi i/o for ATMega644 version 0.40				#
;# video signal generation							#
;# copyright (c) 2005-2008 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 2 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################
;-------------------------------------------------------------------------------
; -graphics mode 168x116 2 colors
;-------------------------------------------------------------------------------
libmio_tvg2:	lds	XL,libmio_rampos_l	;2 BS low
		lds	XH,libmio_rampos_h	;1 BS high

		lds	YH,libmio_palette	;get color 0
		lds	YL,libmio_palette+1	;get color 1
		swap	YL			;swap color 1
		add	YH,YL
		andi	YH,0xee
		ldi	ZL,21			;number of bytes
		lds	r1,libmio_border	;2 get border color
		
		ld	ZH,X+			;get first byte
		mov	tempreg1,YH		;background
		sbrc	ZH,0			;check bit 1
		swap	tempreg1		;set to foreground

libmio_tvg2_1:	out	PORTC,tempreg1		;1 out bit 1		
		nop				;1 fill		
		mov	tempreg1,YH		;1 background
		sbrc	ZH,1			;1 check bit 2
		swap	tempreg1		;1 set to foreground
	
		out	PORTC,tempreg1		;1 out bit 2		
		nop				;1 fill		
		mov	tempreg1,YH		;1 background
		sbrc	ZH,2			;1 check bit 3
		swap	tempreg1		;1 set to foreground

		out	PORTC,tempreg1		;1 out bit 3		
		nop				;1 fill		
		mov	tempreg1,YH		;1 background
		sbrc	ZH,3			;1 check bit 4
		swap	tempreg1		;1 set to foreground
		nop				;1 fill

		out	PORTC,tempreg1		;1 out bit 4		
		mov	tempreg3,YH		;1 background		
		mov	tempreg1,YH		;1 background
		sbrc	ZH,4			;1 check bit 5
		swap	tempreg1		;1 set to foreground
		
		out	PORTC,tempreg1		;1 out bit 5		
		ld	YL,X+			;2 get next byte
		sbrc	ZH,5			;1 check bit 6
		swap	tempreg3		;1 set to foreground
		mov	tempreg2,YH		;1 background
		
		out	PORTC,tempreg3		;1 out bit 6
		sbrc	ZH,6			;1 check bit 7
		swap	tempreg2		;1 set to foreground
		mov	tempreg3,YH		;1 background		
		mov	tempreg1,YH		;1 background

		out	PORTC,tempreg2		;1 out bit 7
		sbrc	ZH,7			;1 check bit 8
		swap	tempreg3		;1 set to foreground
		sbrc	YL,0			;1 check bit 1 of next byte
		swap	tempreg1		;1 set to foreground
		nop				;1 fill
		
		out	PORTC,tempreg3		;1 out bit 8
		mov	ZH,YL			;1 copy byte
		dec	ZL			;2 loop counter
		brne 	libmio_tvg2_1	
		
		out	PORTC,r1		;1 set to border
		
		ld	ZL,-X			;2 correct X-register
		lds	ZH,libmio_cline		;2 character line
		inc	ZH
		cpi	ZH,2			;1 check
		brne	libmio_tvg2_2		;2 jump if not next line
		clr	ZH			;1 character line = 0
		sts	libmio_rampos_l,XL	;2 new memory position
		sts	libmio_rampos_h,XH	;2 new memory position
libmio_tvg2_2:	sts	libmio_cline,ZH		;2 new character line
		jmp	libmio_is_15


;-------------------------------------------------------------------------------
; -graphics mode 120x76 4 colors
;-------------------------------------------------------------------------------
libmio_tvg4:	lds	XL,libmio_rampos_l	;2 BS low
		lds	XH,libmio_rampos_h	;1 BS high

		ldi	YH,0x01			;1 start of palette
		ldi	ZH,30			;1 number of bytes
		lds	r1,libmio_border	;2 get border color
				
		ld	ZL,X+			;2 get first byte
		mov	YL,ZL			;1 copy
		andi	YL,0x03			;1
		ld	tempreg2,Y		;2 get pixel 1
		
libmio_tvg4_1:	out	PORTC,tempreg2		;1 output pixel 1
		mov	YL,ZL			;1 copy back 
		lsr	YL			;1
		lsr	YL			;1
		andi	YL,0x03			;1
		ld	tempreg2,Y		;2 get pixel 2
		swap	ZL			;1
		
		out	PORTC,tempreg2		;1 output pixel 2
		mov	YL,ZL			;1 copy back 
		andi	YL,0x03			;1
		ld	tempreg2,Y		;2 get pixel 3
		mov	YL,ZL			;1
		lsr	YL			;1
		
		out	PORTC,tempreg2		;1 output pixel 3
		lsr	YL			;1
		andi	YL,0x03			;1
		ld	tempreg2,Y		;2 get pixel 4
		ld	ZL,X+			;2 get next byte
		mov	YL,ZL			;1 copy
		
		out	PORTC,tempreg2		;1 output pixel 4
		andi	YL,0x03			;1
		ld	tempreg2,Y		;2 get pixel 1
		dec	ZH			;1 loop counter
		brne 	libmio_tvg4_1		;2
		
		out	PORTC,r1		;1 set to border
		
		ld	ZL,-X			;2 correct X-register
		lds	ZH,libmio_cline		;2 character line
		inc	ZH
		cpi	ZH,3			;1 check
		brne	libmio_tvg4_2		;2 jump if not next line
		clr	ZH			;1 character line = 0
		sts	libmio_rampos_l,XL	;2 new memory position
		sts	libmio_rampos_h,XH	;2 new memory position
libmio_tvg4_2:	sts	libmio_cline,ZH		;2 new character line
		jmp	libmio_is_15


;-------------------------------------------------------------------------------
; -graphics mode 84x58 8 colors
;-------------------------------------------------------------------------------
libmio_tvg8:	lds	XL,libmio_rampos_l	;2 BS low
		lds	XH,libmio_rampos_h	;1 BS high
		push	r16			;2 save reg
		lds	r1,libmio_border	;2 get border color

		ldi	ZL,42			;number of bytes
		ldi	YH,0x01			;start of palette
		ld	YL,X+			;get first byte
		lsr	YL			;1
		mov	r16,YL			;1
		swap	YL			;lower nibble first
		andi	YL,0x07			;mask bits
		ld	ZH,Y			;get value
		
libmio_tvg8_1:	out	PORTC,ZH		;1 out pix 0
		mov	YL,r16			;1
		nop				;1
		andi	YL,0x07			;1 mask bits
		ld	ZH,Y			;2 get value
		nop				;1 fill	
		nop				;1 fill	
		nop				;1 fill		
		out	PORTC,ZH		;1 out pix 1		

		ld	YL,X+			;2 get next byte
		lsr	YL			;1
		mov	r16,YL			;1
		swap	YL			;1 lower nibble first
		andi	YL,0x07			;1 mask bits
		ld	ZH,Y			;2 get value		

		dec	ZL			;1 loop counter
		brne 	libmio_tvg8_1		;2 loop
		
		out	PORTC,r1		;1 set to border

		sbiw	XL,1			;correct
		pop	r16			;restore
		lds	ZH,libmio_cline		;2 character line
		inc	ZH
		cpi	ZH,4			;1 check
		brne	libmio_tvg8_2		;2 jump if not next line
		clr	ZH			;1 character line = 0
		sts	libmio_rampos_l,XL	;2 new memory position
		sts	libmio_rampos_h,XH	;2 new memory position
libmio_tvg8_2:	sts	libmio_cline,ZH		;2 new character line
		jmp	libmio_is_15

		
		

;-------------------------------------------------------------------------------
; -graphics mode 128x64 2 colors
;-------------------------------------------------------------------------------
libmio_tvg1:	lds	XL,libmio_rampos_l	;2 BS low
		lds	XH,libmio_rampos_h	;1 BS high

		lds	YH,libmio_palette	;get color 0
		lds	YL,libmio_palette+1	;get color 1
		swap	YL			;swap color 1
		add	YH,YL
		andi	YH,0xee
		ldi	ZL,16			;number of bytes
		lds	r1,libmio_border	;2 get border color
		
		ld	ZH,X+			;get first byte
		mov	tempreg1,YH		;background
		sbrc	ZH,0			;check bit 1
		swap	tempreg1		;set to foreground

libmio_tvg1_1:	out	PORTC,tempreg1		;1 out bit 1		
		nop				;1 fill
		nop				;1 fill
		nop				;1 fill				
		mov	tempreg1,YH		;1 background
		sbrc	ZH,1			;1 check bit 2
		swap	tempreg1		;1 set to foreground
	
		out	PORTC,tempreg1		;1 out bit 2		
		nop				;1 fill
		nop				;1 fill
		nop				;1 fill						
		mov	tempreg1,YH		;1 background
		sbrc	ZH,2			;1 check bit 3
		swap	tempreg1		;1 set to foreground

		out	PORTC,tempreg1		;1 out bit 3		
		nop				;1 fill
		nop				;1 fill				
		mov	tempreg1,YH		;1 background
		sbrc	ZH,3			;1 check bit 4
		swap	tempreg1		;1 set to foreground
		nop				;1 fill

		out	PORTC,tempreg1		;1 out bit 4
		nop				;1 fill
		nop				;1 fill						
		mov	tempreg3,YH		;1 background		
		mov	tempreg1,YH		;1 background
		sbrc	ZH,4			;1 check bit 5
		swap	tempreg1		;1 set to foreground
		
		out	PORTC,tempreg1		;1 out bit 5
		nop				;1 fill				
		ld	YL,X+			;2 get next byte
		sbrc	ZH,5			;1 check bit 6
		swap	tempreg3		;1 set to foreground
		mov	tempreg2,YH		;1 background
		
		out	PORTC,tempreg3		;1 out bit 6
		nop				;1 fill
		nop				;1 fill				
		sbrc	ZH,6			;1 check bit 7
		swap	tempreg2		;1 set to foreground
		mov	tempreg3,YH		;1 background		
		mov	tempreg1,YH		;1 background

		out	PORTC,tempreg2		;1 out bit 7
		sbrc	ZH,7			;1 check bit 8
		swap	tempreg3		;1 set to foreground
		sbrc	YL,0			;1 check bit 1 of next byte
		swap	tempreg1		;1 set to foreground
		nop				;1 fill
		nop				;1 fill		
		
		out	PORTC,tempreg3		;1 out bit 8
		mov	ZH,YL			;1 copy byte
		nop				;1 fill
		nop				;1 fill				
		dec	ZL			;1 loop counter
		brne 	libmio_tvg1_1		;2

		nop				;1 fill
		out	PORTC,r1		;1 set to border
		
		ld	ZL,-X			;2 correct X-register
		lds	ZH,libmio_cline		;2 character line
		inc	ZH
		cpi	ZH,3			;1 check
		brne	libmio_tvg1_2		;2 jump if not next line
		clr	ZH			;1 character line = 0
		sts	libmio_rampos_l,XL	;2 new memory position
		sts	libmio_rampos_h,XH	;2 new memory position
libmio_tvg1_2:	sts	libmio_cline,ZH		;2 new character line
		jmp	libmio_is_15
		

									