;################################################################################
;#										#
;# libmio - multi i/o for ATMega 644 version 0.40				#
;# macro definitions								#
;# copyright (c) 2005-2008 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 2 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.macro libmio_vint
    jmp	libmio_aisr
.endm

.macro libmio_bint
    jmp	libmio_bisr
.endm

.macro libmio_init
    call	libmio_init
.endm

.macro libmio_outchar
    call	libmio_char
.endm

.macro libmio_outcomma
    rcall	libmio_comma
.endm

.macro libmio_outspace
    call	libmio_space
.endm

.macro libmio_waitkey
    .set	use_libmio_waitkey = 1
    .set	libmio_ps2key = 1
    call	libmio_waitkey
.endm

.macro libmio_nokey
    .set	use_libmio_nokey = 1
    .set	libmio_ps2key = 1
    call	libmio_nokey
.endm

.macro libmio_cursor
    .set	use_libmio_cursor = 1
    .set	libmio_ps2key = 1
    call	libmio_cursor
.endm

.macro libmio_ecursor
    .set	use_libmio_ecursor = 1
    .set	use_libmio_editor_mode = 1
    .set	libmio_ps2key = 1
    call	libmio_ecursor
.endm

.macro libmio_ncursor
    .set	use_libmio_ncursor = 1
    .set	use_libmio_editor_mode = 1
    .set	libmio_ps2key = 1
    call	libmio_ncursor
.endm

.macro libmio_freecur
    .set	use_libmio_cursor = 1
    .set	libmio_ps2key = 1
    rcall	libmio_cur1
.endm

.macro libmio_outdez
    .set	use_libmio_outd = 1
    call	libmio_outd
.endm

.macro libmio_outhex
    .set	use_libmio_outh = 1
    call	libmio_outh
.endm

.macro libmio_clrscr
    call	libmio_clr
.endm

.macro libmio_fillchar
    rcall	libmio_fill
.endm

.macro libmio_ramtext
    .set	use_libmio_oram = 1
    rcall	libmio_oram
.endm

.macro libmio_romtext
    .set	use_libmio_orom = 1
    call	libmio_orom
.endm

.macro libmio_thistext
    .set	use_libmio_othis = 1
    .set	use_libmio_gotoxy = 1
    call	libmio_othis
.endm

.macro libmio_mtext
    .set	use_libmio_mtext = 1
    rcall	libmio_mtext
.endm

.macro libmio_newline
    .set	use_libmio_newline = 1
    call	libmio_newline
.endm

.macro libmio_gotoxy
    .set	use_libmio_gotoxy = 1
    call	libmio_gxy
.endm

.macro libmio_plot
    .set	use_libmio_plot = 1
    call	libmio_plot
.endm

.macro libmio_box
    .set	use_libmio_plot = 1
    .set	use_libmio_box = 1
    call	libmio_box
.endm

.macro libmio_cbox
    .set	use_libmio_cbox = 1
    call	libmio_cbox
.endm

.macro libmio_ibox
    .set	use_libmio_ibox = 1
    rcall	libmio_ibox
.endm

.macro libmio_wbox
    .set	use_libmio_wbox = 1
    call	libmio_wbox
.endm

.macro libmio_whbox
    .set	use_libmio_wbox = 1
    .set	use_libmio_whbox = 1
    call	libmio_whbox
.endm

.macro libmio_wh2box
    .set	use_libmio_wbox = 1
    .set	use_libmio_whbox = 1
    rcall	libmio_wh2box
.endm

.macro libmio_fbox
    .set	use_libmio_plot = 1
    .set	use_libmio_fbox = 1
    call	libmio_fbox
.endm

.macro libmio_circle
    .set	use_libmio_circle = 1
    call	libmio_circle
.endm

.macro libmio_fcircle
    .set	use_libmio_circle = 1
    call	libmio_fcircle
.endm

.macro libmio_draw
    .set	use_libmio_plot = 1
    .set	use_libmio_draw = 1
    call	libmio_draw
.endm

.macro libmio_sync
    .set	use_libmio_sync = 1
    call	libmio_sync
.endm

.macro libmio_note
    .set	use_libmio_note = 1
    call	libmio_note
.endm

.macro libmio_calc
    call	libmio_calc
.endm

.macro libmio_ecalc
    call	libmio_ecalc
.endm

.macro libmio_pser
    .set	use_libmio_serial = 1
    .set	use_libmio_pser = 1
    call	libmio_pser
.endm

.macro libmio_gser
    .set	use_libmio_serial = 1
    .set	use_libmio_gser = 1
    call	libmio_gser
.endm

.macro libmio_gserb
    .set	use_libmio_serial = 1
    .set	use_libmio_gser = 1
    call	libmio_gserb
.endm

.macro libmio_ppar
    .set	use_libmio_ppar = 1
    rcall	libmio_ppar
.endm

.macro libmio_setcolor
    call	libmio_setcol
.endm

.macro libmio_setborder
    call	libmio_setbrd
.endm

.macro libmio_screenshot
    .set	use_libmio_screenshot = 1
    call	libmio_scrs
.endm

.macro libmio_chpump
    .set	use_libmio_chp = 1
    call	libmio_chp
.endm

.macro libmio_cconv
    .set	use_libmio_cconv = 1
    rcall	libmio_cconv
.endm

.macro libmio_pconv
    .set	use_libmio_pconv = 1
    rcall	libmio_pconv
.endm

.macro libmio_gchar
    .set	use_libmio_gchar = 1
    rcall	libmio_pconv
.endm

.macro libmio_vcur
    .set	use_libmio_vcur = 1
    call	libmio_vcur
.endm

.macro libmio_sprite
    .set	use_libmio_sprites = 1
    call	libmio_sprite
.endm

.macro libmio_alert
    call	libmio_abox1
.endm

.macro libmio_ask
    call	libmio_ynbox1
.endm

.macro libmio_alertthis
    call	libmio_abox
.endm

.macro libmio_askthis
    call	libmio_ynbox
.endm

.macro libmio_nmode
    .set	use_libmio_dmode = 1
    call	libmio_nmode
.endm

.macro libmio_setvmode
    call	libmio_svmode
.endm

.macro libmio_random
    .set	use_libmio_psrg = 1
    call	libmio_psrg
.endm

.macro libmio_setpal
    .set	use_libmio_setpal = 1
    rcall	libmio_setpal
.endm

.macro libmio_bcopy
    .set	use_libmio_bcopy = 1
    call	libmio_bcopy
.endm

.macro libmio_scroll
    .set	use_libmio_scroll = 1
    call	libmio_scrl
.endm

.macro libmio_emode
    .set	use_libmio_dmode = 1
    .set	use_libmio_editor_mode = 1
    call	libmio_emode
.endm

.macro libmio_menu
    call	libmio_dmenu
.endm

.macro libmio_drawmenu
    call	libmio_domenu
.endm

.macro libmio_sysconf
    call	libmio_setconf
.endm

.macro libmio_sendx
    call	libmio_txbl
.endm

.macro libmio_recvx
    call	libmio_rxbl
.endm
;################################################################################
;#										#
;# libi2c - I2C library for ATMega controllers					#
;# copyright (c) 2007-2009 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 2 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.macro libi2c_init
    call	libi2c_initl
.endm

.macro libi2c_read
    .set	use_libi2c_read = 1
    call	libi2c_read
.endm

.macro libi2c_start
    call	libi2c_start
.endm

.macro libi2c_stop
    call	libi2c_stop
.endm

.macro libi2c_rbyte
    call	libi2c_rbyte
.endm

.macro libi2c_rbyten
    call	libi2c_rbyten
.endm

.macro libi2c_wbyte
    call	libi2c_wbyte
.endm


.macro libi2c_write
    .set	use_libi2c_write = 1
    call	libi2c_write
.endm

.macro libi2c_rlm75
    .set	use_libi2c_lm75 = 1
    call	libi2c_rlm75
.endm
;################################################################################
;#										#
;# libeep - EEPRO R/W library for AVR controllers				#
;# copyright (c) 2007-2009 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 2 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.macro libeep_read
    call	libeep_read
.endm

.macro libeep_write
    call	libeep_write
.endm

.macro libeep_get
    rcall	libeep_get
.endm

.macro libeep_put
    rcall	libeep_put
.endm

;################################################################################
;#										#
;# libdfl - Dataflash routines							#
;# copyright (c) 2007-2009 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 2 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.macro libdfl_format
    call	libdfl_format
.endm

.macro libdfl_create
    call	libdfl_create
.endm

.macro libdfl_delete
    call	libdfl_del
.endm

.macro libdfl_read
    call	libdfl_read
.endm

.macro libdfl_write
    call	libdfl_write
.endm

.macro libdfl_free
    call	libdfl_cfree
.endm

.macro libdfl_size
    call	libdfl_size
.endm

.macro libdfl_maxpage
    call	libdfl_maxpage
.endm

.macro libdfl_checkformat
    call	libdfl_cif
.endm

.macro libdfl_gettype
    call	libdfl_ghead
    call	libdfl_gtype
.endm

.macro libdfl_gword
    call	libdfl_gdword
.endm

.macro libdfl_readraw
    call	libdfl_bread
    call	libdfl_rdbuf
.endm

.macro libdfl_writeraw
    call	libdfl_wrbuf
    call	libdfl_bwrite
.endm

