;################################################################################
;#										#
;# chipbasic2 v0.88								#
;# single chip basic computer with ATmega644					#
;# copyright (c) 2006-2009 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License as 		#
;# published by the Free Software Foundation; either version 2 of		#
;# the License, or (at your option) any later version.				#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.CSEG
.include	"m644def.inc"
.include	"libdef.asm"			;register definitions
.def		vline_l = r8
.def		vline_h = r9

.equ		libmio_palette	= 0x100		;8 bytes video palette
.equ		libmio_ram	= 0x108		;80 bytes libmio system RAM
.equ		bas_partab	= 0x158		;16 bytes basic parameter
.equ		bas_ram		= 0x168		;16 bytes basic system RAM
.equ		bas_inbuf	= 0x178		;40 bytes input buffer
.equ		bas_linebuf	= 0x1a0		;40 bytes line buffer
.equ		libmio_vram	= 0x1c8		;690 bytes of video RAM (pixel)
.equ		libmio_vram_a	= 0x47a		;690 bytes of video RAM (attributes)

.equ		mon_bpage	= 0x72c		;690 bytes backup page (pixel)
.equ		mon_bpage_a	= 0x9de		;690 bytes backup page (attributes)
.equ		libdfl_buffer	= 0xb80		;libdfl uses a part of monpage space
.equ		libi2c_buffer	= 0xb80		;libi2c uses a part of monpage space
.equ		bcopy_buffer	= 0xb80		;bcopy uses a part of monpage space

.equ		varspace	= 0xc90		;52 bytes basic variables
.equ		expar_ros	= 0xcea		;38 bytes calculator stack
.equ		bas_stacks	= 0xcec		;70 bytes basic stacks
.equ		libsave_ram	= 0xd32		;10 bytes save
.equ		bas_array	= 0xd3c		;512 Bytes Array
.equ		libdfl_ram	= 0x109c	;16 Bytes libdfl system RAM
.equ		stack		= 0x10ff	;60 bytes stack


.include	"modules/definitions.asm"
.include	"libmio/definitions.asm"
.include	"libeep/definitions.asm"
.include	"libi2c/definitions.asm"
.include	"macros.inc"

.set		bas_lines=95
.set		bas_stackdepth = 16
.set		bas_maxprog = 8

.org 0x0000
		rjmp	start
.org 0x0004
		.db 0x56,0x78
.org OC1Aaddr	
		libmio_vint			;video interrupt
.org OC1Baddr	
		libmio_bint			;border-end-interrupt
			
ident:		.db "AVR-ChipBasic2 (c) 2006-2009 Joerg Wolfram",0,0
.org 0x0038
;.include	"api.asm"
start:		cli
		ldi	XL,0x00
		mov	const_0,XL
		ldi	XL,0x01
		mov	const_1,XL
		ldi	XL,HIGH(stack)
		out	SPH,XL
		ldi	XL,LOW(stack)
		out	SPL,XL
wloop1:		ldi	XH,0x00
wloop2:		ldi	XL,0x00		
wloop3:		dec	XL
		brne	wloop3
		dec	XH
		brne	wloop2

		libmio_init
		libi2c_init
		call	mem_getconf
		libmio_sysconf
		libmio_clrscr
		ldi	XL,0xff
		sts	libmio_serio,XL
		sts	libmio_lastmenu,const_0	;reset menu
		sts	libmio_vidmode,const_0
		sts	libmio_seqspeed,const_0
wloop4:		clr	ereg
		sei
		
		sts	libmio_kflags,const_0
		lds	XL,libmio_config	;config
		sbrc	XL,4			;autorun pin
loop:		jmp	intro_main		;main menu

loop2:		libmio_clrscr
		call	menu_runprog		;run program
		libmio_waitkey
		rjmp	start			;run again

.include	"modules/intro.asm"
.include	"modules/menu.asm"
.include	"modules/editor.asm"
.include	"modules/exparser.asm"
.include	"modules/interpreter.asm"
.include	"modules/spi.asm"
.include	"modules/array.asm"
.include	"modules/compress_line.asm"
.include	"modules/expand_line.asm"
.include	"modules/monitor.asm"
.include	"modules/fileman.asm"
.include	"modules/filesys.asm"
.include	"modules/configpage.asm"
.include	"modules/infopage.asm"
.include	"modules/xm.asm"
.include	"modules/tokentable.inc"
.include	"libmio/vidm_tvc.asm"
.include	"libmio/vidm_tvg.asm"
.include	"libmio/vidm_tvm.asm"
.include	"modules/clone.asm"
.include	"libs.inc"

bas_sintab:
.include	"modules/sintable.inc"
libmio_ctable1:
.include	"libmio/ctable_f1.inc"


.org	0x4300
libmio_ktables:
.include	"libmio/keytable_de.inc"

.org	0x4400
.include	"libmio/keytable_en.inc"

.org	0x4500
libmio_costab:	
.include	"libmio/costab.inc"

.org	0x4580
.include	"libmio/soundtables.inc"

.org	0x4700
end_system:
.include	"libmio/bootloader.asm"

.org	0x4800
bas_programs:
;program 1 4800-4dff
.org	0x4800
		.db "            ",0xff

;program 2 4e00-53ff
.org	0x4e00
		.db "            ",0xff

;program 3 5400-59ff
.org	0x5400
		.db "            ",0xff

;program 4 5a00-5fff
.org	0x5a00
		.db "            ",0xff

;program 5 6000-65ff
.org	0x6000
		.db "            ",0xff

;program 6 6600-6bff
.org	0x6600
		.db "            ",0xff

;program 7 6c00-71ff
.org	0x6c00
		.db "            ",0xff

;program 8 7200-77ff
.org	0x7200
		.db "            ",0xff

;---------------------------------------------------------------------------------
;start of nrww-section
;---------------------------------------------------------------------------------
.org	0x7800
.include	"libmio/bootvid.asm"


.include	"modules/memory.asm"

.org	0x7a80
libmio_kstab:
.include	"libmio/kstable.inc"

.org	0x7b00
libmio_ctable:
.include	"libmio/ctable.inc"
