;################################################################################
;#										#
;# avr-chipbasic2 - single chip basic computer with ATmega644			#
;# array functions								#
;# copyright (c) 2006-2008 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 2		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

				
;-----------------------------------------------------------------------
; read array value
;-----------------------------------------------------------------------
bas_rarr:	lds	tempreg2,bas_ram+10	;index low
		lds	tempreg1,bas_ram+11	;index high
		cpi	tempreg1,0x03		;limit for byte
		brcc	bas_raw

;-----------------------------------------------------------------------
; read array byte (bas_ram+10/11 to XL)
;-----------------------------------------------------------------------
bas_rab:	ldi	YH,high(bas_array)	;array
		ldi	YL,low(bas_array)
		add	YL,tempreg2		;array element address
		adc	YH,tempreg1
		ld	XL,Y+
		clr	XH
		rjmp	arr_echeck


;-----------------------------------------------------------------------
; read array word (bas_ram+10/11 to X)
;-----------------------------------------------------------------------
bas_raw:	subi	tempreg2,LOW(1024)
		sbci	tempreg1,HIGH(1024)
		brcs	bas_arr_err
		lsl	tempreg2		;*2
		rol	tempreg1
		cpi	tempreg1,0x03
		brcc	bas_arr_err
		ldi	YH,high(bas_array)	;array
		ldi	YL,low(bas_array)
		add	YL,tempreg2		;array element address
		adc	YH,tempreg1
		ld	XL,Y+
		ld	XH,Y+
		rjmp	arr_echeck

bas_arr_err:	ldi	ereg,18			;out of bound
		ret
		
	
arr_echeck:	lds	tempreg1,bas_ram+10	;index low
		lds	tempreg2,bas_ram+11	;index high
		add	tempreg1,const_1	;+1
		adc	tempreg2,const_0
		sts	bas_ram+10,tempreg1	;write back
		sts	bas_ram+11,tempreg2
		cpi	ereg,0
		brne	arr_echeck1
		ret
		
arr_echeck1:	pop	tempreg1
		pop	tempreg1
		ret		
		
		