;################################################################################
;#										#
;# avr-chipbasic2 - single chip basic computer with ATmega644			#
;# dataflash file manager 							#
;# copyright (c) 2006-2008 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 2		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;------------------------------------------------------------------------------
;main screen mask
;------------------------------------------------------------------------------
confp_main:	ldi	XL,1
		libmio_chpump			;enable chargepump for serial
		sts	libmio_channel,const_0	;output to screen
		sts	libmio_vidmode,const_0	;standard video mode
		ldi	XL,0x07			;color scheme (white on black)
		libmio_setcolor
		ldi	YL,0			;maximal sized box
		ldi	YH,0
		ldi	ZL,29
		ldi	ZH,22
		libmio_whbox
		ldi	XL,0x70			;color scheme (white on black)
		libmio_setcolor
		libmio_thistext
		.db 1,2,"AVR-ChipBasic2 configpage",0
		ldi	XL,0x07			;color scheme (white on black)
		libmio_setcolor
		libmio_thistext
		.db 20,1,"Checksum: ",0,0
	    	rcall	confp_chksum	

;------------------------------------------------------------------------------
;the main loop
;------------------------------------------------------------------------------

confp_main_02:	rcall	confp_kbdtype		;keyboard list
		rcall	confp_sertype		;serial port
		rcall	confp_twitype		;parallel port
		rcall	confp_spitype
		rcall	confp_eeadr
		ldi	ZL,LOW(confp_mbar*2)
		ldi	ZH,HIGH(confp_mbar*2)
		clt				;read menu from flash
		libmio_menu
			
;------------------------------------------------------------------------------
;esc key
;------------------------------------------------------------------------------
confp_main_30:	cpi	tempreg1,0x01		;esc
		brne	confp_main_50
		rjmp	confp_wnk		;wait for no key and exit
		
;------------------------------------------------------------------------------
;F1 key (change keyboard layout)
;------------------------------------------------------------------------------
confp_main_50:	cpi	tempreg1,0x02		;F1
		brne	confp_main_55
		lds	tempreg1,libmio_sysconf	;recent conf
		ldi	tempreg2,0x01
		eor	tempreg1,tempreg2
		sts	libmio_sysconf,tempreg1
		call	mem_setconf
		call	confp_wnk
		rjmp	confp_main_02

;------------------------------------------------------------------------------
;F2 key (change serial speed)
;------------------------------------------------------------------------------
confp_main_55:	cpi	tempreg1,0x03		;F2
		brne	confp_main_60
		lds	tempreg1,libmio_sysconf	;recent conf
		ldi	tempreg2,0x02
		eor	tempreg1,tempreg2
		sts	libmio_sysconf,tempreg1
		call	mem_setconf
		call	confp_wnk
		rjmp	confp_main_02


;------------------------------------------------------------------------------
;F3 key (change I2C speed)
;------------------------------------------------------------------------------
confp_main_60:	cpi	tempreg1,0x04		;F3
		brne	confp_main_65
		lds	tempreg1,libmio_sysconf	;recent conf
		ldi	tempreg2,0x04
		eor	tempreg1,tempreg2
		sts	libmio_sysconf,tempreg1
		call	mem_setconf
		call	confp_wnk
		rjmp	confp_main_02

;------------------------------------------------------------------------------
;F4 key (change SPI speed)
;------------------------------------------------------------------------------
confp_main_65:	cpi	tempreg1,0x05		;F4
		brne	confp_main_70
		lds	tempreg1,libmio_sysconf	;recent conf
		ldi	tempreg2,0x08
		eor	tempreg1,tempreg2
		sts	libmio_sysconf,tempreg1
		call	mem_setconf
		call	confp_wnk
		rjmp	confp_main_02

;------------------------------------------------------------------------------
;F4 key (change Data EEPROM address)
;------------------------------------------------------------------------------
confp_main_70:	cpi	tempreg1,0x07		;F4
		brne	confp_main_80
		call	mem_getconf1
		inc	tempreg1
		andi	tempreg1,0x07
		call	mem_setconf1
		call	confp_wnk
		rjmp	confp_main_02

;------------------------------------------------------------------------------
;ctrl+F4 key
;------------------------------------------------------------------------------
confp_main_80:	cpi	tempreg1,0x0a		;ctrl-F4
		brne	confp_main_90
		call	clone_main
confp_main_90:	rjmp	confp_main


;------------------------------------------------------------------------------
;show keyboard layout
;------------------------------------------------------------------------------
confp_kbdtype: 	ldi	XL,0x06			;color scheme (yellow on black)
		libmio_setcolor
		libmio_thistext
		.db 3,1,"Keyboard layout:",0,0
		ldi	XL,0x07			;white on black
		lds	tempreg1,libmio_sysconf	;get active layout
		andi	tempreg1,0x01
		brne	confp_kbdtype1
		ldi	XL,0x71			;blue on white
confp_kbdtype1:	libmio_setcolor
	 	libmio_thistext
		.db 3,18,"DE (QWERTZ)",0

		ldi	XL,0x07			;white on black
		lds	tempreg1,libmio_sysconf	;get active layout
		andi	tempreg1,0x01
		breq	confp_kbdtype2
		ldi	XL,0x71			;blue on white
confp_kbdtype2:	libmio_setcolor
	 	libmio_thistext
		.db 4,18,"US (QWERTY)",0
		ldi	XL,0x07			;color scheme (white on black)
		libmio_setcolor
	    	ret

;------------------------------------------------------------------------------
;show serial speed
;------------------------------------------------------------------------------
confp_sertype: 	ldi	XL,0x06			;color scheme (yellow on black)
		libmio_setcolor
		libmio_thistext
		.db 6,1,"Serial speed:",0
	    	ldi	XL,0x07			;white on blue
		lds	tempreg1,libmio_sysconf	;get active layout
		andi	tempreg1,0x02
		brne	confp_sertype1
		ldi	XL,0x71			;blue on white
confp_sertype1:	libmio_setcolor
	 	libmio_thistext
		.db 6,18," 1200 Bps  ",0

	    	ldi	XL,0x07			;white on blue
		lds	tempreg1,libmio_sysconf	;get active layout
		andi	tempreg1,0x02
		breq	confp_sertype2
		ldi	XL,0x71			;blue on white
confp_sertype2:	libmio_setcolor
	 	libmio_thistext
		.db 7,18," 2400 Bps  ",0
		ldi	XL,0x07			;color scheme (white on black)
		libmio_setcolor
	    	ret

;------------------------------------------------------------------------------
;show I2C speed
;------------------------------------------------------------------------------
confp_twitype: 	ldi	XL,0x06			;color scheme (yellow on black)
		libmio_setcolor
		libmio_thistext
		.db 9,1,"I2C speed:",0,0
	    	ldi	XL,0x07			;white on blue
		lds	tempreg1,libmio_sysconf	;get active layout
		andi	tempreg1,0x04
		brne	confp_twitype1
		ldi	XL,0x71			;blue on white
confp_twitype1:	libmio_setcolor
	 	libmio_thistext
		.db 9,18,"  100 kHz  ",0

	    	ldi	XL,0x07			;white on blue
		lds	tempreg1,libmio_sysconf	;get active layout
		andi	tempreg1,0x04
		breq	confp_twitype2
		ldi	XL,0x71			;blue on white
confp_twitype2:	libmio_setcolor
	 	libmio_thistext
		.db 10,18,"  400 kHz  ",0
		ldi	XL,0x07			;color scheme (white on black)
		libmio_setcolor
	    	ret

;------------------------------------------------------------------------------
;show SPI speed
;------------------------------------------------------------------------------
confp_spitype: 	ldi	XL,0x06			;color scheme (yellow on black)
		libmio_setcolor
		libmio_thistext
		.db 12,1,"SPI speed:",0,0
	    	ldi	XL,0x07			;white on blue
		lds	tempreg1,libmio_sysconf	;get active layout
		andi	tempreg1,0x08
		brne	confp_spitype1
		ldi	XL,0x71			;blue on white
confp_spitype1:	libmio_setcolor
	 	libmio_thistext
		.db 12,18,"    5 MHz  ",0

	    	ldi	XL,0x07			;white on blue
		lds	tempreg1,libmio_sysconf	;get active layout
		andi	tempreg1,0x08
		breq	confp_spitype2
		ldi	XL,0x71			;blue on white
confp_spitype2:	libmio_setcolor
	 	libmio_thistext
		.db 13,18,"  156 kHz  ",0
		ldi	XL,0x07			;color scheme (white on black)
		libmio_setcolor
	    	ret

;------------------------------------------------------------------------------
;show EEPROM address
;------------------------------------------------------------------------------
confp_eeadr: 	ldi	XL,0x06			;color scheme (yellow on black)
		libmio_setcolor
		libmio_thistext
		.db 15,1,"EEPROM address:",0
	    	ldi	XL,0x71			;white on blue
		libmio_setcolor
	 	libmio_thistext
		.db 15,18,"     ",0
		call	mem_getconf1
		andi	tempreg1,0x07
		subi	tempreg1,0xd0
		libmio_outchar
	 	libmio_thistext
		.db 255,"     ",0,0		
	    	ldi	XL,0x70			;white on blue
		libmio_setcolor

		ret
		
;------------------------------------------------------------------------------
;wait for key release
;------------------------------------------------------------------------------
confp_wnk:	lds	XL,libmio_keycode
		cpi	XL,0
		brne	confp_wnk		;wait for key release
		ret

;------------------------------------------------------------------------------
;calc and output checksum
;------------------------------------------------------------------------------
confp_chksum:	clr	XL			;sum
		clr	XH
		clr	YL
		clr	YH
		clr	ZL			;ptr
		clr	ZH			
		
confp_chksum1:	lpm	r1,Z+
		ldi	tempreg1,2
		mul	r1,tempreg1
		add	XL,r0	
		adc	XH,r1
		adc	YL,const_0
		adc	YH,const_0
		lpm	tempreg1,Z+
		ldi	tempreg1,7
		mul	r1,tempreg1	
		add	XL,r0	
		adc	XH,r1
		adc	YL,const_0
		adc	YH,const_0
		cpi	ZH,HIGH(end_system*2)
		brne	confp_chksum1
		
		clr	ZL			;ptr
		ldi	ZH,$f0			;		
		
confp_chksum2:	lpm	tempreg1,Z+
		ldi	tempreg1,113
		mul	r1,tempreg1	
		adc	XH,r0
		adc	YL,r1
		adc	YH,const_0
		lpm	tempreg1,Z+
		ldi	tempreg1,7
		mul	r1,tempreg1	
		adc	XH,r0
		adc	YL,r1
		adc	YH,const_0
		cpi	ZH,0x00
		brne	confp_chksum2
		push	XH
		push	XL
		movw	XL,YL
		ldi	ctrl,0x0f
		libmio_outhex
		pop	XL
		pop	XH
		libmio_outhex
		ret	

;------------------------------------------------------------------------------
;the configpage menubar
;------------------------------------------------------------------------------
		;   "111111222222333333444444555555"
confp_mbar:	.db " Exit  Keyb  Ser   I2C   SPI  "
		.db "      EEPROM            Clone "				