;################################################################################
;#										#
;# avr-chipbasic2 - single chip basic computer with ATmega644			#
;# dataflash file manager 							#
;# copyright (c) 2006-2008 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 2		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;------------------------------------------------------------------------------
;main screen mask
;------------------------------------------------------------------------------
fman_main:	sts	libmio_channel,const_0	;output to screen
		sts	libmio_vidmode,const_0	;standard video mode
		ldi	XL,0x05			;color scheme (cyan on black)
		libmio_setcolor
		ldi	YL,0			;maximal sized box
		ldi	YH,0
		ldi	ZL,29
		ldi	ZH,22
		libmio_whbox
		ldi	XL,0x50			;color scheme (cyan on black)
		libmio_setcolor
		libmio_thistext
		.db 1,2,"DFLASH size: ",0
		call	fsys_maxpage		;get flash status
		
fman_main_001:	cpi	tempreg1,0x7f		;0,5M
		brne	fman_main_002
		libmio_thistext
		.db 255,"512 KiByte",0
		rjmp	fman_main_02

fman_main_002:	cpi	tempreg1,0xff		;1M
		brne	fman_main_01
		libmio_thistext
		.db 255,"1 MiByte",0
		rjmp	fman_main_02

fman_main_01:	libmio_thistext
		.db 255,"0 Byte",0
		rjmp	fman_main_x2

fman_main_02:	call	fsys_checkf		;test for valid format
		cpi	tempreg1,0x01		;OK
		breq	fman_main_03
fman_mainf_1:	ldi	ZL,LOW(fman_txt2*2)
		ldi	ZH,HIGH(fman_txt2*2)
		clt				;data from Flash
		libmio_menu			
		cpi	tempreg1,0x01		;ESC
		brne	fman_mainf_2
		rjmp	fman_wnk		;wait for no key and exit
fman_mainf_2:	cpi	tempreg1,0x05		;F4=rescan
		brne	fman_mainf_3
		rjmp	fman_main
fman_mainf_3:	cpi	tempreg1,0x02		;F1=format
		brne	fman_mainf_1
		rcall	fman_fmt		;format
		rjmp	fman_main

fman_main_x2:	ldi	ZL,LOW(fman_txt3*2)
		ldi	ZH,HIGH(fman_txt3*2)
		clt				;data from Flash
		libmio_menu			
		cpi	tempreg1,0x01		;ESC
		brne	fman_main_x4
		rjmp	fman_wnk		;wait for no key and exit
fman_main_x4:	cpi	tempreg1,0x05		;rescan
		brne	fman_main_x2
		rjmp	fman_main


;------------------------------------------------------------------------------
;the main loop
;------------------------------------------------------------------------------
fman_main_03:	ldi	ZL,LOW(fman_txt1*2)
		ldi	ZH,HIGH(fman_txt1*2)
		clt				;data from Flash
		libmio_menu			
	
;------------------------------------------------------------------------------
;esc key
;------------------------------------------------------------------------------
fman_main_30:	cpi	tempreg1,0x01		;esc
		brne	fman_main_c0
		rjmp	fman_wnk		;wait for no key and exit
		
;------------------------------------------------------------------------------
;CTRL+F1 key (delete)
;------------------------------------------------------------------------------
fman_main_c0:	cpi	tempreg1,0x07		;F1
		brne	fman_main_d0
		call	fsys_del		
		rjmp	fman_main

;------------------------------------------------------------------------------
;CTRL+F4 key (format)
;------------------------------------------------------------------------------
fman_main_d0:	cpi	tempreg1,0x0a		;F4
		brne	fman_main_50
		rcall	fman_fmt		;format
		rjmp	fman_main		;restart		
		
;------------------------------------------------------------------------------
;F1 key (info)
;------------------------------------------------------------------------------
fman_main_50:	cpi	tempreg1,0x02		;F1
		brne	fman_main_60
		rcall	fman_info		
		rjmp	fman_main

;------------------------------------------------------------------------------
;F2 key (backup)
;------------------------------------------------------------------------------
fman_main_60:	cpi	tempreg1,0x03		;F2
		brne	fman_main_70
		call	fsys_backup		
		rjmp	fman_main

;------------------------------------------------------------------------------
;F3 key (restore)
;------------------------------------------------------------------------------
fman_main_70:	cpi	tempreg1,0x04		;F3
		brne	fman_main_80
		call	fsys_restore
		rjmp	fman_main

;------------------------------------------------------------------------------
;F4 key (rescan)
;------------------------------------------------------------------------------
fman_main_80:	cpi	tempreg1,0x05		;F4
		brne	fman_main_03
		rjmp	fman_main
	
;------------------------------------------------------------------------------
;wait for key release
;------------------------------------------------------------------------------
fman_wnk:	lds	XL,libmio_keycode
		cpi	XL,0
		brne	fman_wnk		;wait for key release
		ret

;------------------------------------------------------------------------------
;format medium 
;------------------------------------------------------------------------------
fman_fmt:	libmio_askthis
		.db	0x4f,"Format Medium?",0	;show message
		cpi	tempreg1,0x01
		breq	fman_fmt_1
		ret	
	
fman_fmt_1:	ldi	XL,0x26			;color scheme (yellow on red)
		libmio_setcolor
		ldi	YL,0x02
		ldi	YH,0x08
		ldi	ZL,0x1b
		ldi	ZH,0x0c
		libmio_wbox		
		libmio_thistext
		.db 9,3,"Formatting...      ",0	;show message
		libmio_thistext
		.db 11,3,0,0			;sst cursor
		call	fsys_format
		cpi	ereg,0x00		;error?
		brne	fman_fmt_err
fman_fmt_2:	libmio_thistext
		.db 9,3,"Formatting... Done!",0	;show message
fman_fmt_3:	ldi	XL,0x72			;color scheme (red on white)
		libmio_setcolor
		libmio_thistext
		.db 11,3,"   Press any key!  "0,0	;sst cursor
		libmio_waitkey
		ret

fman_fmt_err:	libmio_thistext
		.db 9,3,"Formatting... Error!",0,0	;show message
		rjmp	fman_fmt_3

;------------------------------------------------------------------------------
;medium info 
;------------------------------------------------------------------------------
fman_info:	ldi	XL,0x60			;color scheme (black on yellow)
		libmio_setcolor
		ldi	YL,4			;alert box
		ldi	YH,8
		ldi	ZL,25
		ldi	ZH,13
		libmio_wbox
		libmio_thistext
		.db 9,5,"Available:",0,0	;show message
		libmio_thistext
		.db 10,5,"Files: ",0		;show message
		ldi	ctrl,0x0c		;set format
		call	fsys_free
		push	YH			;save free pages
		push	YL
		movw	XL,ZL			;copy free files
		libmio_outdez
		libmio_thistext
		.db 255," /",0
		call	fsys_maxpage
		mov	XL,tempreg1
		ldi	XH,0x00
		adiw	XL,1
		libmio_outdez

fman_info_2:	libmio_thistext
		.db 11,5,"Blocks:",0		;show message
		pop	XL			;copy free data pages
		pop	XH
		libmio_outdez
		libmio_thistext
		.db 255," /",0		
		call	fsys_size
		ldi	XL,0xf0			;240
		mul	XL,tempreg1
		movw	XL,r0			;size
		sbiw	XL,0x01			;-1
		cpi	XH,0x00
		brne	fman_info_2a
		sbiw	XL,0x03
fman_info_2a:	libmio_outdez
fman_info_4:	ldi	XL,0x06			;color scheme (inv. black on yellow)
		libmio_setcolor
		libmio_thistext
		.db 12,5,"   Press any key!  "0,0	;sst cursor
		libmio_waitkey
		ret

		
fman_txt1:	.db " Exit  Info BackupRestorRescan"
		.db "      Delete            Format"

fman_txt2:	.db " Exit Format            Rescan"
		.db "                              "	
		
fman_txt3:	.db " Exit                   Rescan"
		.db "                              "	
	